/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MeterBandCodec
extends JsonCodec<Band> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String TYPE = "type";
    private static final String RATE = "rate";
    private static final String BURST_SIZE = "burstSize";
    private static final String PREC = "prec";
    private static final String PACKETS = "packets";
    private static final String BYTES = "bytes";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in Band";

    public ObjectNode encode(Band band, CodecContext context) {
        Preconditions.checkNotNull((Object)band, (Object)"Band cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(TYPE, band.type().toString()).put(RATE, band.rate()).put(PACKETS, band.packets()).put(BYTES, band.bytes()).put(BURST_SIZE, band.burst());
        if (band.dropPrecedence() != null) {
            result.put(PREC, band.dropPrecedence());
        }
        return result;
    }

    public Band decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        DefaultBand.Builder builder = DefaultBand.builder();
        long rate = ((JsonNode)Tools.nullIsIllegal((Object)json.get(RATE), (String)"rate member is required in Band")).asLong();
        builder.withRate(rate);
        long burstSize = ((JsonNode)Tools.nullIsIllegal((Object)json.get(BURST_SIZE), (String)"burstSize member is required in Band")).asLong();
        builder.burstSize(burstSize);
        Short precedence = null;
        String typeStr = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TYPE), (String)"type member is required in Band")).asText();
        Band.Type type = null;
        switch (typeStr) {
            case "DROP": {
                type = Band.Type.DROP;
                builder.ofType(type);
                break;
            }
            case "REMARK": {
                type = Band.Type.REMARK;
                precedence = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get(PREC), (String)"prec member is required in Band")).asInt();
                builder.ofType(type);
                builder.dropPrecedence(precedence.shortValue());
                break;
            }
            default: {
                Tools.nullIsIllegal((Object)type, (String)("The requested type " + typeStr + " is not defined for band."));
            }
        }
        Band band = builder.build();
        return band;
    }
}

