/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.cluster.NodeId;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.mastership.MastershipTerm;

public class MastershipTermCodec
extends JsonCodec<MastershipTerm> {
    private static final String MASTER = "master";
    private static final String TERM_NUMBER = "termNumber";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in MastershipTerm";

    public ObjectNode encode(MastershipTerm term, CodecContext context) {
        Preconditions.checkNotNull((Object)term, (Object)"Mastership term cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(MASTER, (String)term.master().id()).put(TERM_NUMBER, term.termNumber());
        return result;
    }

    public MastershipTerm decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        NodeId nodeId = NodeId.nodeId((String)((JsonNode)Tools.nullIsIllegal((Object)json.get(MASTER), (String)"master member is required in MastershipTerm")).asText());
        long termNumber = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TERM_NUMBER), (String)"termNumber member is required in MastershipTerm")).asLong();
        return MastershipTerm.of((NodeId)nodeId, (long)termNumber);
    }
}

