/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.MastershipRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MastershipRoleCodec
extends JsonCodec<MastershipRole> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ROLE = "role";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in MastershipRole";

    public ObjectNode encode(MastershipRole mastershipRole, CodecContext context) {
        Preconditions.checkNotNull((Object)mastershipRole, (Object)"MastershipRole cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(ROLE, mastershipRole.name());
        return result;
    }

    public MastershipRole decode(ObjectNode json, CodecContext context) {
        MastershipRole mastershipRole;
        String roleJson;
        if (json == null || !json.isObject()) {
            return null;
        }
        switch (roleJson = ((JsonNode)Tools.nullIsIllegal((Object)json.get(ROLE), (String)"role member is required in MastershipRole")).asText()) {
            case "MASTER": {
                mastershipRole = MastershipRole.MASTER;
                break;
            }
            case "STANDBY": {
                mastershipRole = MastershipRole.STANDBY;
                break;
            }
            case "NONE": {
                mastershipRole = MastershipRole.NONE;
                break;
            }
            default: {
                this.log.warn("The mastership role {} is not defined.", (Object)roleJson);
                return null;
            }
        }
        return mastershipRole;
    }
}

