/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.AnnotatedCodec;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Link;
import org.onosproject.net.provider.ProviderId;

public final class LinkCodec
extends AnnotatedCodec<Link> {
    private static final String SRC = "src";
    private static final String DST = "dst";
    private static final String TYPE = "type";
    private static final String STATE = "state";

    public ObjectNode encode(Link link, CodecContext context) {
        Preconditions.checkNotNull((Object)link, (Object)"Link cannot be null");
        JsonCodec codec = context.codec(ConnectPoint.class);
        ObjectNode result = context.mapper().createObjectNode();
        result.set(SRC, (JsonNode)codec.encode((Object)link.src(), context));
        result.set(DST, (JsonNode)codec.encode((Object)link.dst(), context));
        result.put(TYPE, link.type().toString());
        if (link.state() != null) {
            result.put(STATE, link.state().toString());
        }
        return this.annotate(result, link, context);
    }

    public Link decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        JsonCodec codec = context.codec(ConnectPoint.class);
        ProviderId pid = new ProviderId("json", "LinkCodec");
        ConnectPoint src = (ConnectPoint)codec.decode(LinkCodec.get((ObjectNode)json, (String)SRC), context);
        ConnectPoint dst = (ConnectPoint)codec.decode(LinkCodec.get((ObjectNode)json, (String)DST), context);
        Link.Type type = Link.Type.valueOf((String)json.get(TYPE).asText());
        Annotations annotations = this.extractAnnotations(json, context);
        return DefaultLink.builder().providerId(pid).src(src).dst(dst).type(type).annotations(annotations).build();
    }
}

