/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.net.UrlEscapers;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;

public final class IntentCodec
extends JsonCodec<Intent> {
    protected static final String TYPE = "type";
    protected static final String ID = "id";
    protected static final String APP_ID = "appId";
    protected static final String STATE = "state";
    protected static final String PRIORITY = "priority";
    protected static final String RESOURCES = "resources";
    protected static final String RESOURCE_GROUP = "resourceGroup";
    protected static final String MISSING_MEMBER_MESSAGE = " member is required in Intent";
    private static final String E_APP_ID_NOT_FOUND = "Application ID is not found";

    public ObjectNode encode(Intent intent, CodecContext context) {
        Preconditions.checkNotNull((Object)intent, (Object)"Intent cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(TYPE, intent.getClass().getSimpleName()).put(ID, intent.id().toString()).put(APP_ID, UrlEscapers.urlPathSegmentEscaper().escape(intent.appId().name()));
        if (intent.resourceGroup() != null) {
            result.put(RESOURCE_GROUP, intent.resourceGroup().toString());
        }
        ArrayNode jsonResources = result.putArray(RESOURCES);
        for (NetworkResource resource : intent.resources()) {
            jsonResources.add(resource.toString());
        }
        IntentService service = (IntentService)context.getService(IntentService.class);
        IntentState state = service.getIntentState(intent.key());
        if (state != null) {
            result.put(STATE, state.toString());
        }
        return result;
    }

    public Intent decode(ObjectNode json, CodecContext context) {
        Preconditions.checkNotNull((Object)json, (Object)"JSON cannot be null");
        String type = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TYPE), (String)"type member is required in Intent")).asText();
        if (type.equals(PointToPointIntent.class.getSimpleName())) {
            return (Intent)context.codec(PointToPointIntent.class).decode(json, context);
        }
        if (type.equals(HostToHostIntent.class.getSimpleName())) {
            return (Intent)context.codec(HostToHostIntent.class).decode(json, context);
        }
        if (type.equals(SinglePointToMultiPointIntent.class.getSimpleName())) {
            return (Intent)context.codec(SinglePointToMultiPointIntent.class).decode(json, context);
        }
        throw new IllegalArgumentException("Intent type " + type + " is not supported");
    }

    public static void intentAttributes(ObjectNode json, CodecContext context, Intent.Builder builder) {
        JsonNode resourceGroup;
        String appId = ((JsonNode)Tools.nullIsIllegal((Object)json.get(APP_ID), (String)"appId member is required in Intent")).asText();
        CoreService service = (CoreService)context.getService(CoreService.class);
        builder.appId((ApplicationId)Tools.nullIsNotFound((Object)service.getAppId(appId), (String)E_APP_ID_NOT_FOUND));
        JsonNode priorityJson = json.get(PRIORITY);
        if (priorityJson != null) {
            builder.priority(priorityJson.asInt());
        }
        if ((resourceGroup = json.get(RESOURCE_GROUP)) != null) {
            String resourceGroupId = resourceGroup.asText();
            builder.resourceGroup(ResourceGroup.of((long)Long.parseUnsignedLong(resourceGroupId.substring(2), 16)));
        }
    }
}

