/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.DecodeInstructionCodecHelper;
import org.onosproject.codec.impl.EncodeInstructionCodecHelper;
import org.onosproject.net.flow.instructions.Instruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstructionCodec
extends JsonCodec<Instruction> {
    protected static final Logger log = LoggerFactory.getLogger(InstructionCodec.class);
    protected static final String TYPE = "type";
    protected static final String SUBTYPE = "subtype";
    protected static final String PORT = "port";
    protected static final String MAC = "mac";
    protected static final String VLAN_ID = "vlanId";
    protected static final String VLAN_PCP = "vlanPcp";
    protected static final String MPLS_LABEL = "label";
    protected static final String MPLS_BOS = "bos";
    protected static final String IP = "ip";
    protected static final String FLOW_LABEL = "flowLabel";
    protected static final String LAMBDA = "lambda";
    protected static final String GRID_TYPE = "gridType";
    protected static final String CHANNEL_SPACING = "channelSpacing";
    protected static final String SPACING_MULTIPLIER = "spacingMultiplier";
    protected static final String SLOT_GRANULARITY = "slotGranularity";
    protected static final String ETHERNET_TYPE = "ethernetType";
    protected static final String TUNNEL_ID = "tunnelId";
    protected static final String TCP_PORT = "tcpPort";
    protected static final String UDP_PORT = "udpPort";
    protected static final String TABLE_ID = "tableId";
    protected static final String GROUP_ID = "groupId";
    protected static final String METER_ID = "meterId";
    protected static final String QUEUE_ID = "queueId";
    protected static final String TRIBUTARY_PORT_NUMBER = "tributaryPortNumber";
    protected static final String TRIBUTARY_SLOT_LEN = "tributarySlotLength";
    protected static final String TRIBUTARY_SLOT_BITMAP = "tributarySlotBitmap";
    protected static final String EXTENSION = "extension";
    protected static final String DEVICE_ID = "deviceId";
    protected static final String MISSING_MEMBER_MESSAGE = " member is required in Instruction";
    protected static final String ERROR_MESSAGE = " not specified in Instruction";

    public ObjectNode encode(Instruction instruction, CodecContext context) {
        Preconditions.checkNotNull((Object)instruction, (Object)"Instruction cannot be null");
        return new EncodeInstructionCodecHelper(instruction, context).encode();
    }

    public Instruction decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        return new DecodeInstructionCodecHelper(json, context).decode();
    }
}

