/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.ConnectivityIntentCodec;
import org.onosproject.codec.impl.IntentCodec;
import org.onosproject.net.HostId;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;

public final class HostToHostIntentCodec
extends JsonCodec<HostToHostIntent> {
    private static final String ONE = "one";
    private static final String TWO = "two";

    public ObjectNode encode(HostToHostIntent intent, CodecContext context) {
        Preconditions.checkNotNull((Object)intent, (Object)"Host to host intent cannot be null");
        JsonCodec connectivityIntentCodec = context.codec(ConnectivityIntent.class);
        ObjectNode result = connectivityIntentCodec.encode((Object)intent, context);
        String one = intent.one().toString();
        String two = intent.two().toString();
        result.put(ONE, one);
        result.put(TWO, two);
        return result;
    }

    public HostToHostIntent decode(ObjectNode json, CodecContext context) {
        HostToHostIntent.Builder builder = HostToHostIntent.builder();
        IntentCodec.intentAttributes(json, context, (Intent.Builder)builder);
        ConnectivityIntentCodec.intentAttributes(json, context, (ConnectivityIntent.Builder)builder);
        String one = ((JsonNode)Tools.nullIsIllegal((Object)json.get(ONE), (String)"one member is required in Intent")).asText();
        builder.one(HostId.hostId((String)one));
        String two = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TWO), (String)"two member is required in Intent")).asText();
        builder.two(HostId.hostId((String)two));
        return builder.build();
    }
}

