/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.packet.IpAddress;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.AnnotatedCodec;
import org.onosproject.net.Host;
import org.onosproject.net.HostLocation;

public final class HostCodec
extends AnnotatedCodec<Host> {
    public ObjectNode encode(Host host, CodecContext context) {
        Preconditions.checkNotNull((Object)host, (Object)"Host cannot be null");
        JsonCodec locationCodec = context.codec(HostLocation.class);
        ObjectNode result = context.mapper().createObjectNode().put("id", host.id().toString()).put("mac", host.mac().toString()).put("vlan", host.vlan().toString()).put("configured", host.configured());
        ArrayNode jsonIpAddresses = result.putArray("ipAddresses");
        for (IpAddress ipAddress : host.ipAddresses()) {
            jsonIpAddresses.add(ipAddress.toString());
        }
        result.set("ipAddresses", (JsonNode)jsonIpAddresses);
        result.set("location", (JsonNode)locationCodec.encode((Object)host.location(), context));
        return this.annotate(result, host, context);
    }
}

