/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.onlab.util.HexString;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.group.DefaultGroup;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupCodec
extends JsonCodec<Group> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ID = "id";
    private static final String STATE = "state";
    private static final String LIFE = "life";
    private static final String PACKETS = "packets";
    private static final String BYTES = "bytes";
    private static final String REFERENCE_COUNT = "referenceCount";
    private static final String TYPE = "type";
    private static final String GROUP_ID = "groupId";
    private static final String DEVICE_ID = "deviceId";
    private static final String APP_ID = "appId";
    private static final String APP_COOKIE = "appCookie";
    private static final String GIVEN_GROUP_ID = "givenGroupId";
    private static final String BUCKETS = "buckets";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in Group";
    public static final String REST_APP_ID = "org.onosproject.rest";

    public ObjectNode encode(Group group, CodecContext context) {
        Preconditions.checkNotNull((Object)group, (Object)"Group cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(ID, ((Integer)group.id().id()).toString()).put(STATE, group.state().toString()).put(LIFE, group.life()).put(PACKETS, group.packets()).put(BYTES, group.bytes()).put(REFERENCE_COUNT, group.referenceCount()).put(TYPE, group.type().toString()).put(DEVICE_ID, group.deviceId().toString());
        if (group.appId() != null) {
            result.put(APP_ID, group.appId().name());
        }
        if (group.appCookie() != null) {
            result.put(APP_COOKIE, group.appCookie().toString());
        }
        if (group.givenGroupId() != null) {
            result.put(GIVEN_GROUP_ID, group.givenGroupId().toString());
        }
        ArrayNode buckets = context.mapper().createArrayNode();
        group.buckets().buckets().forEach(bucket -> {
            ObjectNode bucketJson = context.codec(GroupBucket.class).encode(bucket, context);
            buckets.add((JsonNode)bucketJson);
        });
        result.set(BUCKETS, (JsonNode)buckets);
        return result;
    }

    public Group decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        JsonCodec groupBucketCodec = context.codec(GroupBucket.class);
        CoreService coreService = (CoreService)context.getService(CoreService.class);
        int groupIdInt = ((JsonNode)Tools.nullIsIllegal((Object)json.get(GROUP_ID), (String)"groupId member is required in Group")).asInt();
        GroupId groupId = new GroupId(groupIdInt);
        String groupKeyStr = ((JsonNode)Tools.nullIsIllegal((Object)json.get(APP_COOKIE), (String)"appCookie member is required in Group")).asText();
        if (!groupKeyStr.startsWith("0x")) {
            throw new IllegalArgumentException("APP_COOKIE must be a hex string starts with 0x");
        }
        DefaultGroupKey groupKey = new DefaultGroupKey(HexString.fromHexString((String)groupKeyStr.split("0x")[1], (String)""));
        DeviceId deviceId = DeviceId.deviceId((String)((JsonNode)Tools.nullIsIllegal((Object)json.get(DEVICE_ID), (String)"deviceId member is required in Group")).asText());
        ApplicationId appId = coreService.registerApplication(REST_APP_ID);
        String type = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TYPE), (String)"type member is required in Group")).asText();
        GroupDescription.Type groupType = null;
        switch (type) {
            case "SELECT": {
                groupType = GroupDescription.Type.SELECT;
                break;
            }
            case "INDIRECT": {
                groupType = GroupDescription.Type.INDIRECT;
                break;
            }
            case "ALL": {
                groupType = GroupDescription.Type.ALL;
                break;
            }
            case "FAILOVER": {
                groupType = GroupDescription.Type.FAILOVER;
                break;
            }
            default: {
                Tools.nullIsIllegal((Object)groupType, (String)("The requested group type " + type + " is not valid"));
            }
        }
        GroupBuckets buckets = null;
        ArrayList groupBucketList = new ArrayList();
        JsonNode bucketsJson = json.get(BUCKETS);
        Preconditions.checkNotNull((Object)bucketsJson);
        if (bucketsJson != null) {
            IntStream.range(0, bucketsJson.size()).forEach(i -> {
                ObjectNode bucketJson = GroupCodec.get((JsonNode)bucketsJson, (int)i);
                bucketJson.put(TYPE, type);
                groupBucketList.add(groupBucketCodec.decode(bucketJson, context));
            });
            buckets = new GroupBuckets(groupBucketList);
        }
        DefaultGroupDescription groupDescription = new DefaultGroupDescription(deviceId, groupType, buckets, (GroupKey)groupKey, Integer.valueOf(groupIdInt), appId);
        return new DefaultGroup(groupId, (GroupDescription)groupDescription);
    }
}

