/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.GroupId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.GroupBucket;

public class GroupBucketCodec
extends JsonCodec<GroupBucket> {
    private static final String TYPE = "type";
    private static final String TREATMENT = "treatment";
    private static final String WEIGHT = "weight";
    private static final String WATCH_PORT = "watchPort";
    private static final String WATCH_GROUP = "watchGroup";
    private static final String PACKETS = "packets";
    private static final String BYTES = "bytes";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in Group";

    public ObjectNode encode(GroupBucket bucket, CodecContext context) {
        Preconditions.checkNotNull((Object)bucket, (Object)"Driver cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(TYPE, bucket.type().toString()).put(WEIGHT, bucket.weight()).put(PACKETS, bucket.packets()).put(BYTES, bucket.bytes());
        if (bucket.watchPort() != null) {
            result.put(WATCH_PORT, bucket.watchPort().toString());
        }
        if (bucket.watchGroup() != null) {
            result.put(WATCH_GROUP, bucket.watchGroup().toString());
        }
        if (bucket.treatment() != null) {
            result.set(TREATMENT, (JsonNode)context.codec(TrafficTreatment.class).encode((Object)bucket.treatment(), context));
        }
        return result;
    }

    public GroupBucket decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        ObjectNode treatmentJson = GroupBucketCodec.get((ObjectNode)json, (String)TREATMENT);
        TrafficTreatment trafficTreatment = null;
        if (treatmentJson != null) {
            JsonCodec treatmentCodec = context.codec(TrafficTreatment.class);
            trafficTreatment = (TrafficTreatment)treatmentCodec.decode(treatmentJson, context);
        }
        String type = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TYPE), (String)"type member is required in Group")).asText();
        GroupBucket groupBucket = null;
        switch (type) {
            case "SELECT": {
                int weightInt = ((JsonNode)Tools.nullIsIllegal((Object)json.get(WEIGHT), (String)"weight member is required in Group")).asInt();
                groupBucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)trafficTreatment, (short)((short)weightInt));
                break;
            }
            case "INDIRECT": {
                groupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)trafficTreatment);
                break;
            }
            case "ALL": {
                groupBucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)trafficTreatment);
                break;
            }
            case "FAILOVER": {
                PortNumber watchPort = PortNumber.portNumber((String)((JsonNode)Tools.nullIsIllegal((Object)json.get(WATCH_PORT), (String)"watchPort member is required in Group")).asText());
                int groupIdInt = ((JsonNode)Tools.nullIsIllegal((Object)json.get(WATCH_GROUP), (String)"watchGroup member is required in Group")).asInt();
                GroupId watchGroup = new GroupId((int)((short)groupIdInt));
                groupBucket = DefaultGroupBucket.createFailoverGroupBucket((TrafficTreatment)trafficTreatment, (PortNumber)watchPort, (GroupId)watchGroup);
                break;
            }
            default: {
                DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)trafficTreatment);
            }
        }
        return groupBucket;
    }
}

