/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.ObjectiveCodecHelper;
import org.onosproject.core.CoreService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ForwardingObjectiveCodec
extends JsonCodec<ForwardingObjective> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ID = "id";
    private static final String APP_ID = "appId";
    private static final String SELECTOR = "selector";
    private static final String FLAG = "flag";
    private static final String OPERATION = "operation";
    private static final String NEXT_ID = "nextId";
    private static final String TREATMENT = "treatment";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in ForwardingObjective";
    private static final String NOT_NULL_MESSAGE = "ForwardingObjective cannot be null";
    public static final String REST_APP_ID = "org.onosproject.rest";

    public ObjectNode encode(ForwardingObjective forwardingObjective, CodecContext context) {
        Preconditions.checkNotNull((Object)forwardingObjective, (Object)NOT_NULL_MESSAGE);
        JsonCodec trafficTreatmentCodec = context.codec(TrafficTreatment.class);
        JsonCodec trafficSelectorCodec = context.codec(TrafficSelector.class);
        ObjectiveCodecHelper och = new ObjectiveCodecHelper();
        ObjectNode result = och.encode((Objective)forwardingObjective, context);
        result.put(ID, forwardingObjective.id());
        result.put(FLAG, forwardingObjective.flag().toString());
        result.put(OPERATION, forwardingObjective.op().toString());
        ObjectNode trafficSelectorNode = trafficSelectorCodec.encode((Object)forwardingObjective.selector(), context);
        result.set(SELECTOR, (JsonNode)trafficSelectorNode);
        if (forwardingObjective.nextId() != null) {
            result.put(NEXT_ID, forwardingObjective.nextId());
        }
        if (forwardingObjective.treatment() != null) {
            ObjectNode trafficTreatmentNode = trafficTreatmentCodec.encode((Object)forwardingObjective.treatment(), context);
            result.set(TREATMENT, (JsonNode)trafficTreatmentNode);
        }
        return result;
    }

    public ForwardingObjective decode(ObjectNode json, CodecContext context) {
        JsonNode nextIdJson;
        JsonNode treatmentJson;
        String flagStr;
        if (json == null || !json.isObject()) {
            return null;
        }
        CoreService coreService = (CoreService)context.getService(CoreService.class);
        JsonCodec trafficTreatmentCodec = context.codec(TrafficTreatment.class);
        JsonCodec trafficSelectorCodec = context.codec(TrafficSelector.class);
        ObjectiveCodecHelper och = new ObjectiveCodecHelper();
        DefaultForwardingObjective.Builder baseBuilder = DefaultForwardingObjective.builder();
        DefaultForwardingObjective.Builder builder = (DefaultForwardingObjective.Builder)och.decode(json, (Objective.Builder)baseBuilder, context);
        JsonNode appIdJson = json.get(APP_ID);
        String appId = appIdJson != null ? appIdJson.asText() : REST_APP_ID;
        builder.fromApp(coreService.registerApplication(appId));
        switch (flagStr = ((JsonNode)Tools.nullIsIllegal((Object)json.get(FLAG), (String)"flag member is required in ForwardingObjective")).asText()) {
            case "SPECIFIC": {
                builder.withFlag(ForwardingObjective.Flag.SPECIFIC);
                break;
            }
            case "VERSATILE": {
                builder.withFlag(ForwardingObjective.Flag.VERSATILE);
                break;
            }
            default: {
                throw new IllegalArgumentException("The requested flag " + flagStr + " is not defined for FilteringObjective.");
            }
        }
        JsonNode selectorJson = json.get(SELECTOR);
        if (selectorJson != null) {
            TrafficSelector trafficSelector = (TrafficSelector)trafficSelectorCodec.decode((ObjectNode)selectorJson, context);
            builder.withSelector(trafficSelector);
        }
        if ((treatmentJson = json.get(TREATMENT)) != null) {
            TrafficTreatment trafficTreatment = (TrafficTreatment)trafficTreatmentCodec.decode((ObjectNode)treatmentJson, context);
            builder.withTreatment(trafficTreatment);
        }
        if ((nextIdJson = json.get(NEXT_ID)) != null) {
            builder.nextStep(nextIdJson.asInt());
        }
        String opStr = ((JsonNode)Tools.nullIsIllegal((Object)json.get(OPERATION), (String)"operation member is required in ForwardingObjective")).asText();
        ForwardingObjective forwardingObjective = null;
        switch (opStr) {
            case "ADD": {
                forwardingObjective = builder.add();
                break;
            }
            case "REMOVE": {
                forwardingObjective = builder.remove();
                break;
            }
            default: {
                throw new IllegalArgumentException("The requested operation " + opStr + " is not defined for FilteringObjective.");
            }
        }
        return forwardingObjective;
    }
}

