/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;

public final class FlowRuleCodec
extends JsonCodec<FlowRule> {
    private static final String PRIORITY = "priority";
    private static final String TIMEOUT = "timeout";
    private static final String IS_PERMANENT = "isPermanent";
    private static final String APP_ID = "appId";
    private static final String TABLE_ID = "tableId";
    private static final String DEVICE_ID = "deviceId";
    private static final String TREATMENT = "treatment";
    private static final String SELECTOR = "selector";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in FlowRule";
    public static final String REST_APP_ID = "org.onosproject.rest";

    public ObjectNode encode(FlowRule flowRule, CodecContext context) {
        Preconditions.checkNotNull((Object)flowRule, (Object)"Flow rule cannot be null");
        CoreService service = (CoreService)context.getService(CoreService.class);
        ApplicationId appId = service.getAppId(Short.valueOf(flowRule.appId()));
        String strAppId = appId == null ? "<none>" : appId.name();
        ObjectNode result = context.mapper().createObjectNode().put("id", Long.toString(flowRule.id().value())).put(TABLE_ID, flowRule.tableId()).put(APP_ID, strAppId).put(PRIORITY, flowRule.priority()).put(TIMEOUT, flowRule.timeout()).put(IS_PERMANENT, flowRule.isPermanent()).put(DEVICE_ID, flowRule.deviceId().toString());
        if (flowRule.treatment() != null) {
            JsonCodec treatmentCodec = context.codec(TrafficTreatment.class);
            result.set(TREATMENT, (JsonNode)treatmentCodec.encode((Object)flowRule.treatment(), context));
        }
        if (flowRule.selector() != null) {
            JsonCodec selectorCodec = context.codec(TrafficSelector.class);
            result.set(SELECTOR, (JsonNode)selectorCodec.encode((Object)flowRule.selector(), context));
        }
        return result;
    }

    public FlowRule decode(ObjectNode json, CodecContext context) {
        ObjectNode selectorJson;
        if (json == null || !json.isObject()) {
            return null;
        }
        DefaultFlowRule.Builder resultBuilder = new DefaultFlowRule.Builder();
        CoreService coreService = (CoreService)context.getService(CoreService.class);
        JsonNode appIdJson = json.get(APP_ID);
        String appId = appIdJson != null ? appIdJson.asText() : REST_APP_ID;
        resultBuilder.fromApp(coreService.registerApplication(appId));
        int priority = ((JsonNode)Tools.nullIsIllegal((Object)json.get(PRIORITY), (String)"priority member is required in FlowRule")).asInt();
        resultBuilder.withPriority(priority);
        boolean isPermanent = ((JsonNode)Tools.nullIsIllegal((Object)json.get(IS_PERMANENT), (String)"isPermanent member is required in FlowRule")).asBoolean();
        if (isPermanent) {
            resultBuilder.makePermanent();
        } else {
            resultBuilder.makeTemporary(((JsonNode)Tools.nullIsIllegal((Object)json.get(TIMEOUT), (String)"timeout member is required in FlowRule if the flow is temporary")).asInt());
        }
        JsonNode tableIdJson = json.get(TABLE_ID);
        if (tableIdJson != null) {
            resultBuilder.forTable(tableIdJson.asInt());
        }
        DeviceId deviceId = DeviceId.deviceId((String)((JsonNode)Tools.nullIsIllegal((Object)json.get(DEVICE_ID), (String)"deviceId member is required in FlowRule")).asText());
        resultBuilder.forDevice(deviceId);
        ObjectNode treatmentJson = FlowRuleCodec.get((ObjectNode)json, (String)TREATMENT);
        if (treatmentJson != null) {
            JsonCodec treatmentCodec = context.codec(TrafficTreatment.class);
            resultBuilder.withTreatment((TrafficTreatment)treatmentCodec.decode(treatmentJson, context));
        }
        if ((selectorJson = FlowRuleCodec.get((ObjectNode)json, (String)SELECTOR)) != null) {
            JsonCodec selectorCodec = context.codec(TrafficSelector.class);
            resultBuilder.withSelector((TrafficSelector)selectorCodec.decode(selectorJson, context));
        }
        return resultBuilder.build();
    }
}

