/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;

public final class FlowEntryCodec
extends JsonCodec<FlowEntry> {
    public ObjectNode encode(FlowEntry flowEntry, CodecContext context) {
        Preconditions.checkNotNull((Object)flowEntry, (Object)"Flow entry cannot be null");
        CoreService service = (CoreService)context.getService(CoreService.class);
        ApplicationId appId = service.getAppId(Short.valueOf(flowEntry.appId()));
        String strAppId = appId == null ? "<none>" : appId.name();
        ObjectNode result = context.mapper().createObjectNode().put("id", Long.toString(flowEntry.id().value())).put("tableId", flowEntry.tableId()).put("appId", strAppId).put("groupId", (Integer)flowEntry.groupId().id()).put("priority", flowEntry.priority()).put("timeout", flowEntry.timeout()).put("isPermanent", flowEntry.isPermanent()).put("deviceId", flowEntry.deviceId().toString()).put("state", flowEntry.state().toString()).put("life", flowEntry.life()).put("packets", flowEntry.packets()).put("bytes", flowEntry.bytes()).put("liveType", flowEntry.liveType().toString()).put("lastSeen", flowEntry.lastSeen());
        if (flowEntry.treatment() != null) {
            JsonCodec treatmentCodec = context.codec(TrafficTreatment.class);
            result.set("treatment", (JsonNode)treatmentCodec.encode((Object)flowEntry.treatment(), context));
        }
        if (flowEntry.selector() != null) {
            JsonCodec selectorCodec = context.codec(TrafficSelector.class);
            result.set("selector", (JsonNode)selectorCodec.encode((Object)flowEntry.selector(), context));
        }
        return result;
    }
}

