/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.stream.IntStream;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.ObjectiveCodecHelper;
import org.onosproject.core.CoreService;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.Objective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilteringObjectiveCodec
extends JsonCodec<FilteringObjective> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String KEY = "key";
    private static final String META = "meta";
    private static final String APP_ID = "appId";
    private static final String OPERATION = "operation";
    private static final String CONDITIONS = "conditions";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in FilteringObjective";
    private static final String NOT_NULL_MESSAGE = "FilteringObjective cannot be null";
    public static final String REST_APP_ID = "org.onosproject.rest";

    public ObjectNode encode(FilteringObjective filteringObjective, CodecContext context) {
        Preconditions.checkNotNull((Object)filteringObjective, (Object)NOT_NULL_MESSAGE);
        JsonCodec criterionCodec = context.codec(Criterion.class);
        JsonCodec trafficTreatmentCodec = context.codec(TrafficTreatment.class);
        ObjectiveCodecHelper och = new ObjectiveCodecHelper();
        ObjectNode result = och.encode((Objective)filteringObjective, context);
        result.put(ID, filteringObjective.id());
        result.put(TYPE, filteringObjective.type().toString());
        if (filteringObjective.key() != null) {
            ObjectNode criterionNode = criterionCodec.encode((Object)filteringObjective.key(), context);
            result.set(KEY, (JsonNode)criterionNode);
        }
        if (filteringObjective.meta() != null) {
            ObjectNode trafficTreatmentNode = trafficTreatmentCodec.encode((Object)filteringObjective.meta(), context);
            result.set(META, (JsonNode)trafficTreatmentNode);
        }
        ArrayNode conditions = context.mapper().createArrayNode();
        filteringObjective.conditions().forEach(c -> {
            ObjectNode criterionJson = criterionCodec.encode(c, context);
            conditions.add((JsonNode)criterionJson);
        });
        result.set(CONDITIONS, (JsonNode)conditions);
        return result;
    }

    public FilteringObjective decode(ObjectNode json, CodecContext context) {
        FilteringObjective filteringObjective;
        String opStr;
        JsonNode metaJson;
        String typeStr;
        if (json == null || !json.isObject()) {
            return null;
        }
        CoreService coreService = (CoreService)context.getService(CoreService.class);
        JsonCodec criterionCodec = context.codec(Criterion.class);
        JsonCodec trafficTreatmentCodec = context.codec(TrafficTreatment.class);
        ObjectiveCodecHelper och = new ObjectiveCodecHelper();
        DefaultFilteringObjective.Builder baseBuilder = DefaultFilteringObjective.builder();
        DefaultFilteringObjective.Builder builder = (DefaultFilteringObjective.Builder)och.decode(json, (Objective.Builder)baseBuilder, context);
        JsonNode appIdJson = json.get(APP_ID);
        String appId = appIdJson != null ? appIdJson.asText() : REST_APP_ID;
        builder.fromApp(coreService.registerApplication(appId));
        switch (typeStr = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TYPE), (String)"type member is required in FilteringObjective")).asText()) {
            case "PERMIT": {
                builder.permit();
                break;
            }
            case "DENY": {
                builder.deny();
                break;
            }
            default: {
                throw new IllegalArgumentException("The requested type " + typeStr + " is not defined for FilteringObjective.");
            }
        }
        JsonNode keyJson = json.get(KEY);
        if (keyJson != null) {
            Criterion key = (Criterion)criterionCodec.decode((ObjectNode)keyJson, context);
            builder.withKey(key);
        }
        JsonNode conditionsJson = json.get(CONDITIONS);
        Preconditions.checkNotNull((Object)conditionsJson);
        if (conditionsJson != null) {
            IntStream.range(0, conditionsJson.size()).forEach(i -> {
                ObjectNode conditionJson = FilteringObjectiveCodec.get((JsonNode)conditionsJson, (int)i);
                builder.addCondition((Criterion)criterionCodec.decode(conditionJson, context));
            });
        }
        if ((metaJson = json.get(META)) != null) {
            TrafficTreatment trafficTreatment = (TrafficTreatment)trafficTreatmentCodec.decode((ObjectNode)metaJson, context);
            builder.withMeta(trafficTreatment);
        }
        switch (opStr = ((JsonNode)Tools.nullIsIllegal((Object)json.get(OPERATION), (String)"operation member is required in FilteringObjective")).asText()) {
            case "ADD": {
                filteringObjective = builder.add();
                break;
            }
            case "REMOVE": {
                filteringObjective = builder.remove();
                break;
            }
            default: {
                throw new IllegalArgumentException("The requested operation " + opStr + " is not defined for FilteringObjective.");
            }
        }
        return filteringObjective;
    }
}

