/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.packet.Ethernet;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.CriterionCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EthernetCodec
extends JsonCodec<Ethernet> {
    protected static final Logger log = LoggerFactory.getLogger(CriterionCodec.class);

    public ObjectNode encode(Ethernet ethernet, CodecContext context) {
        Preconditions.checkNotNull((Object)ethernet, (Object)"Ethernet cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put("vlanId", ethernet.getVlanID()).put("etherType", ethernet.getEtherType()).put("priorityCode", (short)ethernet.getPriorityCode()).put("pad", ethernet.isPad());
        if (ethernet.getDestinationMAC() != null) {
            result.put("destMac", ethernet.getDestinationMAC().toString());
        }
        if (ethernet.getSourceMAC() != null) {
            result.put("srcMac", ethernet.getSourceMAC().toString());
        }
        return result;
    }
}

