/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.util.HexString;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.ExtensionTreatmentCodec;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;
import org.onosproject.net.flow.instructions.L1ModificationInstruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flow.instructions.L4ModificationInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncodeInstructionCodecHelper {
    protected static final Logger log = LoggerFactory.getLogger(EncodeInstructionCodecHelper.class);
    private final Instruction instruction;
    private final CodecContext context;

    public EncodeInstructionCodecHelper(Instruction instruction, CodecContext context) {
        this.instruction = instruction;
        this.context = context;
    }

    private void encodeL0(ObjectNode result) {
        L0ModificationInstruction l0Instruction = (L0ModificationInstruction)this.instruction;
        result.put("subtype", l0Instruction.subtype().name());
        switch (l0Instruction.subtype()) {
            case OCH: {
                L0ModificationInstruction.ModOchSignalInstruction ochSignalInstruction = (L0ModificationInstruction.ModOchSignalInstruction)l0Instruction;
                OchSignal ochSignal = ochSignalInstruction.lambda();
                result.put("gridType", ochSignal.gridType().name());
                result.put("channelSpacing", ochSignal.channelSpacing().name());
                result.put("spacingMultiplier", ochSignal.spacingMultiplier());
                result.put("slotGranularity", ochSignal.slotGranularity());
                break;
            }
            default: {
                log.info("Cannot convert L0 subtype of {}", (Object)l0Instruction.subtype());
            }
        }
    }

    private void encodeL1(ObjectNode result) {
        L1ModificationInstruction l1Instruction = (L1ModificationInstruction)this.instruction;
        result.put("subtype", l1Instruction.subtype().name());
        switch (l1Instruction.subtype()) {
            case ODU_SIGID: {
                L1ModificationInstruction.ModOduSignalIdInstruction oduSignalIdInstruction = (L1ModificationInstruction.ModOduSignalIdInstruction)l1Instruction;
                OduSignalId oduSignalId = oduSignalIdInstruction.oduSignalId();
                ObjectNode child = result.putObject("oduSignalId");
                child.put("tributaryPortNumber", oduSignalId.tributaryPortNumber());
                child.put("tributarySlotLength", oduSignalId.tributarySlotLength());
                child.put("tributarySlotBitmap", HexString.toHexString((byte[])oduSignalId.tributarySlotBitmap()));
                break;
            }
            default: {
                log.info("Cannot convert L1 subtype of {}", (Object)l1Instruction.subtype());
            }
        }
    }

    private void encodeL2(ObjectNode result) {
        L2ModificationInstruction l2Instruction = (L2ModificationInstruction)this.instruction;
        result.put("subtype", l2Instruction.subtype().name());
        switch (l2Instruction.subtype()) {
            case ETH_SRC: 
            case ETH_DST: {
                L2ModificationInstruction.ModEtherInstruction modEtherInstruction = (L2ModificationInstruction.ModEtherInstruction)l2Instruction;
                result.put("mac", modEtherInstruction.mac().toString());
                break;
            }
            case VLAN_ID: {
                L2ModificationInstruction.ModVlanIdInstruction modVlanIdInstruction = (L2ModificationInstruction.ModVlanIdInstruction)l2Instruction;
                result.put("vlanId", modVlanIdInstruction.vlanId().toShort());
                break;
            }
            case VLAN_PCP: {
                L2ModificationInstruction.ModVlanPcpInstruction modVlanPcpInstruction = (L2ModificationInstruction.ModVlanPcpInstruction)l2Instruction;
                result.put("vlanPcp", (short)modVlanPcpInstruction.vlanPcp());
                break;
            }
            case VLAN_PUSH: {
                L2ModificationInstruction.ModVlanHeaderInstruction pushVlanInstruction = (L2ModificationInstruction.ModVlanHeaderInstruction)l2Instruction;
                result.put("ethernetType", pushVlanInstruction.ethernetType().toString());
                break;
            }
            case MPLS_LABEL: {
                L2ModificationInstruction.ModMplsLabelInstruction modMplsLabelInstruction = (L2ModificationInstruction.ModMplsLabelInstruction)l2Instruction;
                result.put("label", modMplsLabelInstruction.label().toInt());
                break;
            }
            case MPLS_PUSH: {
                L2ModificationInstruction.ModMplsHeaderInstruction pushHeaderInstructions = (L2ModificationInstruction.ModMplsHeaderInstruction)l2Instruction;
                result.put("ethernetType", pushHeaderInstructions.ethernetType().toShort());
                break;
            }
            case TUNNEL_ID: {
                L2ModificationInstruction.ModTunnelIdInstruction modTunnelIdInstruction = (L2ModificationInstruction.ModTunnelIdInstruction)l2Instruction;
                result.put("tunnelId", modTunnelIdInstruction.tunnelId());
                break;
            }
            case MPLS_BOS: {
                L2ModificationInstruction.ModMplsBosInstruction modMplsBosInstruction = (L2ModificationInstruction.ModMplsBosInstruction)l2Instruction;
                result.put("bos", modMplsBosInstruction.mplsBos());
            }
            case MPLS_POP: 
            case DEC_MPLS_TTL: {
                break;
            }
            default: {
                log.info("Cannot convert L2 subtype of {}", (Object)l2Instruction.subtype());
            }
        }
    }

    private void encodeL3(ObjectNode result) {
        L3ModificationInstruction l3Instruction = (L3ModificationInstruction)this.instruction;
        result.put("subtype", l3Instruction.subtype().name());
        switch (l3Instruction.subtype()) {
            case IPV4_SRC: 
            case IPV4_DST: 
            case IPV6_SRC: 
            case IPV6_DST: {
                L3ModificationInstruction.ModIPInstruction modIPInstruction = (L3ModificationInstruction.ModIPInstruction)l3Instruction;
                result.put("ip", modIPInstruction.ip().toString());
                break;
            }
            case IPV6_FLABEL: {
                L3ModificationInstruction.ModIPv6FlowLabelInstruction modFlowLabelInstruction = (L3ModificationInstruction.ModIPv6FlowLabelInstruction)l3Instruction;
                result.put("flowLabel", modFlowLabelInstruction.flowLabel());
                break;
            }
            case TTL_IN: 
            case TTL_OUT: 
            case DEC_TTL: {
                break;
            }
            default: {
                log.info("Cannot convert L3 subtype of {}", (Object)l3Instruction.subtype());
            }
        }
    }

    private void encodeL4(ObjectNode result) {
        L4ModificationInstruction l4Instruction = (L4ModificationInstruction)this.instruction;
        result.put("subtype", l4Instruction.subtype().name());
        switch (l4Instruction.subtype()) {
            case TCP_DST: 
            case TCP_SRC: {
                L4ModificationInstruction.ModTransportPortInstruction modTcpPortInstruction = (L4ModificationInstruction.ModTransportPortInstruction)l4Instruction;
                result.put("tcpPort", modTcpPortInstruction.port().toInt());
                break;
            }
            case UDP_DST: 
            case UDP_SRC: {
                L4ModificationInstruction.ModTransportPortInstruction modUdpPortInstruction = (L4ModificationInstruction.ModTransportPortInstruction)l4Instruction;
                result.put("udpPort", modUdpPortInstruction.port().toInt());
                break;
            }
            default: {
                log.info("Cannot convert L4 subtype of {}", (Object)l4Instruction.subtype());
            }
        }
    }

    private void encodeExtension(ObjectNode result) {
        Instructions.ExtensionInstructionWrapper extensionInstruction = (Instructions.ExtensionInstructionWrapper)this.instruction;
        DeviceId deviceId = extensionInstruction.deviceId();
        DefaultServiceDirectory serviceDirectory = new DefaultServiceDirectory();
        DeviceService deviceService = (DeviceService)serviceDirectory.get(DeviceService.class);
        Device device = deviceService.getDevice(deviceId);
        if (device == null) {
            throw new IllegalArgumentException("Device not found");
        }
        if (!device.is(ExtensionTreatmentCodec.class)) {
            throw new IllegalArgumentException("There is no codec to encode extension for device " + deviceId.toString());
        }
        ExtensionTreatmentCodec treatmentCodec = (ExtensionTreatmentCodec)device.as(ExtensionTreatmentCodec.class);
        ObjectNode node = treatmentCodec.encode(extensionInstruction.extensionInstruction(), this.context);
        result.set("extension", (JsonNode)node);
    }

    public ObjectNode encode() {
        ObjectNode result = this.context.mapper().createObjectNode().put("type", this.instruction.type().toString());
        switch (this.instruction.type()) {
            case OUTPUT: {
                Instructions.OutputInstruction outputInstruction = (Instructions.OutputInstruction)this.instruction;
                result.put("port", outputInstruction.port().toString());
                break;
            }
            case NOACTION: {
                break;
            }
            case GROUP: {
                Instructions.GroupInstruction groupInstruction = (Instructions.GroupInstruction)this.instruction;
                result.put("groupId", groupInstruction.groupId().toString());
                break;
            }
            case METER: {
                Instructions.MeterInstruction meterInstruction = (Instructions.MeterInstruction)this.instruction;
                result.put("meterId", meterInstruction.meterId().toString());
                break;
            }
            case TABLE: {
                Instructions.TableTypeTransition tableTransitionInstruction = (Instructions.TableTypeTransition)this.instruction;
                result.put("tableId", tableTransitionInstruction.tableId().toString());
                break;
            }
            case QUEUE: {
                Instructions.SetQueueInstruction setQueueInstruction = (Instructions.SetQueueInstruction)this.instruction;
                result.put("queueId", setQueueInstruction.queueId());
                if (setQueueInstruction.port() == null) break;
                result.put("port", setQueueInstruction.port().toString());
                break;
            }
            case L0MODIFICATION: {
                this.encodeL0(result);
                break;
            }
            case L1MODIFICATION: {
                this.encodeL1(result);
                break;
            }
            case L2MODIFICATION: {
                this.encodeL2(result);
                break;
            }
            case L3MODIFICATION: {
                this.encodeL3(result);
                break;
            }
            case L4MODIFICATION: {
                this.encodeL4(result);
                break;
            }
            case EXTENSION: {
                this.encodeExtension(result);
                break;
            }
            default: {
                log.info("Cannot convert instruction type of {}", (Object)this.instruction.type());
            }
        }
        return result;
    }
}

