/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import org.onlab.util.HexString;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPDscpCriterion;
import org.onosproject.net.flow.criteria.IPEcnCriterion;
import org.onosproject.net.flow.criteria.IPProtocolCriterion;
import org.onosproject.net.flow.criteria.IPv6ExthdrFlagsCriterion;
import org.onosproject.net.flow.criteria.IPv6FlowLabelCriterion;
import org.onosproject.net.flow.criteria.IPv6NDLinkLayerAddressCriterion;
import org.onosproject.net.flow.criteria.IPv6NDTargetAddressCriterion;
import org.onosproject.net.flow.criteria.IcmpCodeCriterion;
import org.onosproject.net.flow.criteria.IcmpTypeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6CodeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6TypeCriterion;
import org.onosproject.net.flow.criteria.MetadataCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.OchSignalCriterion;
import org.onosproject.net.flow.criteria.OchSignalTypeCriterion;
import org.onosproject.net.flow.criteria.OduSignalIdCriterion;
import org.onosproject.net.flow.criteria.OduSignalTypeCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.SctpPortCriterion;
import org.onosproject.net.flow.criteria.TcpPortCriterion;
import org.onosproject.net.flow.criteria.TunnelIdCriterion;
import org.onosproject.net.flow.criteria.UdpPortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.criteria.VlanPcpCriterion;

public final class EncodeCriterionCodecHelper {
    private final Criterion criterion;
    private final CodecContext context;
    private final EnumMap<Criterion.Type, CriterionTypeFormatter> formatMap;

    public EncodeCriterionCodecHelper(Criterion criterion, CodecContext context) {
        this.criterion = criterion;
        this.context = context;
        this.formatMap = new EnumMap(Criterion.Type.class);
        this.formatMap.put(Criterion.Type.IN_PORT, new FormatInPort());
        this.formatMap.put(Criterion.Type.IN_PHY_PORT, new FormatInPort());
        this.formatMap.put(Criterion.Type.METADATA, new FormatMetadata());
        this.formatMap.put(Criterion.Type.ETH_DST, new FormatEth());
        this.formatMap.put(Criterion.Type.ETH_SRC, new FormatEth());
        this.formatMap.put(Criterion.Type.ETH_TYPE, new FormatEthType());
        this.formatMap.put(Criterion.Type.VLAN_VID, new FormatVlanVid());
        this.formatMap.put(Criterion.Type.VLAN_PCP, new FormatVlanPcp());
        this.formatMap.put(Criterion.Type.INNER_VLAN_VID, new FormatInnerVlanVid());
        this.formatMap.put(Criterion.Type.INNER_VLAN_PCP, new FormatInnerVlanPcp());
        this.formatMap.put(Criterion.Type.IP_DSCP, new FormatIpDscp());
        this.formatMap.put(Criterion.Type.IP_ECN, new FormatIpEcn());
        this.formatMap.put(Criterion.Type.IP_PROTO, new FormatIpProto());
        this.formatMap.put(Criterion.Type.IPV4_SRC, new FormatIp());
        this.formatMap.put(Criterion.Type.IPV4_DST, new FormatIp());
        this.formatMap.put(Criterion.Type.TCP_SRC, new FormatTcp());
        this.formatMap.put(Criterion.Type.TCP_DST, new FormatTcp());
        this.formatMap.put(Criterion.Type.UDP_SRC, new FormatUdp());
        this.formatMap.put(Criterion.Type.UDP_DST, new FormatUdp());
        this.formatMap.put(Criterion.Type.SCTP_SRC, new FormatSctp());
        this.formatMap.put(Criterion.Type.SCTP_DST, new FormatSctp());
        this.formatMap.put(Criterion.Type.ICMPV4_TYPE, new FormatIcmpV4Type());
        this.formatMap.put(Criterion.Type.ICMPV4_CODE, new FormatIcmpV4Code());
        this.formatMap.put(Criterion.Type.IPV6_SRC, new FormatIp());
        this.formatMap.put(Criterion.Type.IPV6_DST, new FormatIp());
        this.formatMap.put(Criterion.Type.IPV6_FLABEL, new FormatIpV6FLabel());
        this.formatMap.put(Criterion.Type.ICMPV6_TYPE, new FormatIcmpV6Type());
        this.formatMap.put(Criterion.Type.ICMPV6_CODE, new FormatIcmpV6Code());
        this.formatMap.put(Criterion.Type.IPV6_ND_TARGET, new FormatV6NDTarget());
        this.formatMap.put(Criterion.Type.IPV6_ND_SLL, new FormatV6NDTll());
        this.formatMap.put(Criterion.Type.IPV6_ND_TLL, new FormatV6NDTll());
        this.formatMap.put(Criterion.Type.MPLS_LABEL, new FormatMplsLabel());
        this.formatMap.put(Criterion.Type.IPV6_EXTHDR, new FormatIpV6Exthdr());
        this.formatMap.put(Criterion.Type.OCH_SIGID, new FormatOchSigId());
        this.formatMap.put(Criterion.Type.OCH_SIGTYPE, new FormatOchSigType());
        this.formatMap.put(Criterion.Type.TUNNEL_ID, new FormatTunnelId());
        this.formatMap.put(Criterion.Type.DUMMY, new FormatDummyType());
        this.formatMap.put(Criterion.Type.ODU_SIGID, new FormatOduSignalId());
        this.formatMap.put(Criterion.Type.ODU_SIGTYPE, new FormatOduSignalType());
        this.formatMap.put(Criterion.Type.ARP_OP, new FormatUnknown());
        this.formatMap.put(Criterion.Type.ARP_SPA, new FormatUnknown());
        this.formatMap.put(Criterion.Type.ARP_TPA, new FormatUnknown());
        this.formatMap.put(Criterion.Type.ARP_SHA, new FormatUnknown());
        this.formatMap.put(Criterion.Type.ARP_THA, new FormatUnknown());
        this.formatMap.put(Criterion.Type.MPLS_TC, new FormatUnknown());
        this.formatMap.put(Criterion.Type.MPLS_BOS, new FormatUnknown());
        this.formatMap.put(Criterion.Type.PBB_ISID, new FormatUnknown());
        this.formatMap.put(Criterion.Type.UNASSIGNED_40, new FormatUnknown());
        this.formatMap.put(Criterion.Type.PBB_UCA, new FormatUnknown());
        this.formatMap.put(Criterion.Type.TCP_FLAGS, new FormatUnknown());
        this.formatMap.put(Criterion.Type.ACTSET_OUTPUT, new FormatUnknown());
        this.formatMap.put(Criterion.Type.PACKET_TYPE, new FormatUnknown());
        this.formatMap.put(Criterion.Type.EXTENSION, new FormatUnknown());
        this.formatMap.put(Criterion.Type.ETH_DST_MASKED, new FormatUnknown());
        this.formatMap.put(Criterion.Type.ETH_SRC_MASKED, new FormatUnknown());
        this.formatMap.put(Criterion.Type.TCP_SRC_MASKED, new FormatUnknown());
        this.formatMap.put(Criterion.Type.TCP_DST_MASKED, new FormatUnknown());
        this.formatMap.put(Criterion.Type.UDP_SRC_MASKED, new FormatUnknown());
        this.formatMap.put(Criterion.Type.UDP_DST_MASKED, new FormatUnknown());
        this.formatMap.put(Criterion.Type.SCTP_SRC_MASKED, new FormatUnknown());
        this.formatMap.put(Criterion.Type.SCTP_DST_MASKED, new FormatUnknown());
    }

    public ObjectNode encode() {
        ObjectNode result = this.context.mapper().createObjectNode().put("type", this.criterion.type().toString());
        CriterionTypeFormatter formatter = (CriterionTypeFormatter)Preconditions.checkNotNull((Object)this.formatMap.get(this.criterion.type()), (Object)("No formatter found for criterion type " + this.criterion.type().toString()));
        return formatter.encodeCriterion(result, this.criterion);
    }

    private class FormatDummyType
    implements CriterionTypeFormatter {
        private FormatDummyType() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            Preconditions.checkNotNull((Object)criterion, (Object)"Criterion cannot be null");
            return root.put("type", criterion.type().toString());
        }
    }

    private static class FormatOduSignalType
    implements CriterionTypeFormatter {
        private FormatOduSignalType() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            OduSignalTypeCriterion oduSignalTypeCriterion = (OduSignalTypeCriterion)criterion;
            return root.put("oduSignalType", oduSignalTypeCriterion.signalType().name());
        }
    }

    private static class FormatOduSignalId
    implements CriterionTypeFormatter {
        private FormatOduSignalId() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            OduSignalId oduSignalId = ((OduSignalIdCriterion)criterion).oduSignalId();
            ObjectNode child = root.putObject("oduSignalId");
            child.put("tributaryPortNumber", oduSignalId.tributaryPortNumber());
            child.put("tributarySlotLen", oduSignalId.tributarySlotLength());
            child.put("tributarySlotBitmap", HexString.toHexString((byte[])oduSignalId.tributarySlotBitmap()));
            return root;
        }
    }

    private static class FormatTunnelId
    implements CriterionTypeFormatter {
        private FormatTunnelId() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            TunnelIdCriterion tunnelIdCriterion = (TunnelIdCriterion)criterion;
            return root.put("tunnelId", tunnelIdCriterion.tunnelId());
        }
    }

    private static class FormatOchSigType
    implements CriterionTypeFormatter {
        private FormatOchSigType() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            OchSignalTypeCriterion ochSignalTypeCriterion = (OchSignalTypeCriterion)criterion;
            return root.put("ochSignalType", ochSignalTypeCriterion.signalType().name());
        }
    }

    private static class FormatOchSigId
    implements CriterionTypeFormatter {
        private FormatOchSigId() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            OchSignal ochSignal = ((OchSignalCriterion)criterion).lambda();
            ObjectNode child = root.putObject("ochSignalId");
            child.put("gridType", ochSignal.gridType().name());
            child.put("channelSpacing", ochSignal.channelSpacing().name());
            child.put("spacingMultiplier", ochSignal.spacingMultiplier());
            child.put("slotGranularity", ochSignal.slotGranularity());
            return root;
        }
    }

    private static class FormatIpV6Exthdr
    implements CriterionTypeFormatter {
        private FormatIpV6Exthdr() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            IPv6ExthdrFlagsCriterion exthdrCriterion = (IPv6ExthdrFlagsCriterion)criterion;
            return root.put("exthdrFlags", exthdrCriterion.exthdrFlags());
        }
    }

    private static class FormatMplsLabel
    implements CriterionTypeFormatter {
        private FormatMplsLabel() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            MplsCriterion mplsCriterion = (MplsCriterion)criterion;
            return root.put("label", mplsCriterion.label().toInt());
        }
    }

    private static class FormatV6NDTll
    implements CriterionTypeFormatter {
        private FormatV6NDTll() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            IPv6NDLinkLayerAddressCriterion ipv6NDLinkLayerAddressCriterion = (IPv6NDLinkLayerAddressCriterion)criterion;
            return root.put("mac", ipv6NDLinkLayerAddressCriterion.mac().toString());
        }
    }

    private static class FormatV6NDTarget
    implements CriterionTypeFormatter {
        private FormatV6NDTarget() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            IPv6NDTargetAddressCriterion ipv6NDTargetAddressCriterion = (IPv6NDTargetAddressCriterion)criterion;
            return root.put("targetAddress", ipv6NDTargetAddressCriterion.targetAddress().toString());
        }
    }

    private static class FormatIcmpV6Code
    implements CriterionTypeFormatter {
        private FormatIcmpV6Code() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            Icmpv6CodeCriterion icmpv6CodeCriterion = (Icmpv6CodeCriterion)criterion;
            return root.put("icmpv6Code", icmpv6CodeCriterion.icmpv6Code());
        }
    }

    private static class FormatIcmpV6Type
    implements CriterionTypeFormatter {
        private FormatIcmpV6Type() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            Icmpv6TypeCriterion icmpv6TypeCriterion = (Icmpv6TypeCriterion)criterion;
            return root.put("icmpv6Type", icmpv6TypeCriterion.icmpv6Type());
        }
    }

    private static class FormatIpV6FLabel
    implements CriterionTypeFormatter {
        private FormatIpV6FLabel() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            IPv6FlowLabelCriterion ipv6FlowLabelCriterion = (IPv6FlowLabelCriterion)criterion;
            return root.put("flowLabel", ipv6FlowLabelCriterion.flowLabel());
        }
    }

    private static class FormatIcmpV4Code
    implements CriterionTypeFormatter {
        private FormatIcmpV4Code() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            IcmpCodeCriterion icmpCodeCriterion = (IcmpCodeCriterion)criterion;
            return root.put("icmpCode", icmpCodeCriterion.icmpCode());
        }
    }

    private static class FormatIcmpV4Type
    implements CriterionTypeFormatter {
        private FormatIcmpV4Type() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            IcmpTypeCriterion icmpTypeCriterion = (IcmpTypeCriterion)criterion;
            return root.put("icmpType", icmpTypeCriterion.icmpType());
        }
    }

    private static class FormatSctp
    implements CriterionTypeFormatter {
        private FormatSctp() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            SctpPortCriterion sctpPortCriterion = (SctpPortCriterion)criterion;
            return root.put("sctpPort", sctpPortCriterion.sctpPort().toInt());
        }
    }

    private static class FormatUdp
    implements CriterionTypeFormatter {
        private FormatUdp() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            UdpPortCriterion udpPortCriterion = (UdpPortCriterion)criterion;
            return root.put("udpPort", udpPortCriterion.udpPort().toInt());
        }
    }

    private static class FormatTcp
    implements CriterionTypeFormatter {
        private FormatTcp() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            TcpPortCriterion tcpPortCriterion = (TcpPortCriterion)criterion;
            return root.put("tcpPort", tcpPortCriterion.tcpPort().toInt());
        }
    }

    private static class FormatIp
    implements CriterionTypeFormatter {
        private FormatIp() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            IPCriterion iPCriterion = (IPCriterion)criterion;
            return root.put("ip", iPCriterion.ip().toString());
        }
    }

    private static class FormatIpProto
    implements CriterionTypeFormatter {
        private FormatIpProto() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            IPProtocolCriterion iPProtocolCriterion = (IPProtocolCriterion)criterion;
            return root.put("protocol", iPProtocolCriterion.protocol());
        }
    }

    private static class FormatIpEcn
    implements CriterionTypeFormatter {
        private FormatIpEcn() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            IPEcnCriterion ipEcnCriterion = (IPEcnCriterion)criterion;
            return root.put("ipEcn", (short)ipEcnCriterion.ipEcn());
        }
    }

    private static class FormatIpDscp
    implements CriterionTypeFormatter {
        private FormatIpDscp() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            IPDscpCriterion ipDscpCriterion = (IPDscpCriterion)criterion;
            return root.put("ipDscp", (short)ipDscpCriterion.ipDscp());
        }
    }

    private static class FormatInnerVlanPcp
    implements CriterionTypeFormatter {
        private FormatInnerVlanPcp() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            VlanPcpCriterion vlanPcpCriterion = (VlanPcpCriterion)criterion;
            return root.put("innerPriority", (short)vlanPcpCriterion.priority());
        }
    }

    private static class FormatInnerVlanVid
    implements CriterionTypeFormatter {
        private FormatInnerVlanVid() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)criterion;
            return root.put("innerVlanId", vlanIdCriterion.vlanId().toShort());
        }
    }

    private static class FormatVlanPcp
    implements CriterionTypeFormatter {
        private FormatVlanPcp() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            VlanPcpCriterion vlanPcpCriterion = (VlanPcpCriterion)criterion;
            return root.put("priority", (short)vlanPcpCriterion.priority());
        }
    }

    private static class FormatVlanVid
    implements CriterionTypeFormatter {
        private FormatVlanVid() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)criterion;
            return root.put("vlanId", vlanIdCriterion.vlanId().toShort());
        }
    }

    private static class FormatEthType
    implements CriterionTypeFormatter {
        private FormatEthType() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            EthTypeCriterion ethTypeCriterion = (EthTypeCriterion)criterion;
            return root.put("ethType", "0x" + Integer.toHexString(ethTypeCriterion.ethType().toShort() & 0xFFFF));
        }
    }

    private static class FormatEth
    implements CriterionTypeFormatter {
        private FormatEth() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            EthCriterion ethCriterion = (EthCriterion)criterion;
            return root.put("mac", ethCriterion.mac().toString());
        }
    }

    private static class FormatMetadata
    implements CriterionTypeFormatter {
        private FormatMetadata() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            MetadataCriterion metadataCriterion = (MetadataCriterion)criterion;
            return root.put("metadata", metadataCriterion.metadata());
        }
    }

    private static class FormatInPort
    implements CriterionTypeFormatter {
        private FormatInPort() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            PortCriterion portCriterion = (PortCriterion)criterion;
            return root.put("port", portCriterion.port().toLong());
        }
    }

    private static class FormatUnknown
    implements CriterionTypeFormatter {
        private FormatUnknown() {
        }

        @Override
        public ObjectNode encodeCriterion(ObjectNode root, Criterion criterion) {
            return root;
        }
    }

    private static interface CriterionTypeFormatter {
        public ObjectNode encodeCriterion(ObjectNode var1, Criterion var2);
    }
}

