/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.constraint.AnnotationConstraint;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.intent.constraint.LatencyConstraint;
import org.onosproject.net.intent.constraint.LinkTypeConstraint;
import org.onosproject.net.intent.constraint.ObstacleConstraint;
import org.onosproject.net.intent.constraint.WaypointConstraint;

public final class EncodeConstraintCodecHelper {
    private final Constraint constraint;
    private final CodecContext context;

    public EncodeConstraintCodecHelper(Constraint constraint, CodecContext context) {
        this.constraint = constraint;
        this.context = context;
    }

    private ObjectNode encodeLatencyConstraint() {
        Preconditions.checkNotNull((Object)this.constraint, (Object)"Duration constraint cannot be null");
        LatencyConstraint latencyConstraint = (LatencyConstraint)this.constraint;
        return this.context.mapper().createObjectNode().put("latencyMillis", latencyConstraint.latency().toMillis());
    }

    private ObjectNode encodeObstacleConstraint() {
        Preconditions.checkNotNull((Object)this.constraint, (Object)"Obstacle constraint cannot be null");
        ObstacleConstraint obstacleConstraint = (ObstacleConstraint)this.constraint;
        ObjectNode result = this.context.mapper().createObjectNode();
        ArrayNode jsonObstacles = result.putArray("obstacles");
        for (DeviceId did : obstacleConstraint.obstacles()) {
            jsonObstacles.add(did.toString());
        }
        return result;
    }

    private ObjectNode encodeWaypointConstraint() {
        Preconditions.checkNotNull((Object)this.constraint, (Object)"Waypoint constraint cannot be null");
        WaypointConstraint waypointConstraint = (WaypointConstraint)this.constraint;
        ObjectNode result = this.context.mapper().createObjectNode();
        ArrayNode jsonWaypoints = result.putArray("waypoints");
        for (DeviceId did : waypointConstraint.waypoints()) {
            jsonWaypoints.add(did.toString());
        }
        return result;
    }

    private ObjectNode encodeAnnotationConstraint() {
        Preconditions.checkNotNull((Object)this.constraint, (Object)"Annotation constraint cannot be null");
        AnnotationConstraint annotationConstraint = (AnnotationConstraint)this.constraint;
        return this.context.mapper().createObjectNode().put("key", annotationConstraint.key()).put("threshold", annotationConstraint.threshold());
    }

    private ObjectNode encodeBandwidthConstraint() {
        Preconditions.checkNotNull((Object)this.constraint, (Object)"Bandwidth constraint cannot be null");
        BandwidthConstraint bandwidthConstraint = (BandwidthConstraint)this.constraint;
        return this.context.mapper().createObjectNode().put("bandwidth", bandwidthConstraint.bandwidth().bps());
    }

    private ObjectNode encodeLinkTypeConstraint() {
        Preconditions.checkNotNull((Object)this.constraint, (Object)"Link type constraint cannot be null");
        LinkTypeConstraint linkTypeConstraint = (LinkTypeConstraint)this.constraint;
        ObjectNode result = this.context.mapper().createObjectNode().put("inclusive", linkTypeConstraint.isInclusive());
        ArrayNode jsonTypes = result.putArray("types");
        if (linkTypeConstraint.types() != null) {
            for (Link.Type type : linkTypeConstraint.types()) {
                jsonTypes.add(type.name());
            }
        }
        return result;
    }

    public ObjectNode encode() {
        ObjectNode result = this.constraint instanceof BandwidthConstraint ? this.encodeBandwidthConstraint() : (this.constraint instanceof LinkTypeConstraint ? this.encodeLinkTypeConstraint() : (this.constraint instanceof AnnotationConstraint ? this.encodeAnnotationConstraint() : (this.constraint instanceof LatencyConstraint ? this.encodeLatencyConstraint() : (this.constraint instanceof ObstacleConstraint ? this.encodeObstacleConstraint() : (this.constraint instanceof WaypointConstraint ? this.encodeWaypointConstraint() : this.context.mapper().createObjectNode())))));
        result.put("type", this.constraint.getClass().getSimpleName());
        return result;
    }
}

