/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.driver.Driver;

public final class DriverCodec
extends JsonCodec<Driver> {
    private static final String PARENT = "parent";
    private static final String NAME = "name";
    private static final String MANUFACTURER = "manufacturer";
    private static final String HW_VERSION = "hwVersion";
    private static final String SW_VERSION = "swVersion";
    private static final String BEHAVIOURS = "behaviours";
    private static final String BEHAVIORS_NAME = "name";
    private static final String BEHAVIORS_IMPLEMENTATION_NAME = "implementationName";
    private static final String PROPERTIES = "properties";

    public ObjectNode encode(Driver driver, CodecContext context) {
        Preconditions.checkNotNull((Object)driver, (Object)"Driver cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put("name", driver.name()).put(MANUFACTURER, driver.manufacturer()).put(HW_VERSION, driver.hwVersion()).put(SW_VERSION, driver.swVersion());
        if (driver.parent() != null) {
            result.put(PARENT, driver.parent().name());
        }
        ArrayNode behaviours = context.mapper().createArrayNode();
        driver.behaviours().forEach(behaviour -> {
            ObjectNode entry = context.mapper().createObjectNode().put("name", behaviour.getCanonicalName()).put(BEHAVIORS_IMPLEMENTATION_NAME, driver.implementation(behaviour).getCanonicalName());
            behaviours.add((JsonNode)entry);
        });
        result.set(BEHAVIOURS, (JsonNode)behaviours);
        ArrayNode properties = context.mapper().createArrayNode();
        driver.properties().forEach((name, value) -> {
            ObjectNode entry = context.mapper().createObjectNode().put("name", name).put("value", value);
            properties.add((JsonNode)entry);
        });
        result.set(PROPERTIES, (JsonNode)properties);
        return result;
    }
}

