/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.AnnotatedCodec;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.Link;

public final class DisjointPathCodec
extends AnnotatedCodec<DisjointPath> {
    public ObjectNode encode(DisjointPath disjointPath, CodecContext context) {
        Preconditions.checkNotNull((Object)disjointPath, (Object)"Path cannot be null");
        JsonCodec codec = context.codec(Link.class);
        ObjectNode result = context.mapper().createObjectNode();
        ObjectNode primary = context.mapper().createObjectNode().put("cost", disjointPath.primary().cost());
        result.set("primary", (JsonNode)primary);
        ArrayNode jsonLinks = primary.putArray("links");
        for (Link link : disjointPath.primary().links()) {
            jsonLinks.add((JsonNode)codec.encode((Object)link, context));
        }
        if (disjointPath.backup() != null) {
            ObjectNode backup = context.mapper().createObjectNode().put("cost", disjointPath.backup().cost());
            result.set("backup", (JsonNode)backup);
            ArrayNode jsonLinks1 = backup.putArray("links");
            for (Link link1 : disjointPath.backup().links()) {
                jsonLinks1.add((JsonNode)codec.encode((Object)link1, context));
            }
        }
        return this.annotate(result, disjointPath, context);
    }
}

