/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.impl.AnnotatedCodec;
import org.onosproject.net.key.DeviceKey;
import org.onosproject.net.key.DeviceKeyId;
import org.onosproject.net.key.DeviceKeyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceKeyCodec
extends AnnotatedCodec<DeviceKey> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String LABEL = "label";
    private static final String COMMUNITY_NAME = "community_name";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";

    public ObjectNode encode(DeviceKey deviceKey, CodecContext context) {
        Preconditions.checkNotNull((Object)deviceKey, (Object)"Device key cannot be null");
        DeviceKeyService service = (DeviceKeyService)context.getService(DeviceKeyService.class);
        ObjectNode result = context.mapper().createObjectNode().put(ID, (String)deviceKey.deviceKeyId().id()).put(TYPE, deviceKey.type().toString()).put(LABEL, deviceKey.label());
        if (deviceKey.type().equals((Object)DeviceKey.Type.COMMUNITY_NAME)) {
            result.put(COMMUNITY_NAME, deviceKey.asCommunityName().name());
        } else if (deviceKey.type().equals((Object)DeviceKey.Type.USERNAME_PASSWORD)) {
            result.put(USERNAME, deviceKey.asUsernamePassword().username());
            result.put(PASSWORD, deviceKey.asUsernamePassword().password());
        }
        return this.annotate(result, deviceKey, context);
    }

    public DeviceKey decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        DeviceKeyId id = DeviceKeyId.deviceKeyId((String)json.get(ID).asText());
        DeviceKey.Type type = DeviceKey.Type.valueOf((String)json.get(TYPE).asText());
        String label = this.extract(json, LABEL);
        if (type.equals((Object)DeviceKey.Type.COMMUNITY_NAME)) {
            String communityName = this.extract(json, COMMUNITY_NAME);
            return DeviceKey.createDeviceKeyUsingCommunityName((DeviceKeyId)id, (String)label, (String)communityName);
        }
        if (type.equals((Object)DeviceKey.Type.USERNAME_PASSWORD)) {
            String username = this.extract(json, USERNAME);
            String password = this.extract(json, PASSWORD);
            return DeviceKey.createDeviceKeyUsingUsernamePassword((DeviceKeyId)id, (String)label, (String)username, (String)password);
        }
        this.log.error("Unknown device key type: ", (Object)type);
        return null;
    }

    private String extract(ObjectNode json, String key) {
        return json.get(key) == null ? null : json.get(key).asText();
    }
}

