/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.packet.ChassisId;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.impl.AnnotatedCodec;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.provider.ProviderId;

public final class DeviceCodec
extends AnnotatedCodec<Device> {
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String AVAILABLE = "available";
    private static final String ROLE = "role";
    private static final String MFR = "mfr";
    private static final String HW = "hw";
    private static final String SW = "sw";
    private static final String SERIAL = "serial";
    private static final String CHASSIS_ID = "chassisId";
    private static final String DRIVER = "driver";

    public ObjectNode encode(Device device, CodecContext context) {
        Preconditions.checkNotNull((Object)device, (Object)"Device cannot be null");
        DeviceService service = (DeviceService)context.getService(DeviceService.class);
        DriverService driveService = (DriverService)context.getService(DriverService.class);
        ObjectNode result = context.mapper().createObjectNode().put(ID, device.id().toString()).put(TYPE, device.type().name()).put(AVAILABLE, service.isAvailable(device.id())).put(ROLE, service.getRole(device.id()).toString()).put(MFR, device.manufacturer()).put(HW, device.hwVersion()).put(SW, device.swVersion()).put(SERIAL, device.serialNumber()).put(DRIVER, driveService.getDriver(device.id()).name()).put(CHASSIS_ID, device.chassisId().toString());
        return this.annotate(result, device, context);
    }

    public Device decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        DeviceId id = DeviceId.deviceId((String)json.get(ID).asText());
        ProviderId pid = new ProviderId(id.uri().getScheme(), "DeviceCodec");
        Device.Type type = Device.Type.valueOf((String)json.get(TYPE).asText());
        String mfr = json.get(MFR).asText();
        String hw = json.get(HW).asText();
        String sw = json.get(SW).asText();
        String serial = json.get(SERIAL).asText();
        ChassisId chassisId = new ChassisId(json.get(CHASSIS_ID).asText());
        Annotations annotations = this.extractAnnotations(json, context);
        return new DefaultDevice(pid, id, type, mfr, hw, sw, serial, chassisId, new Annotations[]{annotations});
    }
}

