/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.packet.EthType;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onlab.util.HexString;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.ExtensionTreatmentCodec;
import org.onosproject.core.GroupId;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.GridType;
import org.onosproject.net.Lambda;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;
import org.onosproject.net.flow.instructions.L1ModificationInstruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flow.instructions.L4ModificationInstruction;
import org.onosproject.net.meter.MeterId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DecodeInstructionCodecHelper {
    protected static final Logger log = LoggerFactory.getLogger(DecodeInstructionCodecHelper.class);
    private final ObjectNode json;
    private final CodecContext context;
    private static final Pattern ETHTYPE_PATTERN = Pattern.compile("0x([0-9a-fA-F]{4})");

    public DecodeInstructionCodecHelper(ObjectNode json, CodecContext context) {
        this.json = json;
        this.context = context;
    }

    private Instruction decodeL2() {
        String subType = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("subtype"), (String)"subtype not specified in Instruction")).asText();
        if (subType.equals(L2ModificationInstruction.L2SubType.ETH_SRC.name())) {
            String mac = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("mac"), (String)"mac member is required in Instruction")).asText();
            return Instructions.modL2Src((MacAddress)MacAddress.valueOf((String)mac));
        }
        if (subType.equals(L2ModificationInstruction.L2SubType.ETH_DST.name())) {
            String mac = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("mac"), (String)"mac member is required in Instruction")).asText();
            return Instructions.modL2Dst((MacAddress)MacAddress.valueOf((String)mac));
        }
        if (subType.equals(L2ModificationInstruction.L2SubType.VLAN_ID.name())) {
            short vlanId = (short)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("vlanId"), (String)"vlanId member is required in Instruction")).asInt();
            return Instructions.modVlanId((VlanId)VlanId.vlanId((short)vlanId));
        }
        if (subType.equals(L2ModificationInstruction.L2SubType.VLAN_PCP.name())) {
            byte vlanPcp = (byte)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("vlanPcp"), (String)"vlanPcp member is required in Instruction")).asInt();
            return Instructions.modVlanPcp((Byte)vlanPcp);
        }
        if (subType.equals(L2ModificationInstruction.L2SubType.MPLS_LABEL.name())) {
            int label = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("label"), (String)"label member is required in Instruction")).asInt();
            return Instructions.modMplsLabel((MplsLabel)MplsLabel.mplsLabel((int)label));
        }
        if (subType.equals(L2ModificationInstruction.L2SubType.MPLS_PUSH.name())) {
            return Instructions.pushMpls();
        }
        if (subType.equals(L2ModificationInstruction.L2SubType.MPLS_POP.name())) {
            return Instructions.popMpls();
        }
        if (subType.equals(L2ModificationInstruction.L2SubType.DEC_MPLS_TTL.name())) {
            return Instructions.decMplsTtl();
        }
        if (subType.equals(L2ModificationInstruction.L2SubType.VLAN_POP.name())) {
            return Instructions.popVlan();
        }
        if (subType.equals(L2ModificationInstruction.L2SubType.VLAN_PUSH.name())) {
            if (this.json.has("ethernetType")) {
                return Instructions.pushVlan((EthType)this.getEthType());
            }
            return Instructions.pushVlan();
        }
        if (subType.equals(L2ModificationInstruction.L2SubType.TUNNEL_ID.name())) {
            long tunnelId = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("tunnelId"), (String)"tunnelId member is required in Instruction")).asLong();
            return Instructions.modTunnelId((long)tunnelId);
        }
        throw new IllegalArgumentException("L2 Instruction subtype " + subType + " is not supported");
    }

    private Instruction decodeL3() {
        String subType = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("subtype"), (String)"subtype not specified in Instruction")).asText();
        if (subType.equals(L3ModificationInstruction.L3SubType.IPV4_SRC.name())) {
            IpAddress ip = IpAddress.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("ip"), (String)"ip member is required in Instruction")).asText());
            return Instructions.modL3Src((IpAddress)ip);
        }
        if (subType.equals(L3ModificationInstruction.L3SubType.IPV4_DST.name())) {
            IpAddress ip = IpAddress.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("ip"), (String)"ip member is required in Instruction")).asText());
            return Instructions.modL3Dst((IpAddress)ip);
        }
        if (subType.equals(L3ModificationInstruction.L3SubType.IPV6_SRC.name())) {
            IpAddress ip = IpAddress.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("ip"), (String)"ip member is required in Instruction")).asText());
            return Instructions.modL3IPv6Src((IpAddress)ip);
        }
        if (subType.equals(L3ModificationInstruction.L3SubType.IPV6_DST.name())) {
            IpAddress ip = IpAddress.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("ip"), (String)"ip member is required in Instruction")).asText());
            return Instructions.modL3IPv6Dst((IpAddress)ip);
        }
        if (subType.equals(L3ModificationInstruction.L3SubType.IPV6_FLABEL.name())) {
            int flowLabel = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("flowLabel"), (String)"flowLabel member is required in Instruction")).asInt();
            return Instructions.modL3IPv6FlowLabel((int)flowLabel);
        }
        throw new IllegalArgumentException("L3 Instruction subtype " + subType + " is not supported");
    }

    private Instruction decodeL0() {
        String subType = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("subtype"), (String)"subtype not specified in Instruction")).asText();
        if (subType.equals(L0ModificationInstruction.L0SubType.OCH.name())) {
            String gridTypeString = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("gridType"), (String)"gridType member is required in Instruction")).asText();
            GridType gridType = GridType.valueOf((String)gridTypeString);
            if (gridType == null) {
                throw new IllegalArgumentException("Unknown grid type  " + gridTypeString);
            }
            String channelSpacingString = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("channelSpacing"), (String)"channelSpacing member is required in Instruction")).asText();
            ChannelSpacing channelSpacing = ChannelSpacing.valueOf((String)channelSpacingString);
            if (channelSpacing == null) {
                throw new IllegalArgumentException("Unknown channel spacing  " + channelSpacingString);
            }
            int spacingMultiplier = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("spacingMultiplier"), (String)"spacingMultiplier member is required in Instruction")).asInt();
            int slotGranularity = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("slotGranularity"), (String)"slotGranularity member is required in Instruction")).asInt();
            return Instructions.modL0Lambda((Lambda)new OchSignal(gridType, channelSpacing, spacingMultiplier, slotGranularity));
        }
        throw new IllegalArgumentException("L0 Instruction subtype " + subType + " is not supported");
    }

    private Instruction decodeL1() {
        String subType = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("subtype"), (String)"subtype not specified in Instruction")).asText();
        if (subType.equals(L1ModificationInstruction.L1SubType.ODU_SIGID.name())) {
            int tributaryPortNumber = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("tributaryPortNumber"), (String)"tributaryPortNumber member is required in Instruction")).asInt();
            int tributarySlotLen = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("tributarySlotLength"), (String)"tributarySlotLength member is required in Instruction")).asInt();
            byte[] tributarySlotBitmap = null;
            tributarySlotBitmap = HexString.fromHexString((String)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("tributarySlotBitmap"), (String)"tributarySlotBitmap member is required in Instruction")).asText());
            return Instructions.modL1OduSignalId((OduSignalId)OduSignalId.oduSignalId((int)tributaryPortNumber, (int)tributarySlotLen, (byte[])tributarySlotBitmap));
        }
        throw new IllegalArgumentException("L1 Instruction subtype " + subType + " is not supported");
    }

    private Instruction decodeL4() {
        String subType = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("subtype"), (String)"subtype not specified in Instruction")).asText();
        if (subType.equals(L4ModificationInstruction.L4SubType.TCP_DST.name())) {
            TpPort tcpPort = TpPort.tpPort((int)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("tcpPort"), (String)"tcpPort member is required in Instruction")).asInt());
            return Instructions.modTcpDst((TpPort)tcpPort);
        }
        if (subType.equals(L4ModificationInstruction.L4SubType.TCP_SRC.name())) {
            TpPort tcpPort = TpPort.tpPort((int)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("tcpPort"), (String)"tcpPort member is required in Instruction")).asInt());
            return Instructions.modTcpSrc((TpPort)tcpPort);
        }
        if (subType.equals(L4ModificationInstruction.L4SubType.UDP_DST.name())) {
            TpPort udpPort = TpPort.tpPort((int)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("udpPort"), (String)"udpPort member is required in Instruction")).asInt());
            return Instructions.modUdpDst((TpPort)udpPort);
        }
        if (subType.equals(L4ModificationInstruction.L4SubType.UDP_SRC.name())) {
            TpPort udpPort = TpPort.tpPort((int)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("udpPort"), (String)"udpPort member is required in Instruction")).asInt());
            return Instructions.modUdpSrc((TpPort)udpPort);
        }
        throw new IllegalArgumentException("L4 Instruction subtype " + subType + " is not supported");
    }

    private Instruction decodeExtension() {
        ObjectNode node = (ObjectNode)this.json.get("extension");
        if (node != null) {
            DeviceId deviceId = this.getDeviceId();
            DefaultServiceDirectory serviceDirectory = new DefaultServiceDirectory();
            DeviceService deviceService = (DeviceService)serviceDirectory.get(DeviceService.class);
            Device device = deviceService.getDevice(deviceId);
            if (device == null) {
                throw new IllegalArgumentException("Device not found");
            }
            if (device.is(ExtensionTreatmentCodec.class)) {
                ExtensionTreatmentCodec treatmentCodec = (ExtensionTreatmentCodec)device.as(ExtensionTreatmentCodec.class);
                ExtensionTreatment treatment = treatmentCodec.decode(node, this.context);
                return Instructions.extension((ExtensionTreatment)treatment, (DeviceId)deviceId);
            }
            throw new IllegalArgumentException("There is no codec to decode extension for device " + deviceId.toString());
        }
        return null;
    }

    private DeviceId getDeviceId() {
        JsonNode deviceIdNode = this.json.get("deviceId");
        if (deviceIdNode != null) {
            return DeviceId.deviceId((String)deviceIdNode.asText());
        }
        throw new IllegalArgumentException("Empty device identifier");
    }

    private PortNumber getPortNumber(ObjectNode jsonNode) {
        PortNumber portNumber;
        JsonNode portNode = (JsonNode)Tools.nullIsIllegal((Object)jsonNode.get("port"), (String)"port not specified in Instruction");
        if (portNode.isLong() || portNode.isInt()) {
            portNumber = PortNumber.portNumber((long)portNode.asLong());
        } else if (portNode.isTextual()) {
            portNumber = PortNumber.fromString((String)portNode.textValue());
        } else {
            throw new IllegalArgumentException("Port value " + portNode.toString() + " is not supported");
        }
        return portNumber;
    }

    private EthType getEthType() {
        String ethTypeStr = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("ethernetType"), (String)"ethernetType member is required in Instruction")).asText();
        Matcher matcher = ETHTYPE_PATTERN.matcher(ethTypeStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("ETHERNET_TYPE must be a four digit hex string starting with 0x");
        }
        short ethernetType = (short)Integer.parseInt(matcher.group(1), 16);
        return new EthType(ethernetType);
    }

    public Instruction decode() {
        String type = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("type"), (String)"type not specified in Instruction")).asText();
        if (type.equals(Instruction.Type.OUTPUT.name())) {
            return Instructions.createOutput((PortNumber)this.getPortNumber(this.json));
        }
        if (type.equals(Instruction.Type.NOACTION.name())) {
            return Instructions.createNoAction();
        }
        if (type.equals(Instruction.Type.TABLE.name())) {
            return Instructions.transition((Integer)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("tableId"), (String)"tableId member is required in Instruction")).asInt());
        }
        if (type.equals(Instruction.Type.GROUP.name())) {
            GroupId groupId = new GroupId(((JsonNode)Tools.nullIsIllegal((Object)this.json.get("groupId"), (String)"groupId member is required in Instruction")).asInt());
            return Instructions.createGroup((GroupId)groupId);
        }
        if (type.equals(Instruction.Type.METER.name())) {
            MeterId meterId = MeterId.meterId((long)((JsonNode)Tools.nullIsIllegal((Object)this.json.get("meterId"), (String)"meterId member is required in Instruction")).asLong());
            return Instructions.meterTraffic((MeterId)meterId);
        }
        if (type.equals(Instruction.Type.QUEUE.name())) {
            long queueId = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("queueId"), (String)"queueId member is required in Instruction")).asLong();
            if (this.json.get("port") == null || this.json.get("port").isNull()) {
                return Instructions.setQueue((long)queueId, null);
            }
            return Instructions.setQueue((long)queueId, (PortNumber)this.getPortNumber(this.json));
        }
        if (type.equals(Instruction.Type.L0MODIFICATION.name())) {
            return this.decodeL0();
        }
        if (type.equals(Instruction.Type.L1MODIFICATION.name())) {
            return this.decodeL1();
        }
        if (type.equals(Instruction.Type.L2MODIFICATION.name())) {
            return this.decodeL2();
        }
        if (type.equals(Instruction.Type.L3MODIFICATION.name())) {
            return this.decodeL3();
        }
        if (type.equals(Instruction.Type.L4MODIFICATION.name())) {
            return this.decodeL4();
        }
        if (type.equals(Instruction.Type.EXTENSION.name())) {
            return this.decodeExtension();
        }
        throw new IllegalArgumentException("Instruction type " + type + " is not supported");
    }
}

