/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onlab.util.HexString;
import org.onlab.util.Tools;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.GridType;
import org.onosproject.net.Lambda;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;

public final class DecodeCriterionCodecHelper {
    private final ObjectNode json;
    protected static final String MISSING_MEMBER_MESSAGE = " member is required in Criterion";
    private final Map<String, CriterionDecoder> decoderMap;

    public DecodeCriterionCodecHelper(ObjectNode json) {
        this.json = json;
        this.decoderMap = new HashMap<String, CriterionDecoder>();
        this.decoderMap.put(Criterion.Type.IN_PORT.name(), new InPortDecoder());
        this.decoderMap.put(Criterion.Type.IN_PHY_PORT.name(), new InPhyPortDecoder());
        this.decoderMap.put(Criterion.Type.METADATA.name(), new MetadataDecoder());
        this.decoderMap.put(Criterion.Type.ETH_DST.name(), new EthDstDecoder());
        this.decoderMap.put(Criterion.Type.ETH_SRC.name(), new EthSrcDecoder());
        this.decoderMap.put(Criterion.Type.ETH_TYPE.name(), new EthTypeDecoder());
        this.decoderMap.put(Criterion.Type.VLAN_VID.name(), new VlanVidDecoder());
        this.decoderMap.put(Criterion.Type.VLAN_PCP.name(), new VlanPcpDecoder());
        this.decoderMap.put(Criterion.Type.INNER_VLAN_VID.name(), new InnerVlanVidDecoder());
        this.decoderMap.put(Criterion.Type.INNER_VLAN_PCP.name(), new InnerVlanPcpDecoder());
        this.decoderMap.put(Criterion.Type.IP_DSCP.name(), new IpDscpDecoder());
        this.decoderMap.put(Criterion.Type.IP_ECN.name(), new IpEcnDecoder());
        this.decoderMap.put(Criterion.Type.IP_PROTO.name(), new IpProtoDecoder());
        this.decoderMap.put(Criterion.Type.IPV4_SRC.name(), new IpV4SrcDecoder());
        this.decoderMap.put(Criterion.Type.IPV4_DST.name(), new IpV4DstDecoder());
        this.decoderMap.put(Criterion.Type.TCP_SRC.name(), new TcpSrcDecoder());
        this.decoderMap.put(Criterion.Type.TCP_DST.name(), new TcpDstDecoder());
        this.decoderMap.put(Criterion.Type.UDP_SRC.name(), new UdpSrcDecoder());
        this.decoderMap.put(Criterion.Type.UDP_DST.name(), new UdpDstDecoder());
        this.decoderMap.put(Criterion.Type.SCTP_SRC.name(), new SctpSrcDecoder());
        this.decoderMap.put(Criterion.Type.SCTP_DST.name(), new SctpDstDecoder());
        this.decoderMap.put(Criterion.Type.ICMPV4_TYPE.name(), new IcmpV4TypeDecoder());
        this.decoderMap.put(Criterion.Type.ICMPV4_CODE.name(), new IcmpV4CodeDecoder());
        this.decoderMap.put(Criterion.Type.IPV6_SRC.name(), new IpV6SrcDecoder());
        this.decoderMap.put(Criterion.Type.IPV6_DST.name(), new IpV6DstDecoder());
        this.decoderMap.put(Criterion.Type.IPV6_FLABEL.name(), new IpV6FLabelDecoder());
        this.decoderMap.put(Criterion.Type.ICMPV6_TYPE.name(), new IcmpV6TypeDecoder());
        this.decoderMap.put(Criterion.Type.ICMPV6_CODE.name(), new IcmpV6CodeDecoder());
        this.decoderMap.put(Criterion.Type.IPV6_ND_TARGET.name(), new V6NDTargetDecoder());
        this.decoderMap.put(Criterion.Type.IPV6_ND_SLL.name(), new V6NDSllDecoder());
        this.decoderMap.put(Criterion.Type.IPV6_ND_TLL.name(), new V6NDTllDecoder());
        this.decoderMap.put(Criterion.Type.MPLS_LABEL.name(), new MplsLabelDecoder());
        this.decoderMap.put(Criterion.Type.IPV6_EXTHDR.name(), new IpV6ExthdrDecoder());
        this.decoderMap.put(Criterion.Type.OCH_SIGID.name(), new OchSigIdDecoder());
        this.decoderMap.put(Criterion.Type.OCH_SIGTYPE.name(), new OchSigTypeDecoder());
        this.decoderMap.put(Criterion.Type.TUNNEL_ID.name(), new TunnelIdDecoder());
        this.decoderMap.put(Criterion.Type.ODU_SIGID.name(), new OduSigIdDecoder());
        this.decoderMap.put(Criterion.Type.ODU_SIGTYPE.name(), new OduSigTypeDecoder());
    }

    public Criterion decode() {
        String type = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("type"), (String)"Type not specified")).asText();
        CriterionDecoder decoder = this.decoderMap.get(type);
        if (decoder != null) {
            return decoder.decodeCriterion(this.json);
        }
        throw new IllegalArgumentException("Type " + type + " is unknown");
    }

    private class OduSigTypeDecoder
    implements CriterionDecoder {
        private OduSigTypeDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            OduSignalType oduSignalType = OduSignalType.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)json.get("oduSignalType"), (String)"oduSignalType member is required in Criterion")).asText());
            return Criteria.matchOduSignalType((OduSignalType)oduSignalType);
        }
    }

    private class OduSigIdDecoder
    implements CriterionDecoder {
        private OduSigIdDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            JsonNode oduSignalId = (JsonNode)Tools.nullIsIllegal((Object)json.get("oduSignalId"), (String)"tributaryPortNumber member is required in Criterion");
            int tributaryPortNumber = ((JsonNode)Tools.nullIsIllegal((Object)oduSignalId.get("tributaryPortNumber"), (String)"tributaryPortNumber member is required in Criterion")).asInt();
            int tributarySlotLen = ((JsonNode)Tools.nullIsIllegal((Object)oduSignalId.get("tributarySlotLen"), (String)"tributarySlotLen member is required in Criterion")).asInt();
            byte[] tributarySlotBitmap = HexString.fromHexString((String)((JsonNode)Tools.nullIsIllegal((Object)oduSignalId.get("tributarySlotBitmap"), (String)"tributarySlotBitmap member is required in Criterion")).asText());
            return Criteria.matchOduSignalId((OduSignalId)OduSignalId.oduSignalId((int)tributaryPortNumber, (int)tributarySlotLen, (byte[])tributarySlotBitmap));
        }
    }

    private class TunnelIdDecoder
    implements CriterionDecoder {
        private TunnelIdDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            long tunnelId = ((JsonNode)Tools.nullIsIllegal((Object)json.get("tunnelId"), (String)"tunnelId member is required in Criterion")).asLong();
            return Criteria.matchTunnelId((long)tunnelId);
        }
    }

    private class OchSigTypeDecoder
    implements CriterionDecoder {
        private OchSigTypeDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            OchSignalType ochSignalType = OchSignalType.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)json.get("ochSignalType"), (String)"ochSignalType member is required in Criterion")).asText());
            return Criteria.matchOchSignalType((OchSignalType)ochSignalType);
        }
    }

    private class OchSigIdDecoder
    implements CriterionDecoder {
        private OchSigIdDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            JsonNode ochSignalId = (JsonNode)Tools.nullIsIllegal((Object)json.get("ochSignalId"), (String)"gridType member is required in Criterion");
            GridType gridType = GridType.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)ochSignalId.get("gridType"), (String)"gridType member is required in Criterion")).asText());
            ChannelSpacing channelSpacing = ChannelSpacing.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)ochSignalId.get("channelSpacing"), (String)"channelSpacing member is required in Criterion")).asText());
            int spacingMultiplier = ((JsonNode)Tools.nullIsIllegal((Object)ochSignalId.get("spacingMultiplier"), (String)"spacingMultiplier member is required in Criterion")).asInt();
            int slotGranularity = ((JsonNode)Tools.nullIsIllegal((Object)ochSignalId.get("slotGranularity"), (String)"slotGranularity member is required in Criterion")).asInt();
            return Criteria.matchLambda((Lambda)Lambda.ochSignal((GridType)gridType, (ChannelSpacing)channelSpacing, (int)spacingMultiplier, (int)slotGranularity));
        }
    }

    private class IpV6ExthdrDecoder
    implements CriterionDecoder {
        private IpV6ExthdrDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            int exthdrFlags = ((JsonNode)Tools.nullIsIllegal((Object)json.get("exthdrFlags"), (String)"exthdrFlags member is required in Criterion")).asInt();
            return Criteria.matchIPv6ExthdrFlags((int)exthdrFlags);
        }
    }

    private class MplsLabelDecoder
    implements CriterionDecoder {
        private MplsLabelDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            int label = ((JsonNode)Tools.nullIsIllegal((Object)json.get("label"), (String)"label member is required in Criterion")).asInt();
            return Criteria.matchMplsLabel((MplsLabel)MplsLabel.mplsLabel((int)label));
        }
    }

    private class V6NDTllDecoder
    implements CriterionDecoder {
        private V6NDTllDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            MacAddress mac = MacAddress.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)json.get("mac"), (String)"mac member is required in Criterion")).asText());
            return Criteria.matchIPv6NDTargetLinkLayerAddress((MacAddress)mac);
        }
    }

    private class V6NDSllDecoder
    implements CriterionDecoder {
        private V6NDSllDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            MacAddress mac = MacAddress.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)json.get("mac"), (String)"mac member is required in Criterion")).asText());
            return Criteria.matchIPv6NDSourceLinkLayerAddress((MacAddress)mac);
        }
    }

    private class V6NDTargetDecoder
    implements CriterionDecoder {
        private V6NDTargetDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            Ip6Address target = Ip6Address.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)json.get("targetAddress"), (String)"targetAddress member is required in Criterion")).asText());
            return Criteria.matchIPv6NDTargetAddress((Ip6Address)target);
        }
    }

    private class IcmpV6CodeDecoder
    implements CriterionDecoder {
        private IcmpV6CodeDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            short code = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get("icmpv6Code"), (String)"icmpv6Code member is required in Criterion")).asInt();
            return Criteria.matchIcmpv6Code((short)code);
        }
    }

    private class IcmpV6TypeDecoder
    implements CriterionDecoder {
        private IcmpV6TypeDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            short type = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get("icmpv6Type"), (String)"icmpv6Type member is required in Criterion")).asInt();
            return Criteria.matchIcmpv6Type((short)type);
        }
    }

    private class IpV6FLabelDecoder
    implements CriterionDecoder {
        private IpV6FLabelDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            int flowLabel = ((JsonNode)Tools.nullIsIllegal((Object)json.get("flowLabel"), (String)"flowLabel member is required in Criterion")).asInt();
            return Criteria.matchIPv6FlowLabel((int)flowLabel);
        }
    }

    private class IcmpV4CodeDecoder
    implements CriterionDecoder {
        private IcmpV4CodeDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            short code = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get("icmpCode"), (String)"icmpCode member is required in Criterion")).asInt();
            return Criteria.matchIcmpCode((short)code);
        }
    }

    private class IcmpV4TypeDecoder
    implements CriterionDecoder {
        private IcmpV4TypeDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            short type = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get("icmpType"), (String)"icmpType member is required in Criterion")).asInt();
            return Criteria.matchIcmpType((short)type);
        }
    }

    private class SctpDstDecoder
    implements CriterionDecoder {
        private SctpDstDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            TpPort sctpPort = TpPort.tpPort((int)((JsonNode)Tools.nullIsIllegal((Object)json.get("sctpPort"), (String)"sctpPort member is required in Criterion")).asInt());
            return Criteria.matchSctpDst((TpPort)sctpPort);
        }
    }

    private class SctpSrcDecoder
    implements CriterionDecoder {
        private SctpSrcDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            TpPort sctpPort = TpPort.tpPort((int)((JsonNode)Tools.nullIsIllegal((Object)json.get("sctpPort"), (String)"sctpPort member is required in Criterion")).asInt());
            return Criteria.matchSctpSrc((TpPort)sctpPort);
        }
    }

    private class UdpDstDecoder
    implements CriterionDecoder {
        private UdpDstDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            TpPort udpPort = TpPort.tpPort((int)((JsonNode)Tools.nullIsIllegal((Object)json.get("udpPort"), (String)"udpPort member is required in Criterion")).asInt());
            return Criteria.matchUdpDst((TpPort)udpPort);
        }
    }

    private class UdpSrcDecoder
    implements CriterionDecoder {
        private UdpSrcDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            TpPort udpPort = TpPort.tpPort((int)((JsonNode)Tools.nullIsIllegal((Object)json.get("udpPort"), (String)"udpPort member is required in Criterion")).asInt());
            return Criteria.matchUdpSrc((TpPort)udpPort);
        }
    }

    private class TcpDstDecoder
    implements CriterionDecoder {
        private TcpDstDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            TpPort tcpPort = TpPort.tpPort((int)((JsonNode)Tools.nullIsIllegal((Object)json.get("tcpPort"), (String)"tcpPort member is required in Criterion")).asInt());
            return Criteria.matchTcpDst((TpPort)tcpPort);
        }
    }

    private class TcpSrcDecoder
    implements CriterionDecoder {
        private TcpSrcDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            TpPort tcpPort = TpPort.tpPort((int)((JsonNode)Tools.nullIsIllegal((Object)json.get("tcpPort"), (String)"tcpPort member is required in Criterion")).asInt());
            return Criteria.matchTcpSrc((TpPort)tcpPort);
        }
    }

    private class IpV6DstDecoder
    implements CriterionDecoder {
        private IpV6DstDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            String ip = ((JsonNode)Tools.nullIsIllegal((Object)json.get("ip"), (String)"ip member is required in Criterion")).asText();
            return Criteria.matchIPv6Dst((IpPrefix)IpPrefix.valueOf((String)ip));
        }
    }

    private class IpV6SrcDecoder
    implements CriterionDecoder {
        private IpV6SrcDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            String ip = ((JsonNode)Tools.nullIsIllegal((Object)json.get("ip"), (String)"ip member is required in Criterion")).asText();
            return Criteria.matchIPv6Src((IpPrefix)IpPrefix.valueOf((String)ip));
        }
    }

    private class IpV4DstDecoder
    implements CriterionDecoder {
        private IpV4DstDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            String ip = ((JsonNode)Tools.nullIsIllegal((Object)json.get("ip"), (String)"ip member is required in Criterion")).asText();
            return Criteria.matchIPDst((IpPrefix)IpPrefix.valueOf((String)ip));
        }
    }

    private class IpV4SrcDecoder
    implements CriterionDecoder {
        private IpV4SrcDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            String ip = ((JsonNode)Tools.nullIsIllegal((Object)json.get("ip"), (String)"ip member is required in Criterion")).asText();
            return Criteria.matchIPSrc((IpPrefix)IpPrefix.valueOf((String)ip));
        }
    }

    private class IpProtoDecoder
    implements CriterionDecoder {
        private IpProtoDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            short proto = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get("protocol"), (String)"protocol member is required in Criterion")).asInt();
            return Criteria.matchIPProtocol((short)proto);
        }
    }

    private class IpEcnDecoder
    implements CriterionDecoder {
        private IpEcnDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            byte ipEcn = (byte)((JsonNode)Tools.nullIsIllegal((Object)json.get("ipEcn"), (String)"ipEcn member is required in Criterion")).asInt();
            return Criteria.matchIPEcn((byte)ipEcn);
        }
    }

    private class IpDscpDecoder
    implements CriterionDecoder {
        private IpDscpDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            byte ipDscp = (byte)((JsonNode)Tools.nullIsIllegal((Object)json.get("ipDscp"), (String)"ipDscp member is required in Criterion")).asInt();
            return Criteria.matchIPDscp((byte)ipDscp);
        }
    }

    private class InnerVlanPcpDecoder
    implements CriterionDecoder {
        private InnerVlanPcpDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            byte priority = (byte)((JsonNode)Tools.nullIsIllegal((Object)json.get("innerPriority"), (String)"innerPriority member is required in Criterion")).asInt();
            return Criteria.matchInnerVlanPcp((byte)priority);
        }
    }

    private class InnerVlanVidDecoder
    implements CriterionDecoder {
        private InnerVlanVidDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            short vlanId = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get("innerVlanId"), (String)"innerVlanId member is required in Criterion")).asInt();
            return Criteria.matchInnerVlanId((VlanId)VlanId.vlanId((short)vlanId));
        }
    }

    private class VlanPcpDecoder
    implements CriterionDecoder {
        private VlanPcpDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            byte priority = (byte)((JsonNode)Tools.nullIsIllegal((Object)json.get("priority"), (String)"priority member is required in Criterion")).asInt();
            return Criteria.matchVlanPcp((byte)priority);
        }
    }

    private class VlanVidDecoder
    implements CriterionDecoder {
        private VlanVidDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            short vlanId = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get("vlanId"), (String)"vlanId member is required in Criterion")).asInt();
            return Criteria.matchVlanId((VlanId)VlanId.vlanId((short)vlanId));
        }
    }

    private class MetadataDecoder
    implements CriterionDecoder {
        private MetadataDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            long metadata = ((JsonNode)Tools.nullIsIllegal((Object)json.get("metadata"), (String)"metadata member is required in Criterion")).asLong();
            return Criteria.matchMetadata((long)metadata);
        }
    }

    private class InPhyPortDecoder
    implements CriterionDecoder {
        private InPhyPortDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            PortNumber port = PortNumber.portNumber((long)((JsonNode)Tools.nullIsIllegal((Object)json.get("port"), (String)"port member is required in Criterion")).asLong());
            return Criteria.matchInPhyPort((PortNumber)port);
        }
    }

    private class InPortDecoder
    implements CriterionDecoder {
        private InPortDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            PortNumber port = PortNumber.portNumber((long)((JsonNode)Tools.nullIsIllegal((Object)json.get("port"), (String)"port member is required in Criterion")).asLong());
            return Criteria.matchInPort((PortNumber)port);
        }
    }

    private class EthSrcDecoder
    implements CriterionDecoder {
        private EthSrcDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            MacAddress mac = MacAddress.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)json.get("mac"), (String)"mac member is required in Criterion")).asText());
            return Criteria.matchEthSrc((MacAddress)mac);
        }
    }

    private class EthDstDecoder
    implements CriterionDecoder {
        private EthDstDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            MacAddress mac = MacAddress.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)json.get("mac"), (String)"mac member is required in Criterion")).asText());
            return Criteria.matchEthDst((MacAddress)mac);
        }
    }

    private class EthTypeDecoder
    implements CriterionDecoder {
        private EthTypeDecoder() {
        }

        @Override
        public Criterion decodeCriterion(ObjectNode json) {
            JsonNode ethTypeNode = (JsonNode)Tools.nullIsIllegal((Object)json.get("ethType"), (String)"ethType member is required in Criterion");
            int ethType = ethTypeNode.isInt() ? ethTypeNode.asInt() : Integer.decode(ethTypeNode.textValue()).intValue();
            return Criteria.matchEthType((int)ethType);
        }
    }

    private static interface CriterionDecoder {
        public Criterion decodeCriterion(ObjectNode var1);
    }
}

