/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.onlab.util.Bandwidth;
import org.onlab.util.Tools;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.constraint.AnnotationConstraint;
import org.onosproject.net.intent.constraint.AsymmetricPathConstraint;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.intent.constraint.LatencyConstraint;
import org.onosproject.net.intent.constraint.LinkTypeConstraint;
import org.onosproject.net.intent.constraint.ObstacleConstraint;
import org.onosproject.net.intent.constraint.WaypointConstraint;

public final class DecodeConstraintCodecHelper {
    private final ObjectNode json;

    public DecodeConstraintCodecHelper(ObjectNode json) {
        this.json = json;
    }

    private Constraint decodeLinkTypeConstraint() {
        boolean inclusive = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("inclusive"), (String)"inclusive member is required in Constraint")).asBoolean();
        JsonNode types = (JsonNode)Tools.nullIsIllegal((Object)this.json.get("types"), (String)"types member is required in Constraint");
        if (types.size() < 1) {
            throw new IllegalArgumentException("types array in link constraint must have at least one value");
        }
        ArrayList typesEntries = new ArrayList(types.size());
        IntStream.range(0, types.size()).forEach(index -> typesEntries.add(Link.Type.valueOf((String)types.get(index).asText())));
        return new LinkTypeConstraint(inclusive, typesEntries.toArray(new Link.Type[types.size()]));
    }

    private Constraint decodeAnnotationConstraint() {
        String key = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("key"), (String)"key member is required in Constraint")).asText();
        double threshold = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("threshold"), (String)"threshold member is required in Constraint")).asDouble();
        return new AnnotationConstraint(key, threshold);
    }

    private Constraint decodeLatencyConstraint() {
        long latencyMillis = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("latencyMillis"), (String)"latencyMillis member is required in Constraint")).asLong();
        return new LatencyConstraint(Duration.ofMillis(latencyMillis));
    }

    private Constraint decodeObstacleConstraint() {
        JsonNode obstacles = (JsonNode)Tools.nullIsIllegal((Object)this.json.get("obstacles"), (String)"obstacles member is required in Constraint");
        if (obstacles.size() < 1) {
            throw new IllegalArgumentException("obstacles array in obstacles constraint must have at least one value");
        }
        ArrayList obstacleEntries = new ArrayList(obstacles.size());
        IntStream.range(0, obstacles.size()).forEach(index -> obstacleEntries.add(DeviceId.deviceId((String)obstacles.get(index).asText())));
        return new ObstacleConstraint(obstacleEntries.toArray(new DeviceId[obstacles.size()]));
    }

    private Constraint decodeWaypointConstraint() {
        JsonNode waypoints = (JsonNode)Tools.nullIsIllegal((Object)this.json.get("waypoints"), (String)"waypoints member is required in Constraint");
        if (waypoints.size() < 1) {
            throw new IllegalArgumentException("obstacles array in obstacles constraint must have at least one value");
        }
        ArrayList waypointEntries = new ArrayList(waypoints.size());
        IntStream.range(0, waypoints.size()).forEach(index -> waypointEntries.add(DeviceId.deviceId((String)waypoints.get(index).asText())));
        return new WaypointConstraint(waypointEntries.toArray(new DeviceId[waypoints.size()]));
    }

    private Constraint decodeAsymmetricPathConstraint() {
        return new AsymmetricPathConstraint();
    }

    private Constraint decodeBandwidthConstraint() {
        double bandwidth = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("bandwidth"), (String)"bandwidth member is required in Constraint")).asDouble();
        return new BandwidthConstraint(Bandwidth.bps((double)bandwidth));
    }

    public Constraint decode() {
        String type = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("type"), (String)"type member is required in Constraint")).asText();
        if (type.equals(BandwidthConstraint.class.getSimpleName())) {
            return this.decodeBandwidthConstraint();
        }
        if (type.equals(LinkTypeConstraint.class.getSimpleName())) {
            return this.decodeLinkTypeConstraint();
        }
        if (type.equals(AnnotationConstraint.class.getSimpleName())) {
            return this.decodeAnnotationConstraint();
        }
        if (type.equals(LatencyConstraint.class.getSimpleName())) {
            return this.decodeLatencyConstraint();
        }
        if (type.equals(ObstacleConstraint.class.getSimpleName())) {
            return this.decodeObstacleConstraint();
        }
        if (type.equals(WaypointConstraint.class.getSimpleName())) {
            return this.decodeWaypointConstraint();
        }
        if (type.equals(AsymmetricPathConstraint.class.getSimpleName())) {
            return this.decodeAsymmetricPathConstraint();
        }
        throw new IllegalArgumentException("Instruction type " + type + " is not supported");
    }
}

