/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;

public final class ControllerNodeCodec
extends JsonCodec<ControllerNode> {
    public ObjectNode encode(ControllerNode node, CodecContext context) {
        Preconditions.checkNotNull((Object)node, (Object)"Controller node cannot be null");
        ClusterService service = (ClusterService)context.getService(ClusterService.class);
        return context.mapper().createObjectNode().put("id", node.id().toString()).put("ip", node.ip().toString()).put("tcpPort", node.tcpPort()).put("status", service.getState(node.id()).toString());
    }

    public ControllerNode decode(ObjectNode json, CodecContext context) {
        Preconditions.checkNotNull((Object)json, (Object)"JSON cannot be null");
        String ip = json.path("ip").asText();
        return new DefaultControllerNode(new NodeId(json.path("id").asText(ip)), IpAddress.valueOf((String)ip), json.path("tcpPort").asInt(9876));
    }
}

