/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;

public final class ConnectivityIntentCodec
extends JsonCodec<ConnectivityIntent> {
    private static final String CONSTRAINTS = "constraints";
    private static final String SELECTOR = "selector";
    private static final String TREATMENT = "treatment";

    public ObjectNode encode(ConnectivityIntent intent, CodecContext context) {
        Preconditions.checkNotNull((Object)intent, (Object)"Connectivity intent cannot be null");
        JsonCodec intentCodec = context.codec(Intent.class);
        ObjectNode result = intentCodec.encode((Object)intent, context);
        if (intent.selector() != null) {
            JsonCodec selectorCodec = context.codec(TrafficSelector.class);
            result.set(SELECTOR, (JsonNode)selectorCodec.encode((Object)intent.selector(), context));
        }
        if (intent.treatment() != null) {
            JsonCodec treatmentCodec = context.codec(TrafficTreatment.class);
            result.set(TREATMENT, (JsonNode)treatmentCodec.encode((Object)intent.treatment(), context));
        }
        result.put("priority", intent.priority());
        if (intent.constraints() != null) {
            ArrayNode jsonConstraints = result.putArray(CONSTRAINTS);
            if (intent.constraints() != null) {
                JsonCodec constraintCodec = context.codec(Constraint.class);
                for (Constraint constraint : intent.constraints()) {
                    ObjectNode constraintNode = constraintCodec.encode((Object)constraint, context);
                    jsonConstraints.add((JsonNode)constraintNode);
                }
            }
        }
        return result;
    }

    public static void intentAttributes(ObjectNode json, CodecContext context, ConnectivityIntent.Builder builder) {
        ObjectNode treatmentJson;
        ObjectNode selectorJson;
        JsonNode constraintsJson = json.get(CONSTRAINTS);
        if (constraintsJson != null) {
            JsonCodec constraintsCodec = context.codec(Constraint.class);
            ArrayList constraints = new ArrayList(constraintsJson.size());
            IntStream.range(0, constraintsJson.size()).forEach(i -> constraints.add(constraintsCodec.decode(ConnectivityIntentCodec.get((JsonNode)constraintsJson, (int)i), context)));
            builder.constraints(constraints);
        }
        if ((selectorJson = ConnectivityIntentCodec.get((ObjectNode)json, (String)SELECTOR)) != null) {
            JsonCodec selectorCodec = context.codec(TrafficSelector.class);
            TrafficSelector selector = (TrafficSelector)selectorCodec.decode(selectorJson, context);
            builder.selector(selector);
        }
        if ((treatmentJson = ConnectivityIntentCodec.get((ObjectNode)json, (String)TREATMENT)) != null) {
            JsonCodec treatmentCodec = context.codec(TrafficTreatment.class);
            TrafficTreatment treatment = (TrafficTreatment)treatmentCodec.decode(treatmentJson, context);
            builder.treatment(treatment);
        }
    }
}

