/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.PortNumber;

public final class ConnectPointCodec
extends JsonCodec<ConnectPoint> {
    private static final String ELEMENT_HOST = "host";
    private static final String ELEMENT_DEVICE = "device";
    private static final String PORT = "port";

    public ObjectNode encode(ConnectPoint point, CodecContext context) {
        Preconditions.checkNotNull((Object)point, (Object)"Connect point cannot be null");
        ObjectNode root = context.mapper().createObjectNode().put(PORT, point.port().toString());
        if (point.elementId() instanceof DeviceId) {
            root.put(ELEMENT_DEVICE, point.deviceId().toString());
        } else if (point.elementId() instanceof HostId) {
            root.put(ELEMENT_HOST, point.hostId().toString());
        }
        return root;
    }

    public ConnectPoint decode(ObjectNode json, CodecContext context) {
        DeviceId elementId;
        if (json == null || !json.isObject()) {
            return null;
        }
        if (json.has(ELEMENT_DEVICE)) {
            elementId = DeviceId.deviceId((String)json.get(ELEMENT_DEVICE).asText());
        } else if (json.has(ELEMENT_HOST)) {
            elementId = HostId.hostId((String)json.get(ELEMENT_HOST).asText());
        } else {
            return null;
        }
        PortNumber portNumber = PortNumber.portNumber((String)json.get(PORT).asText());
        return new ConnectPoint((ElementId)elementId, portNumber);
    }
}

