/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.codahale.metrics.Metric;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ethernet;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.AnnotationsCodec;
import org.onosproject.codec.impl.ApplicationCodec;
import org.onosproject.codec.impl.ApplicationIdCodec;
import org.onosproject.codec.impl.ConnectPointCodec;
import org.onosproject.codec.impl.ConnectivityIntentCodec;
import org.onosproject.codec.impl.ConstraintCodec;
import org.onosproject.codec.impl.ControllerNodeCodec;
import org.onosproject.codec.impl.CriterionCodec;
import org.onosproject.codec.impl.DeviceCodec;
import org.onosproject.codec.impl.DeviceKeyCodec;
import org.onosproject.codec.impl.DisjointPathCodec;
import org.onosproject.codec.impl.DriverCodec;
import org.onosproject.codec.impl.EthernetCodec;
import org.onosproject.codec.impl.FilteredConnectPointCodec;
import org.onosproject.codec.impl.FilteringObjectiveCodec;
import org.onosproject.codec.impl.FlowEntryCodec;
import org.onosproject.codec.impl.FlowRuleCodec;
import org.onosproject.codec.impl.ForwardingObjectiveCodec;
import org.onosproject.codec.impl.GroupBucketCodec;
import org.onosproject.codec.impl.GroupCodec;
import org.onosproject.codec.impl.HostCodec;
import org.onosproject.codec.impl.HostLocationCodec;
import org.onosproject.codec.impl.HostToHostIntentCodec;
import org.onosproject.codec.impl.InstructionCodec;
import org.onosproject.codec.impl.IntentCodec;
import org.onosproject.codec.impl.LinkCodec;
import org.onosproject.codec.impl.LoadCodec;
import org.onosproject.codec.impl.MastershipRoleCodec;
import org.onosproject.codec.impl.MastershipTermCodec;
import org.onosproject.codec.impl.McastRouteCodec;
import org.onosproject.codec.impl.MeterBandCodec;
import org.onosproject.codec.impl.MeterCodec;
import org.onosproject.codec.impl.MeterRequestCodec;
import org.onosproject.codec.impl.MetricCodec;
import org.onosproject.codec.impl.NextObjectiveCodec;
import org.onosproject.codec.impl.PacketRequestCodec;
import org.onosproject.codec.impl.PathCodec;
import org.onosproject.codec.impl.PointToPointIntentCodec;
import org.onosproject.codec.impl.PortCodec;
import org.onosproject.codec.impl.PortStatisticsCodec;
import org.onosproject.codec.impl.RegionCodec;
import org.onosproject.codec.impl.RoleInfoCodec;
import org.onosproject.codec.impl.RouteCodec;
import org.onosproject.codec.impl.SinglePointToMultiPointIntentCodec;
import org.onosproject.codec.impl.TableStatisticsEntryCodec;
import org.onosproject.codec.impl.TenantIdCodec;
import org.onosproject.codec.impl.TopologyClusterCodec;
import org.onosproject.codec.impl.TopologyCodec;
import org.onosproject.codec.impl.TrafficSelectorCodec;
import org.onosproject.codec.impl.TrafficTreatmentCodec;
import org.onosproject.codec.impl.TransportEndpointDescriptionCodec;
import org.onosproject.codec.impl.VirtualDeviceCodec;
import org.onosproject.codec.impl.VirtualHostCodec;
import org.onosproject.codec.impl.VirtualLinkCodec;
import org.onosproject.codec.impl.VirtualNetworkCodec;
import org.onosproject.codec.impl.VirtualPortCodec;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.dpi.DpiStatInfo;
import org.onosproject.incubator.net.dpi.DpiStatInfoCodec;
import org.onosproject.incubator.net.dpi.DpiStatistics;
import org.onosproject.incubator.net.dpi.DpiStatisticsCodec;
import org.onosproject.incubator.net.dpi.FlowStatInfo;
import org.onosproject.incubator.net.dpi.FlowStatInfoCodec;
import org.onosproject.incubator.net.dpi.ProtocolStatInfo;
import org.onosproject.incubator.net.dpi.ProtocolStatInfoCodec;
import org.onosproject.incubator.net.dpi.TrafficStatInfo;
import org.onosproject.incubator.net.dpi.TrafficStatInfoCodec;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.virtual.TenantId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.incubator.net.virtual.VirtualHost;
import org.onosproject.incubator.net.virtual.VirtualLink;
import org.onosproject.incubator.net.virtual.VirtualNetwork;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.Path;
import org.onosproject.net.Port;
import org.onosproject.net.behaviour.protection.TransportEndpointDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TableStatisticsEntry;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;
import org.onosproject.net.key.DeviceKey;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterRequest;
import org.onosproject.net.packet.PacketRequest;
import org.onosproject.net.region.Region;
import org.onosproject.net.statistic.Load;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class CodecManager
implements CodecService {
    private static Logger log = LoggerFactory.getLogger(CodecManager.class);
    private final Map<Class<?>, JsonCodec> codecs = new ConcurrentHashMap();

    @Activate
    public void activate() {
        this.codecs.clear();
        this.registerCodec(Application.class, new ApplicationCodec());
        this.registerCodec(ApplicationId.class, new ApplicationIdCodec());
        this.registerCodec(ControllerNode.class, new ControllerNodeCodec());
        this.registerCodec(Annotations.class, new AnnotationsCodec());
        this.registerCodec(Device.class, new DeviceCodec());
        this.registerCodec(Port.class, new PortCodec());
        this.registerCodec(ConnectPoint.class, new ConnectPointCodec());
        this.registerCodec(Link.class, new LinkCodec());
        this.registerCodec(Host.class, new HostCodec());
        this.registerCodec(HostLocation.class, new HostLocationCodec());
        this.registerCodec(HostToHostIntent.class, new HostToHostIntentCodec());
        this.registerCodec(PointToPointIntent.class, new PointToPointIntentCodec());
        this.registerCodec(SinglePointToMultiPointIntent.class, new SinglePointToMultiPointIntentCodec());
        this.registerCodec(Intent.class, new IntentCodec());
        this.registerCodec(ConnectivityIntent.class, new ConnectivityIntentCodec());
        this.registerCodec(FlowEntry.class, new FlowEntryCodec());
        this.registerCodec(FlowRule.class, new FlowRuleCodec());
        this.registerCodec(TrafficTreatment.class, new TrafficTreatmentCodec());
        this.registerCodec(TrafficSelector.class, new TrafficSelectorCodec());
        this.registerCodec(Instruction.class, new InstructionCodec());
        this.registerCodec(Criterion.class, new CriterionCodec());
        this.registerCodec(Ethernet.class, new EthernetCodec());
        this.registerCodec(Constraint.class, new ConstraintCodec());
        this.registerCodec(Topology.class, new TopologyCodec());
        this.registerCodec(TopologyCluster.class, new TopologyClusterCodec());
        this.registerCodec(Path.class, new PathCodec());
        this.registerCodec(DisjointPath.class, new DisjointPathCodec());
        this.registerCodec(Group.class, new GroupCodec());
        this.registerCodec(Driver.class, new DriverCodec());
        this.registerCodec(GroupBucket.class, new GroupBucketCodec());
        this.registerCodec(Load.class, new LoadCodec());
        this.registerCodec(MeterRequest.class, new MeterRequestCodec());
        this.registerCodec(Meter.class, new MeterCodec());
        this.registerCodec(Band.class, new MeterBandCodec());
        this.registerCodec(TableStatisticsEntry.class, new TableStatisticsEntryCodec());
        this.registerCodec(PortStatistics.class, new PortStatisticsCodec());
        this.registerCodec(Metric.class, new MetricCodec());
        this.registerCodec(FilteringObjective.class, new FilteringObjectiveCodec());
        this.registerCodec(ForwardingObjective.class, new ForwardingObjectiveCodec());
        this.registerCodec(NextObjective.class, new NextObjectiveCodec());
        this.registerCodec(McastRoute.class, new McastRouteCodec());
        this.registerCodec(DeviceKey.class, new DeviceKeyCodec());
        this.registerCodec(Region.class, new RegionCodec());
        this.registerCodec(TenantId.class, new TenantIdCodec());
        this.registerCodec(VirtualNetwork.class, new VirtualNetworkCodec());
        this.registerCodec(VirtualDevice.class, new VirtualDeviceCodec());
        this.registerCodec(VirtualPort.class, new VirtualPortCodec());
        this.registerCodec(VirtualLink.class, new VirtualLinkCodec());
        this.registerCodec(VirtualHost.class, new VirtualHostCodec());
        this.registerCodec(MastershipTerm.class, new MastershipTermCodec());
        this.registerCodec(MastershipRole.class, new MastershipRoleCodec());
        this.registerCodec(RoleInfo.class, new RoleInfoCodec());
        this.registerCodec((Class)DpiStatistics.class, (JsonCodec)new DpiStatisticsCodec());
        this.registerCodec((Class)DpiStatInfo.class, (JsonCodec)new DpiStatInfoCodec());
        this.registerCodec((Class)TrafficStatInfo.class, (JsonCodec)new TrafficStatInfoCodec());
        this.registerCodec((Class)ProtocolStatInfo.class, (JsonCodec)new ProtocolStatInfoCodec());
        this.registerCodec((Class)FlowStatInfo.class, (JsonCodec)new FlowStatInfoCodec());
        this.registerCodec(FilteredConnectPoint.class, new FilteredConnectPointCodec());
        this.registerCodec(TransportEndpointDescription.class, new TransportEndpointDescriptionCodec());
        this.registerCodec(PacketRequest.class, new PacketRequestCodec());
        this.registerCodec(Route.class, new RouteCodec());
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.codecs.clear();
        log.info("Stopped");
    }

    public Set<Class<?>> getCodecs() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CODEC_READ);
        return ImmutableSet.copyOf(this.codecs.keySet());
    }

    public <T> JsonCodec<T> getCodec(Class<T> entityClass) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CODEC_READ);
        return this.codecs.get(entityClass);
    }

    public <T> void registerCodec(Class<T> entityClass, JsonCodec<T> codec) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CODEC_WRITE);
        this.codecs.putIfAbsent(entityClass, codec);
    }

    public void unregisterCodec(Class<?> entityClass) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CODEC_WRITE);
        this.codecs.remove(entityClass);
    }
}

