/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplicationId;

public final class ApplicationIdCodec
extends JsonCodec<ApplicationId> {
    private static final String APP_ID = "id";
    private static final String APP_NAME = "name";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in ApplicationId";

    public ObjectNode encode(ApplicationId appId, CodecContext context) {
        Preconditions.checkNotNull((Object)appId, (Object)"ApplicationId cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(APP_ID, appId.id()).put(APP_NAME, appId.name());
        return result;
    }

    public ApplicationId decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        int id = ((JsonNode)Tools.nullIsIllegal((Object)json.get(APP_ID), (String)"id member is required in ApplicationId")).asInt();
        String name = ((JsonNode)Tools.nullIsIllegal((Object)json.get(APP_NAME), (String)"name member is required in ApplicationId")).asText();
        return new DefaultApplicationId(id, name);
    }
}

