/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.apache.commons.lang3.StringEscapeUtils;
import org.onosproject.app.ApplicationService;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.Application;

public final class ApplicationCodec
extends JsonCodec<Application> {
    public ObjectNode encode(Application app, CodecContext context) {
        Preconditions.checkNotNull((Object)app, (Object)"Application cannot be null");
        ApplicationService service = (ApplicationService)context.getService(ApplicationService.class);
        ArrayNode permissions = context.mapper().createArrayNode();
        ArrayNode features = context.mapper().createArrayNode();
        ArrayNode requiredApps = context.mapper().createArrayNode();
        app.permissions().forEach(p -> permissions.add(p.toString()));
        app.features().forEach(f -> features.add(f));
        app.requiredApps().forEach(a -> requiredApps.add(a));
        ObjectNode result = context.mapper().createObjectNode().put("name", app.id().name()).put("id", app.id().id()).put("version", app.version().toString()).put("category", app.category()).put("description", StringEscapeUtils.escapeJson((String)app.description())).put("readme", StringEscapeUtils.escapeJson((String)app.readme())).put("origin", app.origin()).put("url", app.url()).put("featuresRepo", app.featuresRepo().map(URI::toString).orElse("")).put("state", service.getState(app.id()).toString());
        result.set("features", (JsonNode)features);
        result.set("permissions", (JsonNode)permissions);
        result.set("requiredApps", (JsonNode)requiredApps);
        return result;
    }
}

