/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.lldp.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.onosproject.net.Annotations;
import org.onosproject.net.Device;
import org.onosproject.net.Element;
import org.onosproject.net.Port;

public class SuppressionRules {
    public static final String ANY_VALUE = "(any)";
    private final Set<Device.Type> suppressedDeviceType;
    private final Map<String, String> suppressedAnnotation;

    public SuppressionRules(Set<Device.Type> suppressedType, Map<String, String> suppressedAnnotation) {
        this.suppressedDeviceType = ImmutableSet.copyOf(suppressedType);
        this.suppressedAnnotation = ImmutableMap.copyOf(suppressedAnnotation);
    }

    public boolean isSuppressed(Device device) {
        if (this.suppressedDeviceType.contains(device.type())) {
            return true;
        }
        Annotations annotations = device.annotations();
        return this.containsSuppressionAnnotation(annotations);
    }

    public boolean isSuppressed(Port port) {
        Element parent = port.element();
        if (parent instanceof Device && this.isSuppressed((Device)parent)) {
            return true;
        }
        Annotations annotations = port.annotations();
        return this.containsSuppressionAnnotation(annotations);
    }

    private boolean containsSuppressionAnnotation(Annotations annotations) {
        for (Map.Entry<String, String> entry : this.suppressedAnnotation.entrySet()) {
            String suppValue = entry.getValue();
            String suppKey = entry.getKey();
            if (!(suppValue == ANY_VALUE ? annotations.keys().contains(suppKey) : suppValue.equals(annotations.value(suppKey)))) continue;
            return true;
        }
        return false;
    }

    Set<Device.Type> getSuppressedDeviceType() {
        return this.suppressedDeviceType;
    }

    Map<String, String> getSuppressedAnnotation() {
        return this.suppressedAnnotation;
    }

    public int hashCode() {
        return Objects.hash(this.suppressedDeviceType, this.suppressedAnnotation);
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            SuppressionRules that = (SuppressionRules)object;
            return Objects.equals(this.suppressedDeviceType, that.suppressedDeviceType) && Objects.equals(this.suppressedAnnotation, that.suppressedAnnotation);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("suppressedDeviceType", this.suppressedDeviceType).add("suppressedAnnotation", this.suppressedAnnotation).toString();
    }
}

