/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.lldp.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.Device;
import org.onosproject.net.config.Config;
import org.onosproject.provider.lldp.impl.LldpLinkProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuppressionConfig
extends Config<ApplicationId> {
    private static final String DEVICE_TYPES = "deviceTypes";
    private static final String ANNOTATION = "annotation";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final List<Device.Type> DEFAULT_DEVICE_TYPES = ImmutableList.copyOf(LldpLinkProvider.DEFAULT_RULES.getSuppressedDeviceType());
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Set<Device.Type> deviceTypes() {
        return ImmutableSet.copyOf((Collection)this.getList(DEVICE_TYPES, Device.Type::valueOf, DEFAULT_DEVICE_TYPES));
    }

    public SuppressionConfig deviceTypes(Set<Device.Type> deviceTypes) {
        return (SuppressionConfig)this.setOrClear(DEVICE_TYPES, deviceTypes);
    }

    public Map<String, String> annotation() {
        JsonNode annotationNode;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String jsonAnnotation = this.get(ANNOTATION, null);
        if (jsonAnnotation == null || jsonAnnotation.isEmpty()) {
            return ImmutableMap.of();
        }
        try {
            annotationNode = MAPPER.readTree(jsonAnnotation);
        }
        catch (IOException e) {
            this.log.error("Failed to read JSON tree from: {}", (Object)jsonAnnotation);
            return ImmutableMap.of();
        }
        if (annotationNode.isObject()) {
            ObjectNode obj = (ObjectNode)annotationNode;
            Iterator it = obj.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String key = (String)entry.getKey();
                JsonNode value = (JsonNode)entry.getValue();
                if (value.isValueNode()) {
                    if (value.isNull()) {
                        builder.put((Object)key, (Object)"(any)");
                        continue;
                    }
                    builder.put((Object)key, (Object)value.asText());
                    continue;
                }
                this.log.warn("Encountered unexpected JSON field {} for annotation", (Object)entry);
            }
        } else {
            this.log.error("Encountered unexpected JSONNode {} for annotation", (Object)annotationNode);
            return ImmutableMap.of();
        }
        return builder.build();
    }

    public SuppressionConfig annotation(Map<String, String> annotation) {
        Map config = Maps.transformValues(annotation, v -> v == "(any)" ? null : v);
        String jsonAnnotation = null;
        try {
            jsonAnnotation = MAPPER.writeValueAsString((Object)config);
        }
        catch (JsonProcessingException e) {
            this.log.error("Failed to write JSON from: {}", annotation);
        }
        return (SuppressionConfig)this.setOrClear(ANNOTATION, jsonAnnotation);
    }
}

