/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.lldp.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ClusterMetadataService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.Port;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.link.ProbedLinkProvider;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.lldp.impl.LinkDiscoveryFromDevice;
import org.onosproject.provider.lldp.impl.LinkDiscoveryFromPort;
import org.onosproject.provider.lldp.impl.SuppressionConfig;
import org.onosproject.provider.lldp.impl.SuppressionRules;
import org.onosproject.provider.lldpcommon.LinkDiscovery;
import org.onosproject.provider.lldpcommon.LinkDiscoveryContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class LldpLinkProvider
extends AbstractProvider
implements ProbedLinkProvider {
    private static final String PROVIDER_NAME = "org.onosproject.provider.lldp";
    private static final String FORMAT = "Settings: enabled={}, useBDDP={}, probeRate={}, staleLinkAge={}";
    public static final String NO_LLDP = "no-lldp";
    private static final int MAX_RETRIES = 5;
    private static final int RETRY_DELAY = 1000;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService masterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterMetadataService clusterMetadataService;
    private LinkProviderService providerService;
    private ScheduledExecutorService executor;
    protected ExecutorService eventExecutor;
    private boolean shuttingDown = false;
    private static final long DEVICE_SYNC_DELAY = 5L;
    private static final long LINK_PRUNER_DELAY = 3L;
    private static final String PROP_ENABLED = "enabled";
    @Property(name="enabled", boolValue={true}, label="If false, link discovery is disabled")
    private boolean enabled = false;
    private static final String PROP_USE_BDDP = "useBDDP";
    @Property(name="useBDDP", boolValue={true}, label="Use BDDP for link discovery")
    private boolean useBddp = true;
    private static final String PROP_PROBE_RATE = "probeRate";
    private static final int DEFAULT_PROBE_RATE = 3000;
    @Property(name="probeRate", intValue={3000}, label="LLDP and BDDP probe rate specified in millis")
    private int probeRate = 3000;
    private static final String PROP_STALE_LINK_AGE = "staleLinkAge";
    private static final int DEFAULT_STALE_LINK_AGE = 10000;
    @Property(name="staleLinkAge", intValue={10000}, label="Number of millis beyond which links will be considered stale")
    private int staleLinkAge = 10000;
    private final LinkDiscoveryContext context = new InternalDiscoveryContext();
    private final InternalRoleListener roleListener = new InternalRoleListener();
    private final InternalDeviceListener deviceListener = new InternalDeviceListener();
    private final InternalPacketProcessor packetProcessor = new InternalPacketProcessor();
    protected final Map<DeviceId, LinkDiscovery> discoverers = new ConcurrentHashMap<DeviceId, LinkDiscovery>();
    private final Map<LinkKey, Long> linkTimes = Maps.newConcurrentMap();
    private ApplicationId appId;
    static final SuppressionRules DEFAULT_RULES = new SuppressionRules(EnumSet.of(Device.Type.ROADM, Device.Type.FIBER_SWITCH, Device.Type.OPTICAL_AMPLIFIER, Device.Type.OTN), (Map<String, String>)ImmutableMap.of((Object)"no-lldp", (Object)"(any)"));
    private SuppressionRules rules = DEFAULT_RULES;
    public static final String CONFIG_KEY = "suppression";
    public static final String FEATURE_NAME = "linkDiscovery";
    private final Set<ConfigFactory<?, ?>> factories = ImmutableSet.of((Object)new ConfigFactory<ApplicationId, SuppressionConfig>(SubjectFactories.APP_SUBJECT_FACTORY, SuppressionConfig.class, "suppression"){

        public SuppressionConfig createConfig() {
            return new SuppressionConfig();
        }
    }, (Object)new ConfigFactory<DeviceId, LinkDiscoveryFromDevice>(SubjectFactories.DEVICE_SUBJECT_FACTORY, LinkDiscoveryFromDevice.class, "linkDiscovery"){

        public LinkDiscoveryFromDevice createConfig() {
            return new LinkDiscoveryFromDevice();
        }
    }, (Object)new ConfigFactory<ConnectPoint, LinkDiscoveryFromPort>(SubjectFactories.CONNECT_POINT_SUBJECT_FACTORY, LinkDiscoveryFromPort.class, "linkDiscovery"){

        public LinkDiscoveryFromPort createConfig() {
            return new LinkDiscoveryFromPort();
        }
    });
    private final InternalConfigListener cfgListener = new InternalConfigListener();
    static final EnumSet<NetworkConfigEvent.Type> CONFIG_CHANGED = EnumSet.of(NetworkConfigEvent.Type.CONFIG_ADDED, NetworkConfigEvent.Type.CONFIG_UPDATED, NetworkConfigEvent.Type.CONFIG_REMOVED);

    public LldpLinkProvider() {
        super(new ProviderId("lldp", PROVIDER_NAME));
    }

    private String buildSrcMac() {
        String defMac;
        String srcMac = ProbedLinkProvider.fingerprintMac((ClusterMetadata)this.clusterMetadataService.getClusterMetadata());
        if (srcMac.equals(defMac = ProbedLinkProvider.defaultMac())) {
            this.log.warn("Couldn't generate fingerprint. Using default value {}", (Object)defMac);
            return defMac;
        }
        this.log.trace("Generated MAC address {}", (Object)srcMac);
        return srcMac;
    }

    @Activate
    public void activate(ComponentContext context) {
        this.eventExecutor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/linkevents", (String)"events-%d", (Logger)this.log));
        this.shuttingDown = false;
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.appId = this.coreService.registerApplication(PROVIDER_NAME);
        this.cfgRegistry.addListener((EventListener)this.cfgListener);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgRegistry).registerConfigFactory(arg_0));
        SuppressionConfig cfg = (SuppressionConfig)this.cfgRegistry.getConfig((Object)this.appId, SuppressionConfig.class);
        if (cfg == null) {
            cfg = this.setDefaultSuppressionConfig();
        }
        this.cfgListener.reconfigureSuppressionRules(cfg);
        this.modified(context);
        this.log.info("Started");
    }

    private SuppressionConfig setDefaultSuppressionConfig() {
        SuppressionConfig cfg = (SuppressionConfig)this.cfgRegistry.addConfig((Object)this.appId, SuppressionConfig.class);
        cfg.deviceTypes(DEFAULT_RULES.getSuppressedDeviceType()).annotation(DEFAULT_RULES.getSuppressedAnnotation()).apply();
        return cfg;
    }

    @Deactivate
    public void deactivate() {
        this.shuttingDown = true;
        this.cfgRegistry.removeListener((EventListener)this.cfgListener);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgRegistry).unregisterConfigFactory(arg_0));
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.disable();
        this.eventExecutor.shutdownNow();
        this.eventExecutor = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        int newStaleLinkAge;
        int newProbeRate;
        boolean newUseBddp;
        boolean newEnabled;
        Dictionary properties = context != null ? context.getProperties() : new Properties();
        try {
            String s = Tools.get((Dictionary)properties, (String)PROP_ENABLED);
            newEnabled = Strings.isNullOrEmpty((String)s) || Boolean.parseBoolean(s.trim());
            s = Tools.get((Dictionary)properties, (String)PROP_USE_BDDP);
            newUseBddp = Strings.isNullOrEmpty((String)s) || Boolean.parseBoolean(s.trim());
            s = Tools.get((Dictionary)properties, (String)PROP_PROBE_RATE);
            newProbeRate = Strings.isNullOrEmpty((String)s) ? this.probeRate : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)PROP_STALE_LINK_AGE);
            newStaleLinkAge = Strings.isNullOrEmpty((String)s) ? this.staleLinkAge : Integer.parseInt(s.trim());
        }
        catch (NumberFormatException e) {
            this.log.warn("Component configuration had invalid values", (Throwable)e);
            newEnabled = this.enabled;
            newUseBddp = this.useBddp;
            newProbeRate = this.probeRate;
            newStaleLinkAge = this.staleLinkAge;
        }
        boolean wasEnabled = this.enabled;
        this.enabled = newEnabled;
        this.useBddp = newUseBddp;
        this.probeRate = newProbeRate;
        this.staleLinkAge = newStaleLinkAge;
        if (!wasEnabled && this.enabled) {
            this.enable();
        } else if (wasEnabled && !this.enabled) {
            this.disable();
        } else if (this.enabled) {
            this.loadDevices();
        }
        this.log.info(FORMAT, new Object[]{this.enabled, this.useBddp, this.probeRate, this.staleLinkAge});
    }

    private void enable() {
        this.providerService = (LinkProviderService)this.providerRegistry.register((Provider)this);
        this.masterService.addListener((EventListener)this.roleListener);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.packetService.addProcessor((PacketProcessor)this.packetProcessor, PacketProcessor.advisor((int)0));
        this.loadDevices();
        this.executor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/link", (String)"discovery-%d", (Logger)this.log));
        this.executor.scheduleAtFixedRate(new SyncDeviceInfoTask(), 5L, 5L, TimeUnit.SECONDS);
        this.executor.scheduleAtFixedRate(new LinkPrunerTask(), 3L, 3L, TimeUnit.SECONDS);
        this.requestIntercepts();
    }

    private void disable() {
        this.withdrawIntercepts();
        this.providerRegistry.unregister((Provider)this);
        this.masterService.removeListener((EventListener)this.roleListener);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.packetService.removeProcessor((PacketProcessor)this.packetProcessor);
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.discoverers.values().forEach(LinkDiscovery::stop);
        this.discoverers.clear();
        this.providerService = null;
    }

    private void loadDevices() {
        if (!this.enabled || this.deviceService == null) {
            return;
        }
        this.deviceService.getAvailableDevices().forEach(d -> this.updateDevice((Device)d).ifPresent(ld -> this.updatePorts((LinkDiscovery)ld, d.id())));
    }

    private boolean isBlacklisted(DeviceId did) {
        LinkDiscoveryFromDevice cfg = (LinkDiscoveryFromDevice)this.cfgRegistry.getConfig((Object)did, LinkDiscoveryFromDevice.class);
        if (cfg == null) {
            return false;
        }
        return !cfg.enabled();
    }

    private boolean isBlacklisted(ConnectPoint cp) {
        if (this.isBlacklisted(cp.deviceId())) {
            return true;
        }
        LinkDiscoveryFromPort cfg = (LinkDiscoveryFromPort)this.cfgRegistry.getConfig((Object)cp, LinkDiscoveryFromPort.class);
        if (cfg == null) {
            return false;
        }
        return !cfg.enabled();
    }

    private boolean isBlacklisted(Port port) {
        return this.isBlacklisted(new ConnectPoint(port.element().id(), port.number()));
    }

    private Optional<LinkDiscovery> updateDevice(Device device) {
        if (device == null) {
            return Optional.empty();
        }
        if (this.rules.isSuppressed(device) || this.isBlacklisted(device.id())) {
            this.log.trace("LinkDiscovery from {} disabled by configuration", (Object)device.id());
            this.removeDevice(device.id());
            return Optional.empty();
        }
        LinkDiscovery ld = this.discoverers.computeIfAbsent(device.id(), did -> new LinkDiscovery(device, this.context));
        if (ld.isStopped()) {
            ld.start();
        }
        return Optional.of(ld);
    }

    private void removeDevice(DeviceId deviceId) {
        this.discoverers.computeIfPresent(deviceId, (did, ld) -> {
            ld.stop();
            return null;
        });
    }

    private void updatePorts(LinkDiscovery discoverer, DeviceId deviceId) {
        this.deviceService.getPorts(deviceId).forEach(p -> this.updatePort(discoverer, (Port)p));
    }

    private void updatePort(LinkDiscovery discoverer, Port port) {
        if (port == null) {
            return;
        }
        if (port.number().isLogical()) {
            return;
        }
        if (this.rules.isSuppressed(port) || this.isBlacklisted(port)) {
            this.log.trace("LinkDiscovery from {} disabled by configuration", (Object)port);
            this.removePort(port);
            return;
        }
        if (!port.isEnabled()) {
            this.removePort(port);
            return;
        }
        discoverer.addPort(port);
    }

    private void removePort(Port port) {
        if (port.element() instanceof Device) {
            Device d = (Device)port.element();
            LinkDiscovery ld = this.discoverers.get(d.id());
            if (ld != null) {
                ld.removePort(port.number());
            }
        } else {
            this.log.warn("Attempted to remove non-Device port", (Object)port);
        }
    }

    private void requestIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_LLDP);
        this.packetService.requestPackets(selector.build(), PacketPriority.CONTROL, this.appId);
        selector.matchEthType(Ethernet.TYPE_BSN);
        if (this.useBddp) {
            this.packetService.requestPackets(selector.build(), PacketPriority.CONTROL, this.appId);
        } else {
            this.packetService.cancelPackets(selector.build(), PacketPriority.CONTROL, this.appId);
        }
    }

    private void withdrawIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_LLDP);
        this.packetService.cancelPackets(selector.build(), PacketPriority.CONTROL, this.appId);
        selector.matchEthType(Ethernet.TYPE_BSN);
        this.packetService.cancelPackets(selector.build(), PacketPriority.CONTROL, this.appId);
    }

    protected SuppressionRules rules() {
        return this.rules;
    }

    protected void updateRules(SuppressionRules newRules) {
        if (!this.rules.equals(newRules)) {
            this.rules = newRules;
            this.loadDevices();
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.providerRegistry = linkProviderRegistry;
    }

    protected void unbindProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.providerRegistry == linkProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindMasterService(MastershipService mastershipService) {
        this.masterService = mastershipService;
    }

    protected void unbindMasterService(MastershipService mastershipService) {
        if (this.masterService == mastershipService) {
            this.masterService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindCfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgRegistry = networkConfigRegistry;
    }

    protected void unbindCfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgRegistry == networkConfigRegistry) {
            this.cfgRegistry = null;
        }
    }

    protected void bindClusterMetadataService(ClusterMetadataService clusterMetadataService) {
        this.clusterMetadataService = clusterMetadataService;
    }

    protected void unbindClusterMetadataService(ClusterMetadataService clusterMetadataService) {
        if (this.clusterMetadataService == clusterMetadataService) {
            this.clusterMetadataService = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        private synchronized void reconfigureSuppressionRules(SuppressionConfig cfg) {
            if (cfg == null) {
                LldpLinkProvider.this.log.debug("Suppression Config is null.");
                return;
            }
            SuppressionRules newRules = new SuppressionRules(cfg.deviceTypes(), cfg.annotation());
            LldpLinkProvider.this.updateRules(newRules);
        }

        public void event(NetworkConfigEvent event) {
            LldpLinkProvider.this.eventExecutor.execute(() -> {
                if (event.configClass() == LinkDiscoveryFromDevice.class && CONFIG_CHANGED.contains(event.type())) {
                    if (event.subject() instanceof DeviceId) {
                        DeviceId did = (DeviceId)event.subject();
                        Device device = LldpLinkProvider.this.deviceService.getDevice(did);
                        LldpLinkProvider.this.updateDevice(device).ifPresent(ld -> LldpLinkProvider.this.updatePorts(ld, did));
                    }
                } else if (event.configClass() == LinkDiscoveryFromPort.class && CONFIG_CHANGED.contains(event.type())) {
                    ConnectPoint cp;
                    if (event.subject() instanceof ConnectPoint && (cp = (ConnectPoint)event.subject()).elementId() instanceof DeviceId) {
                        DeviceId did = (DeviceId)cp.elementId();
                        Device device = LldpLinkProvider.this.deviceService.getDevice(did);
                        Port port = LldpLinkProvider.this.deviceService.getPort(did, cp.port());
                        LldpLinkProvider.this.updateDevice(device).ifPresent(ld -> LldpLinkProvider.this.updatePort(ld, port));
                    }
                } else if (event.configClass().equals(SuppressionConfig.class) && (event.type() == NetworkConfigEvent.Type.CONFIG_ADDED || event.type() == NetworkConfigEvent.Type.CONFIG_UPDATED)) {
                    SuppressionConfig cfg = (SuppressionConfig)LldpLinkProvider.this.cfgRegistry.getConfig((Object)LldpLinkProvider.this.appId, SuppressionConfig.class);
                    this.reconfigureSuppressionRules(cfg);
                    LldpLinkProvider.this.log.trace("Network config reconfigured");
                }
            });
        }
    }

    private class InternalDiscoveryContext
    implements LinkDiscoveryContext {
        private InternalDiscoveryContext() {
        }

        public MastershipService mastershipService() {
            return LldpLinkProvider.this.masterService;
        }

        public LinkProviderService providerService() {
            return LldpLinkProvider.this.providerService;
        }

        public PacketService packetService() {
            return LldpLinkProvider.this.packetService;
        }

        public long probeRate() {
            return LldpLinkProvider.this.probeRate;
        }

        public boolean useBddp() {
            return LldpLinkProvider.this.useBddp;
        }

        public void touchLink(LinkKey key) {
            LldpLinkProvider.this.linkTimes.put(key, System.currentTimeMillis());
        }

        public DeviceService deviceService() {
            return LldpLinkProvider.this.deviceService;
        }

        public String fingerprint() {
            return LldpLinkProvider.this.buildSrcMac();
        }
    }

    private class LinkPrunerTask
    implements Runnable {
        private LinkPrunerTask() {
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                LldpLinkProvider.this.log.info("Interrupted, quitting");
                return;
            }
            try {
                Maps.filterEntries((Map)LldpLinkProvider.this.linkTimes, e -> {
                    if (!LldpLinkProvider.this.masterService.isLocalMaster(((LinkKey)e.getKey()).dst().deviceId())) {
                        return true;
                    }
                    if (this.isStale((Long)e.getValue())) {
                        LldpLinkProvider.this.providerService.linkVanished((LinkDescription)new DefaultLinkDescription(((LinkKey)e.getKey()).src(), ((LinkKey)e.getKey()).dst(), Link.Type.DIRECT, new SparseAnnotations[0]));
                        return true;
                    }
                    return false;
                }).clear();
            }
            catch (Exception e2) {
                if (!LldpLinkProvider.this.shuttingDown) {
                    LldpLinkProvider.this.log.error("Exception thrown during link pruning process", (Throwable)e2);
                }
                LldpLinkProvider.this.log.trace("Shutting down, ignoring error", (Throwable)e2);
            }
        }

        private boolean isStale(long lastSeen) {
            return lastSeen < System.currentTimeMillis() - (long)LldpLinkProvider.this.staleLinkAge;
        }
    }

    private final class SyncDeviceInfoTask
    implements Runnable {
        private SyncDeviceInfoTask() {
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                LldpLinkProvider.this.log.info("Interrupted, quitting");
                return;
            }
            try {
                LldpLinkProvider.this.loadDevices();
            }
            catch (Exception e) {
                LldpLinkProvider.this.log.error("Exception thrown during synchronization process", (Throwable)e);
            }
        }
    }

    private class InternalPacketProcessor
    implements PacketProcessor {
        private InternalPacketProcessor() {
        }

        public void process(PacketContext context) {
            if (context == null || context.isHandled()) {
                return;
            }
            Ethernet eth = context.inPacket().parsed();
            if (eth == null || eth.getEtherType() != Ethernet.TYPE_LLDP && eth.getEtherType() != Ethernet.TYPE_BSN) {
                return;
            }
            LinkDiscovery ld = LldpLinkProvider.this.discoverers.get(context.inPacket().receivedFrom().deviceId());
            if (ld == null) {
                return;
            }
            if (ld.handleLldp(context)) {
                context.block();
            }
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            if (event.type() == DeviceEvent.Type.PORT_STATS_UPDATED) {
                return;
            }
            DeviceEventProcessor deviceEventProcessor = new DeviceEventProcessor(event);
            LldpLinkProvider.this.eventExecutor.execute(deviceEventProcessor);
        }
    }

    private class DeviceEventProcessor
    implements Runnable {
        DeviceEvent event;

        DeviceEventProcessor(DeviceEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            Device device = (Device)this.event.subject();
            Port port = this.event.port();
            if (device == null) {
                LldpLinkProvider.this.log.error("Device is null.");
                return;
            }
            LldpLinkProvider.this.log.trace("{} {} {}", new Object[]{this.event.type(), this.event.subject(), this.event});
            DeviceId deviceId = device.id();
            switch ((DeviceEvent.Type)this.event.type()) {
                case DEVICE_ADDED: 
                case DEVICE_UPDATED: {
                    LldpLinkProvider.this.updateDevice(device).ifPresent(ld -> LldpLinkProvider.this.updatePorts(ld, deviceId));
                    break;
                }
                case PORT_ADDED: 
                case PORT_UPDATED: {
                    if (port.isEnabled()) {
                        LldpLinkProvider.this.updateDevice(device).ifPresent(ld -> LldpLinkProvider.this.updatePort(ld, port));
                        break;
                    }
                    LldpLinkProvider.this.log.debug("Port down {}", (Object)port);
                    LldpLinkProvider.this.removePort(port);
                    LldpLinkProvider.this.providerService.linksVanished(new ConnectPoint(port.element().id(), port.number()));
                    break;
                }
                case PORT_REMOVED: {
                    LldpLinkProvider.this.log.debug("Port removed {}", (Object)port);
                    LldpLinkProvider.this.removePort(port);
                    LldpLinkProvider.this.providerService.linksVanished(new ConnectPoint(port.element().id(), port.number()));
                    break;
                }
                case DEVICE_REMOVED: 
                case DEVICE_SUSPENDED: {
                    LldpLinkProvider.this.log.debug("Device removed {}", (Object)deviceId);
                    LldpLinkProvider.this.removeDevice(deviceId);
                    LldpLinkProvider.this.providerService.linksVanished(deviceId);
                    break;
                }
                case DEVICE_AVAILABILITY_CHANGED: {
                    if (LldpLinkProvider.this.deviceService.isAvailable(deviceId)) {
                        LldpLinkProvider.this.log.debug("Device up {}", (Object)deviceId);
                        LldpLinkProvider.this.updateDevice(device).ifPresent(ld -> LldpLinkProvider.this.updatePorts(ld, deviceId));
                        break;
                    }
                    LldpLinkProvider.this.log.debug("Device down {}", (Object)deviceId);
                    LldpLinkProvider.this.removeDevice(deviceId);
                    LldpLinkProvider.this.providerService.linksVanished(deviceId);
                    break;
                }
                case PORT_STATS_UPDATED: {
                    break;
                }
                default: {
                    LldpLinkProvider.this.log.debug("Unknown event {}", (Object)this.event);
                }
            }
        }
    }

    private class InternalRoleListener
    implements MastershipListener {
        private InternalRoleListener() {
        }

        public void event(MastershipEvent event) {
            if (MastershipEvent.Type.MASTER_CHANGED.equals((Object)event.type())) {
                LldpLinkProvider.this.eventExecutor.execute(() -> {
                    DeviceId deviceId = (DeviceId)event.subject();
                    Device device = LldpLinkProvider.this.deviceService.getDevice(deviceId);
                    if (device == null) {
                        LldpLinkProvider.this.log.debug("Device {} doesn't exist, or isn't there yet", (Object)deviceId);
                        return;
                    }
                    if (LldpLinkProvider.this.clusterService.getLocalNode().id().equals((Object)event.roleInfo().master())) {
                        LldpLinkProvider.this.updateDevice(device).ifPresent(ld -> LldpLinkProvider.this.updatePorts(ld, device.id()));
                    }
                });
            }
        }
    }
}

