/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.lldp.cli;

import java.util.Optional;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.cli.net.PortNumberCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.provider.lldp.impl.LinkDiscoveryFromDevice;
import org.onosproject.provider.lldp.impl.LinkDiscoveryFromPort;

@Command(scope="onos", name="config-link-discovery", description="Adds configuration to disable LLDP link discovery")
public class ConfigLinkDiscoveryCommand
extends AbstractShellCommand {
    DeviceIdCompleter deviceIdCompleter;
    @Argument(index=0, name="device", description="DeviceID", required=true)
    String device = null;
    PortNumberCompleter portNumberCompleter;
    @Argument(index=1, name="port", description="Port number", required=false)
    String port = null;
    @Option(name="--remove", aliases={"-r"}, description="remove configuration", required=false)
    boolean remove = false;
    @Option(name="--enable", description="add configuration to enable LinkDiscovery", required=false)
    boolean enable = false;

    protected void execute() {
        DeviceService deviceService = (DeviceService)ConfigLinkDiscoveryCommand.get(DeviceService.class);
        NetworkConfigService netcfgService = (NetworkConfigService)ConfigLinkDiscoveryCommand.get(NetworkConfigService.class);
        DeviceId did = DeviceId.deviceId((String)this.device);
        ConnectPoint cp = Optional.ofNullable(this.port).map(PortNumber::fromString).map(pn -> new ConnectPoint((ElementId)did, pn)).orElse(null);
        if (cp == null) {
            if (!this.remove) {
                if (deviceService.getDevice(did) == null) {
                    this.print("[WARN] configuring about unknown device %s", new Object[]{did});
                }
                LinkDiscoveryFromDevice cfg = (LinkDiscoveryFromDevice)netcfgService.addConfig((Object)did, LinkDiscoveryFromDevice.class);
                cfg.enabled(this.enable);
                cfg.apply();
            } else {
                netcfgService.removeConfig((Object)did, LinkDiscoveryFromDevice.class);
            }
        } else if (!this.remove) {
            if (deviceService.getPort(cp) == null) {
                this.print("[WARN] configuring about unknown port %s", new Object[]{cp});
            }
            LinkDiscoveryFromPort cfg = (LinkDiscoveryFromPort)netcfgService.addConfig((Object)cp, LinkDiscoveryFromPort.class);
            cfg.enabled(this.enable);
            cfg.apply();
        } else {
            netcfgService.removeConfig((Object)cp, LinkDiscoveryFromPort.class);
        }
    }
}

