/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.segmentrouting.DefaultTunnel;
import org.onosproject.segmentrouting.SegmentRoutingService;
import org.onosproject.segmentrouting.Tunnel;
import org.onosproject.segmentrouting.web.TunnelCodec;

@Path(value="tunnel")
public class TunnelWebResource
extends AbstractWebResource {
    private static final TunnelCodec TUNNEL_CODEC = new TunnelCodec();

    @GET
    @Produces(value={"application/json"})
    public Response getTunnel() {
        SegmentRoutingService srService = (SegmentRoutingService)this.get(SegmentRoutingService.class);
        List<Tunnel> tunnels = srService.getTunnels();
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("tunnel", (JsonNode)new TunnelCodec().encode(tunnels, (CodecContext)this));
        return TunnelWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createTunnel(InputStream input) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode tunnelJson = (ObjectNode)mapper.readTree(input);
        SegmentRoutingService srService = (SegmentRoutingService)this.get(SegmentRoutingService.class);
        DefaultTunnel tunnelInfo = TUNNEL_CODEC.decode(tunnelJson, (CodecContext)this);
        srService.createTunnel(tunnelInfo);
        return Response.ok().build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public Response removeTunnel(InputStream input) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode tunnelJson = (ObjectNode)mapper.readTree(input);
        SegmentRoutingService srService = (SegmentRoutingService)this.get(SegmentRoutingService.class);
        DefaultTunnel tunnelInfo = TUNNEL_CODEC.decode(tunnelJson, (CodecContext)this);
        srService.removeTunnel(tunnelInfo);
        return Response.noContent().build();
    }
}

