/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.segmentrouting.DefaultTunnel;
import org.onosproject.segmentrouting.Tunnel;

public final class TunnelCodec
extends JsonCodec<Tunnel> {
    private static final String TUNNEL_ID = "tunnel_id";
    private static final String GROUP_ID = "group_id";
    private static final String LABEL_PATH = "label_path";

    public ObjectNode encode(Tunnel tunnel, CodecContext context) {
        ObjectNode result = context.mapper().createObjectNode().put(TUNNEL_ID, tunnel.id());
        result.put(GROUP_ID, tunnel.groupId());
        ArrayNode jsonLabelIds = result.putArray(LABEL_PATH);
        tunnel.labelIds().forEach(label -> jsonLabelIds.add(label.intValue()));
        return result;
    }

    public DefaultTunnel decode(ObjectNode json, CodecContext context) {
        String tid = json.path(TUNNEL_ID).asText();
        ArrayList<Integer> labels = new ArrayList<Integer>();
        if (!json.path(LABEL_PATH).isMissingNode()) {
            ArrayNode labelArray = (ArrayNode)json.path(LABEL_PATH);
            for (JsonNode o : labelArray) {
                labels.add(o.asInt());
            }
        }
        return new DefaultTunnel(tid, labels);
    }
}

