/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.segmentrouting.Policy;
import org.onosproject.segmentrouting.SegmentRoutingService;
import org.onosproject.segmentrouting.web.PolicyCodec;

@Path(value="policy")
public class PolicyWebResource
extends AbstractWebResource {
    private static final PolicyCodec POLICY_CODEC = new PolicyCodec();

    @GET
    @Produces(value={"application/json"})
    public Response getPolicy() {
        SegmentRoutingService srService = (SegmentRoutingService)this.get(SegmentRoutingService.class);
        List<Policy> policies = srService.getPolicies();
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("policy", (JsonNode)new PolicyCodec().encode(policies, (CodecContext)this));
        return PolicyWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createPolicy(InputStream input) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode policyJson = (ObjectNode)mapper.readTree(input);
        SegmentRoutingService srService = (SegmentRoutingService)this.get(SegmentRoutingService.class);
        Policy policyInfo = POLICY_CODEC.decode(policyJson, (CodecContext)this);
        if (policyInfo.type() == Policy.Type.TUNNEL_FLOW) {
            srService.createPolicy(policyInfo);
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public Response removePolicy(InputStream input) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode policyJson = (ObjectNode)mapper.readTree(input);
        SegmentRoutingService srService = (SegmentRoutingService)this.get(SegmentRoutingService.class);
        Policy policyInfo = POLICY_CODEC.decode(policyJson, (CodecContext)this);
        srService.removePolicy(policyInfo);
        return Response.noContent().build();
    }
}

