/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.web;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.segmentrouting.Policy;
import org.onosproject.segmentrouting.TunnelPolicy;

public final class PolicyCodec
extends JsonCodec<Policy> {
    private static final String POLICY_ID = "policy_id";
    private static final String PRIORITY = "priority";
    private static final String TYPE = "policy_type";
    private static final String TUNNEL_ID = "tunnel_id";
    private static final String DST_IP = "dst_ip";
    private static final String SRC_IP = "src_ip";
    private static final String PROTO_TYPE = "proto_type";
    private static final String SRC_PORT = "src_tp_port";
    private static final String DST_PORT = "dst_tp_port";

    public ObjectNode encode(Policy policy, CodecContext context) {
        ObjectNode result = context.mapper().createObjectNode().put(POLICY_ID, policy.id());
        result.put(PRIORITY, policy.priority());
        result.put(TYPE, policy.type().toString());
        if (policy.dstIp() != null) {
            result.put(DST_IP, policy.dstIp());
        }
        if (policy.srcIp() != null) {
            result.put(SRC_IP, policy.srcIp());
        }
        if (policy.ipProto() != null) {
            result.put(PROTO_TYPE, policy.ipProto());
        }
        int srcPort = policy.srcPort() & 0xFFFF;
        if (policy.srcPort() != 0) {
            result.put(SRC_PORT, srcPort);
        }
        int dstPort = policy.dstPort() & 0xFFFF;
        if (policy.dstPort() != 0) {
            result.put(DST_PORT, dstPort);
        }
        if (policy.type() == Policy.Type.TUNNEL_FLOW) {
            result.put(TUNNEL_ID, ((TunnelPolicy)policy).tunnelId());
        }
        return result;
    }

    public Policy decode(ObjectNode json, CodecContext context) {
        String pid = json.path(POLICY_ID).asText();
        String type = json.path(TYPE).asText();
        int priority = json.path(PRIORITY).asInt();
        String dstIp = json.path(DST_IP).asText();
        String srcIp = json.path(SRC_IP).asText();
        String tunnelId = json.path(TUNNEL_ID).asText();
        String protoType = json.path(PROTO_TYPE).asText();
        short srcPort = json.path(SRC_PORT).shortValue();
        short dstPort = json.path(DST_PORT).shortValue();
        if (json.path(POLICY_ID).isMissingNode() || pid == null) {
            return null;
        }
        TunnelPolicy.Builder tpb = TunnelPolicy.builder().setPolicyId(pid);
        if (!json.path(TYPE).isMissingNode() && type != null && Policy.Type.valueOf(type).equals((Object)Policy.Type.TUNNEL_FLOW)) {
            if (json.path(TUNNEL_ID).isMissingNode() || tunnelId == null) {
                return null;
            }
            tpb.setTunnelId(tunnelId);
            tpb.setType(Policy.Type.valueOf(type));
            if (!json.path(PRIORITY).isMissingNode()) {
                tpb.setPriority(priority);
            }
            if (dstIp != null) {
                tpb.setDstIp(dstIp);
            }
            if (srcIp != null) {
                tpb.setSrcIp(srcIp);
            }
            if (protoType != null) {
                tpb.setIpProto(protoType);
            }
            if (dstPort != 0) {
                tpb.setDstPort(dstPort);
            }
            if (srcPort != 0) {
                tpb.setSrcPort(srcPort);
            }
        }
        return tpb.build();
    }
}

