/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.storekey;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;

public class McastStoreKey {
    private final IpAddress mcastIp;
    private final DeviceId deviceId;

    public McastStoreKey(IpAddress mcastIp, DeviceId deviceId) {
        Preconditions.checkNotNull((Object)mcastIp, (Object)"mcastIp cannot be null");
        Preconditions.checkNotNull((Object)deviceId, (Object)"deviceId cannot be null");
        Preconditions.checkArgument((boolean)mcastIp.isMulticast(), (Object)"mcastIp must be a multicast address");
        this.mcastIp = mcastIp;
        this.deviceId = deviceId;
    }

    public IpAddress mcastIp() {
        return this.mcastIp;
    }

    public DeviceId deviceId() {
        return this.deviceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof McastStoreKey)) {
            return false;
        }
        McastStoreKey that = (McastStoreKey)o;
        return Objects.equals(this.mcastIp, that.mcastIp) && Objects.equals(this.deviceId, that.deviceId);
    }

    public int hashCode() {
        return Objects.hash(this.mcastIp, this.deviceId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("mcastIp", (Object)this.mcastIp).add("deviceId", (Object)this.deviceId).toString();
    }
}

