/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.pwaas;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.DefaultObjectiveContext;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.PwaasConfig;
import org.onosproject.segmentrouting.pwaas.DefaultL2Tunnel;
import org.onosproject.segmentrouting.pwaas.DefaultL2TunnelDescription;
import org.onosproject.segmentrouting.pwaas.DefaultL2TunnelPolicy;
import org.onosproject.segmentrouting.pwaas.L2Mode;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2TunnelHandler {
    private static final Logger log = LoggerFactory.getLogger(L2TunnelHandler.class);
    private static final String WRONG_TOPOLOGY = "Path in leaf-spine topology should always be two hops: ";
    private final SegmentRoutingManager srManager;
    private final ConsistentMap<String, NextObjective> l2InitiationNextObjStore;
    private final ConsistentMap<String, NextObjective> l2TerminationNextObjStore;
    private final KryoNamespace.Builder l2TunnelKryo;

    public L2TunnelHandler(SegmentRoutingManager segmentRoutingManager) {
        this.srManager = segmentRoutingManager;
        this.l2TunnelKryo = new KryoNamespace.Builder().register(KryoNamespaces.API);
        this.l2InitiationNextObjStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.srManager.storageService.consistentMapBuilder().withName("onos-l2initiation-nextobj-store")).withSerializer(Serializer.using((KryoNamespace)this.l2TunnelKryo.build()))).build();
        this.l2TerminationNextObjStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.srManager.storageService.consistentMapBuilder().withName("onos-l2termination-nextobj-store")).withSerializer(Serializer.using((KryoNamespace)this.l2TunnelKryo.build()))).build();
    }

    public void processPwaasConfigAdded(NetworkConfigEvent event) {
        log.info("Processing Pwaas CONFIG_ADDED");
        PwaasConfig config = (PwaasConfig)((Object)event.config().get());
        Set<DefaultL2TunnelDescription> pwToAdd = config.getPwIds().stream().map(config::getPwDescription).collect(Collectors.toSet());
        this.deploy(pwToAdd);
    }

    private void deploy(Set<DefaultL2TunnelDescription> pwToAdd) {
        for (DefaultL2TunnelDescription currentL2Tunnel : pwToAdd) {
            long l2TunnelId = currentL2Tunnel.l2Tunnel().tunnelId();
            if (l2TunnelId == 0L) {
                log.warn("Tunnel id id must be > 0");
                continue;
            }
            Result result = this.verifyPseudoWire(currentL2Tunnel);
            if (result != Result.SUCCESS || (result = this.deployPseudoWireInit(currentL2Tunnel.l2Tunnel(), currentL2Tunnel.l2TunnelPolicy().cP1(), currentL2Tunnel.l2TunnelPolicy().cP2(), Direction.FWD)) != Result.SUCCESS || (result = this.deployPolicy(l2TunnelId, currentL2Tunnel.l2TunnelPolicy().cP1(), currentL2Tunnel.l2TunnelPolicy().cP1InnerTag(), currentL2Tunnel.l2TunnelPolicy().cP1OuterTag(), result.nextId)) != Result.SUCCESS || (result = this.deployPseudoWireTerm(currentL2Tunnel.l2Tunnel(), currentL2Tunnel.l2TunnelPolicy().cP2(), currentL2Tunnel.l2TunnelPolicy().cP2OuterTag(), Direction.FWD)) != Result.SUCCESS || (result = this.deployPseudoWireInit(currentL2Tunnel.l2Tunnel(), currentL2Tunnel.l2TunnelPolicy().cP2(), currentL2Tunnel.l2TunnelPolicy().cP1(), Direction.REV)) != Result.SUCCESS || (result = this.deployPolicy(l2TunnelId, currentL2Tunnel.l2TunnelPolicy().cP2(), currentL2Tunnel.l2TunnelPolicy().cP2InnerTag(), currentL2Tunnel.l2TunnelPolicy().cP2OuterTag(), result.nextId)) != Result.SUCCESS) continue;
            this.deployPseudoWireTerm(currentL2Tunnel.l2Tunnel(), currentL2Tunnel.l2TunnelPolicy().cP1(), currentL2Tunnel.l2TunnelPolicy().cP1OuterTag(), Direction.REV);
        }
    }

    public void processPwaasConfigUpdated(NetworkConfigEvent event) {
        log.info("Processing Pwaas CONFIG_UPDATED");
        PwaasConfig prevConfig = (PwaasConfig)((Object)event.prevConfig().get());
        Set<Long> prevPws = prevConfig.getPwIds();
        PwaasConfig config = (PwaasConfig)((Object)event.config().get());
        Set<Long> newPws = config.getPwIds();
        Set<Long> updPws = newPws.stream().filter(tunnelId -> prevPws.contains(tunnelId) && !config.getPwDescription((Long)tunnelId).equals(prevConfig.getPwDescription((Long)tunnelId))).collect(Collectors.toSet());
        Set<DefaultL2TunnelDescription> pwToRemove = prevPws.stream().filter(tunnelId -> !newPws.contains(tunnelId)).map(prevConfig::getPwDescription).collect(Collectors.toSet());
        this.tearDown(pwToRemove);
        Set<DefaultL2TunnelDescription> pwToAdd = newPws.stream().filter(tunnelId -> !prevPws.contains(tunnelId)).map(config::getPwDescription).collect(Collectors.toSet());
        this.deploy(pwToAdd);
        updPws.forEach(tunnelId -> this.updatePw(prevConfig.getPwDescription((Long)tunnelId), config.getPwDescription((Long)tunnelId)));
    }

    private void updatePw(DefaultL2TunnelDescription oldPw, DefaultL2TunnelDescription newPw) {
        long tunnelId = oldPw.l2Tunnel().tunnelId();
        CompletableFuture<ObjectiveError> fwdInitNextFuture = new CompletableFuture<ObjectiveError>();
        CompletableFuture<ObjectiveError> revInitNextFuture = new CompletableFuture<ObjectiveError>();
        CompletableFuture fwdTermNextFuture = new CompletableFuture();
        CompletableFuture revTermNextFuture = new CompletableFuture();
        CompletableFuture fwdPwFuture = new CompletableFuture();
        CompletableFuture revPwFuture = new CompletableFuture();
        Result result = this.verifyPseudoWire(newPw);
        if (result != Result.SUCCESS) {
            return;
        }
        log.debug("Start deleting fwd policy for {}", (Object)tunnelId);
        this.deletePolicy(tunnelId, oldPw.l2TunnelPolicy().cP1(), oldPw.l2TunnelPolicy().cP1InnerTag(), oldPw.l2TunnelPolicy().cP1OuterTag(), fwdInitNextFuture, Direction.FWD);
        log.debug("Start deleting rev policy for {}", (Object)tunnelId);
        this.deletePolicy(tunnelId, oldPw.l2TunnelPolicy().cP2(), oldPw.l2TunnelPolicy().cP2InnerTag(), oldPw.l2TunnelPolicy().cP2OuterTag(), revInitNextFuture, Direction.REV);
        fwdInitNextFuture.thenAcceptAsync(status -> {
            if (status == null) {
                log.debug("Fwd policy removed. Now remove fwd {} for {}", (Object)Pipeline.INITIATION, (Object)tunnelId);
                this.tearDownPseudoWireInit(tunnelId, oldPw.l2TunnelPolicy().cP1(), fwdTermNextFuture, Direction.FWD);
            }
        });
        revInitNextFuture.thenAcceptAsync(status -> {
            if (status == null) {
                log.debug("Rev policy removed. Now remove rev {} for {}", (Object)Pipeline.INITIATION, (Object)tunnelId);
                this.tearDownPseudoWireInit(tunnelId, oldPw.l2TunnelPolicy().cP2(), revTermNextFuture, Direction.REV);
            }
        });
        fwdTermNextFuture.thenAcceptAsync(status -> {
            if (status == null) {
                log.debug("Fwd {} removed. Now remove fwd {} for {}", new Object[]{Pipeline.INITIATION, Pipeline.TERMINATION, tunnelId});
                this.tearDownPseudoWireTerm(oldPw.l2Tunnel(), oldPw.l2TunnelPolicy().cP2(), fwdPwFuture, Direction.FWD);
            }
        });
        revTermNextFuture.thenAcceptAsync(status -> {
            if (status == null) {
                log.debug("Rev {} removed. Now remove rev {} for {}", new Object[]{Pipeline.INITIATION, Pipeline.TERMINATION, tunnelId});
                this.tearDownPseudoWireTerm(oldPw.l2Tunnel(), oldPw.l2TunnelPolicy().cP1(), revPwFuture, Direction.REV);
            }
        });
        fwdPwFuture.thenAcceptAsync(status -> {
            if (status == null) {
                log.debug("Deploying new fwd pw for {}", (Object)tunnelId);
                Result lamdaResult = this.deployPseudoWireInit(newPw.l2Tunnel(), newPw.l2TunnelPolicy().cP1(), newPw.l2TunnelPolicy().cP2(), Direction.FWD);
                if (lamdaResult != Result.SUCCESS) {
                    return;
                }
                lamdaResult = this.deployPolicy(tunnelId, newPw.l2TunnelPolicy().cP1(), newPw.l2TunnelPolicy().cP1InnerTag(), newPw.l2TunnelPolicy().cP1OuterTag(), lamdaResult.nextId);
                if (lamdaResult != Result.SUCCESS) {
                    return;
                }
                this.deployPseudoWireTerm(newPw.l2Tunnel(), newPw.l2TunnelPolicy().cP2(), newPw.l2TunnelPolicy().cP2OuterTag(), Direction.FWD);
            }
        });
        revPwFuture.thenAcceptAsync(status -> {
            if (status == null) {
                log.debug("Deploying new rev pw for {}", (Object)tunnelId);
                Result lamdaResult = this.deployPseudoWireInit(newPw.l2Tunnel(), newPw.l2TunnelPolicy().cP2(), newPw.l2TunnelPolicy().cP1(), Direction.REV);
                if (lamdaResult != Result.SUCCESS) {
                    return;
                }
                lamdaResult = this.deployPolicy(tunnelId, newPw.l2TunnelPolicy().cP2(), newPw.l2TunnelPolicy().cP2InnerTag(), newPw.l2TunnelPolicy().cP2OuterTag(), lamdaResult.nextId);
                if (lamdaResult != Result.SUCCESS) {
                    return;
                }
                this.deployPseudoWireTerm(newPw.l2Tunnel(), newPw.l2TunnelPolicy().cP1(), newPw.l2TunnelPolicy().cP1OuterTag(), Direction.REV);
            }
        });
    }

    public void processPwaasConfigRemoved(NetworkConfigEvent event) {
        log.info("Processing Pwaas CONFIG_REMOVED");
        PwaasConfig config = (PwaasConfig)((Object)event.prevConfig().get());
        Set<DefaultL2TunnelDescription> pwToRemove = config.getPwIds().stream().map(config::getPwDescription).collect(Collectors.toSet());
        this.tearDown(pwToRemove);
    }

    private void tearDown(Set<DefaultL2TunnelDescription> pwToRemove) {
        for (DefaultL2TunnelDescription currentL2Tunnel : pwToRemove) {
            long l2TunnelId = currentL2Tunnel.l2Tunnel().tunnelId();
            if (l2TunnelId == 0L) {
                log.warn("Tunnel id cannot be 0");
                continue;
            }
            Result result = this.verifyPseudoWire(currentL2Tunnel);
            if (result != Result.SUCCESS) continue;
            this.deletePolicy(l2TunnelId, currentL2Tunnel.l2TunnelPolicy().cP1(), currentL2Tunnel.l2TunnelPolicy().cP1InnerTag(), currentL2Tunnel.l2TunnelPolicy().cP1OuterTag(), null, Direction.FWD);
            this.tearDownPseudoWireInit(l2TunnelId, currentL2Tunnel.l2TunnelPolicy().cP1(), null, Direction.FWD);
            this.tearDownPseudoWireTerm(currentL2Tunnel.l2Tunnel(), currentL2Tunnel.l2TunnelPolicy().cP2(), null, Direction.FWD);
            this.deletePolicy(l2TunnelId, currentL2Tunnel.l2TunnelPolicy().cP2(), currentL2Tunnel.l2TunnelPolicy().cP2InnerTag(), currentL2Tunnel.l2TunnelPolicy().cP2OuterTag(), null, Direction.REV);
            this.tearDownPseudoWireInit(l2TunnelId, currentL2Tunnel.l2TunnelPolicy().cP2(), null, Direction.REV);
            this.tearDownPseudoWireTerm(currentL2Tunnel.l2Tunnel(), currentL2Tunnel.l2TunnelPolicy().cP1(), null, Direction.REV);
        }
    }

    private Result verifyPseudoWire(DefaultL2TunnelDescription l2TunnelDescription) {
        DefaultL2Tunnel l2Tunnel = l2TunnelDescription.l2Tunnel();
        DefaultL2TunnelPolicy l2TunnelPolicy = l2TunnelDescription.l2TunnelPolicy();
        Result result = this.verifyTunnel(l2Tunnel);
        if (result != Result.SUCCESS) {
            log.warn("Tunnel {}: did not pass the validation", (Object)l2Tunnel.tunnelId());
            return result;
        }
        result = this.verifyPolicy(l2TunnelPolicy.isAllVlan(), l2TunnelPolicy.cP1InnerTag(), l2TunnelPolicy.cP1OuterTag(), l2TunnelPolicy.cP2InnerTag(), l2TunnelPolicy.cP2OuterTag());
        if (result != Result.SUCCESS) {
            log.warn("Policy for tunnel {}: did not pass the validation", (Object)l2Tunnel.tunnelId());
            return result;
        }
        return Result.SUCCESS;
    }

    private Result deployPolicy(long tunnelId, ConnectPoint ingress, VlanId ingressInner, VlanId ingressOuter, int nextId) {
        if (!this.srManager.mastershipService.isLocalMaster(ingress.deviceId())) {
            log.info("Abort creation of policy for tunnel {}: I am not the master", (Object)tunnelId);
            return Result.SUCCESS;
        }
        ArrayList objectives = Lists.newArrayList();
        ForwardingObjective.Builder fwdBuilder = this.createInitFwdObjective(tunnelId, ingress.port(), nextId);
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("FwdObj for tunnel {} populated", (Object)tunnelId), (objective, error) -> log.warn("Failed to populate fwdrObj for tunnel {}", (Object)tunnelId, error));
        objectives.add(fwdBuilder.add((ObjectiveContext)context));
        FilteringObjective.Builder filtBuilder = this.createFiltObjective(ingress.port(), ingressInner, ingressOuter);
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().setTunnelId(tunnelId);
        filtBuilder.withMeta(treatment.build());
        context = new DefaultObjectiveContext(objective -> log.debug("FilterObj for tunnel {} populated", (Object)tunnelId), (objective, error) -> log.warn("Failed to populate filterObj for tunnel {}", (Object)tunnelId, error));
        objectives.add(filtBuilder.add((ObjectiveContext)context));
        for (Objective objective2 : objectives) {
            if (objective2 instanceof ForwardingObjective) {
                this.srManager.flowObjectiveService.forward(ingress.deviceId(), (ForwardingObjective)objective2);
                log.debug("Creating new FwdObj for initiation NextObj with id={} for tunnel {}", (Object)nextId, (Object)tunnelId);
                continue;
            }
            this.srManager.flowObjectiveService.filter(ingress.deviceId(), (FilteringObjective)objective2);
            log.debug("Creating new FiltObj for tunnel {}", (Object)tunnelId);
        }
        return Result.SUCCESS;
    }

    private Result verifyPolicy(boolean isAllVlan, VlanId ingressInner, VlanId ingressOuter, VlanId egressInner, VlanId egressOuter) {
        if (isAllVlan) {
            log.warn("AllVlan not supported yet");
            return Result.UNSUPPORTED;
        }
        if (ingressInner.equals((Object)VlanId.NONE) || ingressOuter.equals((Object)VlanId.NONE) || egressInner.equals((Object)VlanId.NONE) || egressOuter.equals((Object)VlanId.NONE)) {
            log.warn("The vlan tags for the connect point have to bedifferent from vlan none");
            return Result.WRONG_PARAMETERS;
        }
        return Result.SUCCESS;
    }

    private Result deployPseudoWireInit(DefaultL2Tunnel l2Tunnel, ConnectPoint ingress, ConnectPoint egress, Direction direction) {
        if (!this.srManager.mastershipService.isLocalMaster(ingress.deviceId())) {
            log.info("Abort initiation of tunnel {}: I am not the master", (Object)l2Tunnel.tunnelId());
            return Result.SUCCESS;
        }
        Link nextHop = this.getNextHop(ingress, egress);
        if (nextHop == null) {
            log.warn("No path between ingress and egress");
            return Result.WRONG_PARAMETERS;
        }
        NextObjective.Builder nextObjectiveBuilder = this.createNextObjective(Pipeline.INITIATION, nextHop.src(), nextHop.dst(), l2Tunnel, egress.deviceId());
        if (nextObjectiveBuilder == null) {
            return Result.INTERNAL_ERROR;
        }
        TrafficSelector metadata = DefaultTrafficSelector.builder().matchTunnelId(l2Tunnel.tunnelId()).build();
        nextObjectiveBuilder.withMeta(metadata);
        int nextId = this.srManager.flowObjectiveService.allocateNextId();
        if (nextId < 0) {
            log.warn("Not able to allocate a next id for initiation");
            return Result.INTERNAL_ERROR;
        }
        nextObjectiveBuilder.withId(nextId);
        String key = this.generateKey(l2Tunnel.tunnelId(), direction);
        this.l2InitiationNextObjStore.put((Object)key, (Object)nextObjectiveBuilder.add());
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("Initiation l2 tunnel rule for {} populated", (Object)l2Tunnel.tunnelId()), (objective, error) -> log.warn("Failed to populate Initiation l2 tunnel rule for {}: {}", (Object)l2Tunnel.tunnelId(), error));
        NextObjective nextObjective = nextObjectiveBuilder.add((ObjectiveContext)context);
        this.srManager.flowObjectiveService.next(ingress.deviceId(), nextObjective);
        log.debug("Initiation next objective for {} not found. Creating new NextObj with id={}", (Object)l2Tunnel.tunnelId(), (Object)nextObjective.id());
        Result result = Result.SUCCESS;
        result.nextId = nextObjective.id();
        return result;
    }

    private Result deployPseudoWireTerm(DefaultL2Tunnel l2Tunnel, ConnectPoint egress, VlanId egressVlan, Direction direction) {
        if (!this.srManager.mastershipService.isLocalMaster(egress.deviceId())) {
            log.info("Abort termination of tunnel {}: I am not the master", (Object)l2Tunnel.tunnelId());
            return Result.SUCCESS;
        }
        NextObjective.Builder nextObjectiveBuilder = this.createNextObjective(Pipeline.TERMINATION, egress, null, null, egress.deviceId());
        if (nextObjectiveBuilder == null) {
            return Result.INTERNAL_ERROR;
        }
        TrafficSelector metadata = DefaultTrafficSelector.builder().matchVlanId(egressVlan).build();
        nextObjectiveBuilder.withMeta(metadata);
        int nextId = this.srManager.flowObjectiveService.allocateNextId();
        if (nextId < 0) {
            log.warn("Not able to allocate a next id for initiation");
            return Result.INTERNAL_ERROR;
        }
        nextObjectiveBuilder.withId(nextId);
        String key = this.generateKey(l2Tunnel.tunnelId(), direction);
        this.l2TerminationNextObjStore.put((Object)key, (Object)nextObjectiveBuilder.add());
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("Termination l2 tunnel rule for {} populated", (Object)l2Tunnel.tunnelId()), (objective, error) -> log.warn("Failed to populate termination l2 tunnel rule for {}: {}", (Object)l2Tunnel.tunnelId(), error));
        NextObjective nextObjective = nextObjectiveBuilder.add((ObjectiveContext)context);
        this.srManager.flowObjectiveService.next(egress.deviceId(), nextObjective);
        log.debug("Termination next objective for {} not found. Creating new NextObj with id={}", (Object)l2Tunnel.tunnelId(), (Object)nextObjective.id());
        ForwardingObjective.Builder fwdBuilder = this.createTermFwdObjective(l2Tunnel.pwLabel(), l2Tunnel.tunnelId(), egress.port(), nextObjective.id());
        context = new DefaultObjectiveContext(objective -> log.debug("FwdObj for tunnel termination {} populated", (Object)l2Tunnel.tunnelId()), (objective, error) -> log.warn("Failed to populate fwdrObj for tunnel termination {}", (Object)l2Tunnel.tunnelId(), error));
        this.srManager.flowObjectiveService.forward(egress.deviceId(), fwdBuilder.add((ObjectiveContext)context));
        log.debug("Creating new FwdObj for termination NextObj with id={} for tunnel {}", (Object)nextId, (Object)l2Tunnel.tunnelId());
        return Result.SUCCESS;
    }

    private Result verifyTunnel(DefaultL2Tunnel l2Tunnel) {
        if (!l2Tunnel.sdTag().equals((Object)VlanId.NONE)) {
            log.warn("Service delimiting tag not supported yet");
            return Result.UNSUPPORTED;
        }
        if (l2Tunnel.pwMode() == L2Mode.TAGGED) {
            log.warn("Tagged mode not supported yet");
            return Result.UNSUPPORTED;
        }
        return Result.SUCCESS;
    }

    private FilteringObjective.Builder createFiltObjective(PortNumber inPort, VlanId innerTag, VlanId outerTag) {
        return DefaultFilteringObjective.builder().withKey(Criteria.matchInPort((PortNumber)inPort)).addCondition(Criteria.matchInnerVlanId((VlanId)innerTag)).addCondition(Criteria.matchVlanId((VlanId)outerTag)).withPriority(100).permit().fromApp(this.srManager.appId());
    }

    private ForwardingObjective.Builder createTermFwdObjective(MplsLabel pwLabel, long tunnelId, PortNumber egressPort, int nextId) {
        TrafficSelector.Builder trafficSelector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder trafficTreatment = DefaultTrafficTreatment.builder();
        trafficSelector.matchEthType(Ethernet.MPLS_UNICAST);
        trafficSelector.matchMplsLabel(pwLabel);
        trafficSelector.matchMplsBos(true);
        trafficTreatment.decMplsTtl();
        trafficTreatment.copyTtlIn();
        trafficTreatment.popMpls();
        trafficTreatment.setTunnelId(tunnelId);
        trafficTreatment.setOutput(egressPort);
        return DefaultForwardingObjective.builder().fromApp(this.srManager.appId()).makePermanent().nextStep(nextId).withPriority(100).withSelector(trafficSelector.build()).withTreatment(trafficTreatment.build()).withFlag(ForwardingObjective.Flag.VERSATILE);
    }

    private ForwardingObjective.Builder createInitFwdObjective(long tunnelId, PortNumber inPort, int nextId) {
        TrafficSelector.Builder trafficSelector = DefaultTrafficSelector.builder();
        trafficSelector.matchTunnelId(tunnelId);
        trafficSelector.matchInPort(inPort);
        return DefaultForwardingObjective.builder().fromApp(this.srManager.appId()).makePermanent().nextStep(nextId).withPriority(100).withSelector(trafficSelector.build()).withFlag(ForwardingObjective.Flag.VERSATILE);
    }

    private NextObjective.Builder createNextObjective(Pipeline pipeline, ConnectPoint srcCp, ConnectPoint dstCp, DefaultL2Tunnel l2Tunnel, DeviceId egressId) {
        DefaultNextObjective.Builder nextObjBuilder;
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        if (pipeline == Pipeline.INITIATION) {
            MacAddress neighborMac;
            MacAddress ingressMac;
            MplsLabel srLabel;
            nextObjBuilder = DefaultNextObjective.builder().withType(NextObjective.Type.SIMPLE).fromApp(this.srManager.appId());
            if (l2Tunnel.pwLabel().toInt() == 1048575) {
                log.warn("Pw label not configured");
                return null;
            }
            treatmentBuilder.pushMpls();
            treatmentBuilder.setMpls(l2Tunnel.pwLabel());
            treatmentBuilder.setMplsBos(true);
            treatmentBuilder.copyTtlOut();
            if (l2Tunnel.interCoLabel().toInt() != 1048575) {
                treatmentBuilder.pushMpls();
                treatmentBuilder.setMpls(l2Tunnel.interCoLabel());
                treatmentBuilder.setMplsBos(false);
                treatmentBuilder.copyTtlOut();
            }
            try {
                srLabel = MplsLabel.mplsLabel((int)this.srManager.deviceConfiguration().getIPv4SegmentId(egressId));
            }
            catch (DeviceConfigNotFoundException e) {
                log.warn("Sr label not configured");
                return null;
            }
            treatmentBuilder.pushMpls();
            treatmentBuilder.setMpls(srLabel);
            treatmentBuilder.setMplsBos(false);
            treatmentBuilder.copyTtlOut();
            try {
                ingressMac = this.srManager.deviceConfiguration().getDeviceMac(srcCp.deviceId());
            }
            catch (DeviceConfigNotFoundException e) {
                log.warn("Was not able to find the ingress mac");
                return null;
            }
            treatmentBuilder.setEthSrc(ingressMac);
            try {
                neighborMac = this.srManager.deviceConfiguration().getDeviceMac(dstCp.deviceId());
            }
            catch (DeviceConfigNotFoundException e) {
                log.warn("Was not able to find the neighbor mac");
                return null;
            }
            treatmentBuilder.setEthDst(neighborMac);
        } else {
            nextObjBuilder = DefaultNextObjective.builder().withType(NextObjective.Type.SIMPLE).fromApp(this.srManager.appId());
        }
        treatmentBuilder.setOutput(srcCp.port());
        nextObjBuilder.addTreatment(treatmentBuilder.build());
        return nextObjBuilder;
    }

    private Link getNextHop(ConnectPoint srcCp, ConnectPoint dstCp) {
        Set paths = this.srManager.pathService.getDisjointPaths(srcCp.elementId(), dstCp.elementId());
        if (paths.isEmpty()) {
            return null;
        }
        int size = paths.size();
        int index = RandomUtils.nextInt((int)0, (int)size);
        List links = ((DisjointPath)Iterables.get((Iterable)paths, (int)index)).links();
        Preconditions.checkState((links.size() == 2 ? 1 : 0) != 0, (String)WRONG_TOPOLOGY, (Object)links);
        return (Link)links.get(0);
    }

    private void deletePolicy(final long tunnelId, ConnectPoint ingress, VlanId ingressInner, VlanId ingressOuter, final CompletableFuture<ObjectiveError> future, Direction direction) {
        if (!this.srManager.mastershipService.isLocalMaster(ingress.deviceId())) {
            log.info("Abort delete of policy for tunnel {}: I am not the master", (Object)tunnelId);
            if (future != null) {
                future.complete(null);
            }
            return;
        }
        String key = this.generateKey(tunnelId, direction);
        if (!this.l2InitiationNextObjStore.containsKey((Object)key)) {
            log.warn("Abort delete of policy for tunnel {}: next does not exist in the store", (Object)tunnelId);
            if (future != null) {
                future.complete(null);
            }
            return;
        }
        NextObjective nextObjective = (NextObjective)this.l2InitiationNextObjStore.get((Object)key).value();
        int nextId = nextObjective.id();
        ArrayList objectives = Lists.newArrayList();
        ForwardingObjective.Builder fwdBuilder = this.createInitFwdObjective(tunnelId, ingress.port(), nextId);
        ObjectiveContext context = new ObjectiveContext(){

            public void onSuccess(Objective objective) {
                log.debug("Previous fwdObj for policy {} removed", (Object)tunnelId);
                if (future != null) {
                    future.complete(null);
                }
            }

            public void onError(Objective objective, ObjectiveError error) {
                log.warn("Failed to remove previous fwdObj for policy {}: {}", (Object)tunnelId, (Object)error);
                if (future != null) {
                    future.complete(error);
                }
            }
        };
        objectives.add(fwdBuilder.remove(context));
        FilteringObjective.Builder filtBuilder = this.createFiltObjective(ingress.port(), ingressInner, ingressOuter);
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().setTunnelId(tunnelId);
        filtBuilder.withMeta(treatment.build());
        context = new DefaultObjectiveContext(objective -> log.debug("FilterObj for policy {} revoked", (Object)tunnelId), (objective, error) -> log.warn("Failed to revoke filterObj for policy {}", (Object)tunnelId, error));
        objectives.add(filtBuilder.remove(context));
        for (Objective objective2 : objectives) {
            if (objective2 instanceof ForwardingObjective) {
                this.srManager.flowObjectiveService.forward(ingress.deviceId(), (ForwardingObjective)objective2);
                continue;
            }
            this.srManager.flowObjectiveService.filter(ingress.deviceId(), (FilteringObjective)objective2);
        }
    }

    private void tearDownPseudoWireInit(long l2TunnelId, ConnectPoint ingress, final CompletableFuture<ObjectiveError> future, Direction direction) {
        final String key = this.generateKey(l2TunnelId, direction);
        if (!this.srManager.mastershipService.isLocalMaster(ingress.deviceId())) {
            log.info("Abort delete of {} for {}: I am not the master", (Object)Pipeline.INITIATION, (Object)key);
            if (future != null) {
                future.complete(null);
            }
            return;
        }
        if (!this.l2InitiationNextObjStore.containsKey((Object)key)) {
            log.info("Abort delete of {} for {}: next does not exist in the store", (Object)Pipeline.INITIATION, (Object)key);
            if (future != null) {
                future.complete(null);
            }
            return;
        }
        NextObjective nextObjective = (NextObjective)this.l2InitiationNextObjStore.get((Object)key).value();
        ObjectiveContext context = new ObjectiveContext(){

            public void onSuccess(Objective objective) {
                log.debug("Previous {} next for {} removed", (Object)Pipeline.INITIATION, (Object)key);
                if (future != null) {
                    future.complete(null);
                }
            }

            public void onError(Objective objective, ObjectiveError error) {
                log.warn("Failed to remove previous {} next for {}: {}", new Object[]{Pipeline.INITIATION, key, error});
                if (future != null) {
                    future.complete(error);
                }
            }
        };
        this.srManager.flowObjectiveService.next(ingress.deviceId(), (NextObjective)nextObjective.copy().remove(context));
        this.l2InitiationNextObjStore.remove((Object)key);
    }

    private void tearDownPseudoWireTerm(DefaultL2Tunnel l2Tunnel, ConnectPoint egress, final CompletableFuture<ObjectiveError> future, Direction direction) {
        final String key = this.generateKey(l2Tunnel.tunnelId(), direction);
        if (!this.srManager.mastershipService.isLocalMaster(egress.deviceId())) {
            log.info("Abort delete of {} for {}: I am not the master", (Object)Pipeline.TERMINATION, (Object)key);
            if (future != null) {
                future.complete(null);
            }
            return;
        }
        if (!this.l2TerminationNextObjStore.containsKey((Object)key)) {
            log.info("Abort delete of {} for {}: next does not exist in the store", (Object)Pipeline.TERMINATION, (Object)key);
            if (future != null) {
                future.complete(null);
            }
            return;
        }
        NextObjective nextObjective = (NextObjective)this.l2TerminationNextObjStore.get((Object)key).value();
        ForwardingObjective.Builder fwdBuilder = this.createTermFwdObjective(l2Tunnel.pwLabel(), l2Tunnel.tunnelId(), egress.port(), nextObjective.id());
        Object context = new DefaultObjectiveContext(objective -> log.debug("FwdObj for {} {} removed", (Object)Pipeline.TERMINATION, (Object)l2Tunnel.tunnelId()), (objective, error) -> log.warn("Failed to remove fwdObj for {} {}", new Object[]{Pipeline.TERMINATION, l2Tunnel.tunnelId(), error}));
        this.srManager.flowObjectiveService.forward(egress.deviceId(), fwdBuilder.remove((ObjectiveContext)context));
        context = new ObjectiveContext(){

            public void onSuccess(Objective objective) {
                log.debug("Previous {} next for {} removed", (Object)Pipeline.TERMINATION, (Object)key);
                if (future != null) {
                    future.complete(null);
                }
            }

            public void onError(Objective objective, ObjectiveError error) {
                log.warn("Failed to remove previous {} next for {}: {}", new Object[]{Pipeline.TERMINATION, key, error});
                if (future != null) {
                    future.complete(error);
                }
            }
        };
        this.srManager.flowObjectiveService.next(egress.deviceId(), (NextObjective)nextObjective.copy().remove((ObjectiveContext)context));
        this.l2TerminationNextObjStore.remove((Object)key);
    }

    private String generateKey(long tunnelId, Direction direction) {
        return String.format("%s-%s", new Object[]{tunnelId, direction});
    }

    public static enum Direction {
        FWD,
        REV;

    }

    public static enum Result {
        SUCCESS(0, "It has been Created"),
        WRONG_PARAMETERS(1, "Wrong parameters"),
        ID_EXISTS(2, "The id already exists"),
        INTERNAL_ERROR(3, "Internal error"),
        UNSUPPORTED(4, "Unsupported");

        private final int code;
        private final String description;
        private int nextId;

        private Result(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.code + ": " + this.description;
        }
    }

    protected static enum Pipeline {
        INITIATION,
        TERMINATION;

    }
}

