/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.pwaas;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.segmentrouting.pwaas.L2Mode;

public class DefaultL2Tunnel {
    private L2Mode pwMode;
    private VlanId sdTag;
    private long tunnelId;
    private MplsLabel pwLabel;
    private MplsLabel interCoLabel;

    public DefaultL2Tunnel(L2Mode mode, VlanId sdtag, long tunnelId, MplsLabel pwLabel, MplsLabel interCoLabel) {
        Preconditions.checkNotNull((Object)((Object)mode));
        Preconditions.checkArgument((tunnelId > 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)pwLabel);
        Preconditions.checkNotNull((Object)interCoLabel);
        this.pwMode = mode;
        this.sdTag = sdtag;
        this.tunnelId = tunnelId;
        this.pwLabel = pwLabel;
        this.interCoLabel = interCoLabel;
    }

    public DefaultL2Tunnel(L2Mode mode, VlanId sdtag, long tunnelId, MplsLabel pwLabel) {
        this(mode, sdtag, tunnelId, pwLabel, MplsLabel.mplsLabel((int)1048575));
    }

    public DefaultL2Tunnel() {
        this.pwMode = null;
        this.sdTag = null;
        this.tunnelId = 0L;
        this.pwLabel = null;
        this.interCoLabel = null;
    }

    public L2Mode pwMode() {
        return this.pwMode;
    }

    public VlanId sdTag() {
        return this.sdTag;
    }

    public long tunnelId() {
        return this.tunnelId;
    }

    public MplsLabel pwLabel() {
        return this.pwLabel;
    }

    public MplsLabel interCoLabel() {
        return this.interCoLabel;
    }

    public int hashCode() {
        return Objects.hash(this.tunnelId, this.pwLabel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (o instanceof DefaultL2Tunnel) {
            DefaultL2Tunnel that = (DefaultL2Tunnel)o;
            return this.tunnelId == that.tunnelId && this.pwMode.equals((Object)that.pwMode) && this.sdTag.equals((Object)that.sdTag) && this.pwLabel.equals((Object)that.pwLabel) && this.interCoLabel.equals((Object)that.interCoLabel);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pwMode", (Object)this.pwMode()).add("sdTag", (Object)this.sdTag()).add("tunnelId", this.tunnelId()).add("pwLabel", (Object)this.pwLabel()).add("interCoLabel", (Object)this.interCoLabel()).toString();
    }
}

