/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.grouphandler;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.onosproject.net.PortNumber;

public class PolicyGroupParams {
    private final List<PortNumber> ports;
    private final List<Integer> labelStack;

    public PolicyGroupParams(List<Integer> labelStack, List<PortNumber> ports) {
        this.ports = (List)Preconditions.checkNotNull(ports);
        this.labelStack = (List)Preconditions.checkNotNull(labelStack);
    }

    public List<PortNumber> getPorts() {
        return this.ports;
    }

    public List<Integer> getLabelStack() {
        return this.labelStack;
    }

    public int hashCode() {
        int result = 17;
        int combinedHash = 0;
        for (PortNumber port : this.ports) {
            combinedHash += port.hashCode();
        }
        result = 31 * result + (combinedHash += Objects.hash(this.labelStack));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PolicyGroupParams) {
            PolicyGroupParams that = (PolicyGroupParams)obj;
            boolean result = this.labelStack.equals(that.labelStack);
            result = result && this.ports.containsAll(that.ports) && that.ports.containsAll(this.ports);
            return result;
        }
        return false;
    }
}

