/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.grouphandler;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.link.LinkService;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.DeviceProperties;
import org.onosproject.segmentrouting.grouphandler.DefaultGroupHandler;
import org.onosproject.segmentrouting.grouphandler.GroupBucketIdentifier;
import org.onosproject.segmentrouting.grouphandler.PolicyGroupIdentifier;
import org.onosproject.segmentrouting.grouphandler.PolicyGroupParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyGroupHandler
extends DefaultGroupHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private HashMap<PolicyGroupIdentifier, PolicyGroupIdentifier> dependentGroups = new HashMap();

    public PolicyGroupHandler(DeviceId deviceId, ApplicationId appId, DeviceProperties config, LinkService linkService, FlowObjectiveService flowObjService, SegmentRoutingManager srManager) {
        super(deviceId, appId, config, linkService, flowObjService, srManager);
    }

    public PolicyGroupIdentifier createPolicyGroupChain(String id, List<PolicyGroupParams> params) {
        ArrayList<GroupBucketIdentifier> bucketIds = new ArrayList<GroupBucketIdentifier>();
        for (PolicyGroupParams param : params) {
            PortNumber sp2;
            int labelStackSize;
            List<PortNumber> ports = param.getPorts();
            if (ports == null) {
                this.log.warn("createPolicyGroupChain in sw {} with wrong input parameters", (Object)this.deviceId);
                return null;
            }
            int n = labelStackSize = param.getLabelStack() != null ? param.getLabelStack().size() : 0;
            if (labelStackSize > 1) {
                for (PortNumber sp2 : ports) {
                    PolicyGroupIdentifier previousGroupkey = null;
                    DeviceId neighbor = (DeviceId)this.portDeviceMap.get(sp2);
                    for (int idx = 0; idx < param.getLabelStack().size(); ++idx) {
                        GroupBucketIdentifier bucketId;
                        int label = param.getLabelStack().get(idx);
                        if (idx == labelStackSize - 1) {
                            bucketId = new GroupBucketIdentifier(label, previousGroupkey);
                            bucketIds.add(bucketId);
                            continue;
                        }
                        if (idx == 0) {
                            MacAddress neighborEthDst;
                            ArrayList outBuckets = new ArrayList();
                            GroupBucketIdentifier bucketId2 = new GroupBucketIdentifier(label, sp2);
                            PolicyGroupIdentifier key = new PolicyGroupIdentifier(id, Collections.singletonList(param), Collections.singletonList(bucketId2));
                            try {
                                neighborEthDst = this.deviceConfig.getDeviceMac(neighbor);
                            }
                            catch (DeviceConfigNotFoundException e) {
                                this.log.warn(e.getMessage() + " Skipping createPolicyGroupChain for this label.");
                                continue;
                            }
                            TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
                            tBuilder.setOutput(sp2).setEthDst(neighborEthDst).setEthSrc(this.nodeMacAddr).pushMpls().setMpls(MplsLabel.mplsLabel((int)label));
                            previousGroupkey = key;
                            continue;
                        }
                        bucketId = new GroupBucketIdentifier(label, previousGroupkey);
                        PolicyGroupIdentifier key = new PolicyGroupIdentifier(id, Collections.singletonList(param), Collections.singletonList(bucketId));
                        this.dependentGroups.put(previousGroupkey, key);
                        previousGroupkey = key;
                    }
                }
                continue;
            }
            int label = -1;
            if (labelStackSize == 1) {
                label = param.getLabelStack().get(0);
            }
            sp2 = ports.iterator();
            while (sp2.hasNext()) {
                PortNumber sp3 = (PortNumber)sp2.next();
                GroupBucketIdentifier bucketId = new GroupBucketIdentifier(label, sp3);
                bucketIds.add(bucketId);
            }
        }
        PolicyGroupIdentifier innermostGroupkey = null;
        if (!bucketIds.isEmpty()) {
            innermostGroupkey = new PolicyGroupIdentifier(id, params, bucketIds);
            boolean fullyResolved = true;
            for (GroupBucketIdentifier bucketId : bucketIds) {
                if (bucketId.type() != GroupBucketIdentifier.BucketOutputType.GROUP) continue;
                this.dependentGroups.put(bucketId.outGroup(), innermostGroupkey);
                fullyResolved = false;
            }
            if (fullyResolved) {
                ArrayList outBuckets = new ArrayList();
                for (GroupBucketIdentifier bucketId : bucketIds) {
                    MacAddress neighborEthDst;
                    DeviceId neighbor = (DeviceId)this.portDeviceMap.get(bucketId.outPort());
                    try {
                        neighborEthDst = this.deviceConfig.getDeviceMac(neighbor);
                    }
                    catch (DeviceConfigNotFoundException e) {
                        this.log.warn(e.getMessage() + " Skipping createPolicyGroupChain for this bucketId.");
                        continue;
                    }
                    TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
                    tBuilder.setOutput(bucketId.outPort()).setEthDst(neighborEthDst).setEthSrc(this.nodeMacAddr);
                    if (bucketId.label() == -1) continue;
                    tBuilder.pushMpls().setMpls(MplsLabel.mplsLabel((int)bucketId.label()));
                }
            }
        }
        return innermostGroupkey;
    }

    public PolicyGroupIdentifier generatePolicyGroupKey(String id, List<PolicyGroupParams> params) {
        ArrayList<GroupBucketIdentifier> bucketIds = new ArrayList<GroupBucketIdentifier>();
        for (PolicyGroupParams param : params) {
            int labelStackSize;
            List<PortNumber> ports = param.getPorts();
            if (ports == null) {
                this.log.warn("generateGroupKey in sw {} with wrong input parameters", (Object)this.deviceId);
                return null;
            }
            int n = labelStackSize = param.getLabelStack() != null ? param.getLabelStack().size() : 0;
            if (labelStackSize > 1) {
                for (PortNumber sp : ports) {
                    PolicyGroupIdentifier previousGroupkey = null;
                    for (int idx = 0; idx < param.getLabelStack().size(); ++idx) {
                        PolicyGroupIdentifier key;
                        GroupBucketIdentifier bucketId;
                        int label = param.getLabelStack().get(idx);
                        if (idx == labelStackSize - 1) {
                            bucketId = new GroupBucketIdentifier(label, previousGroupkey);
                            bucketIds.add(bucketId);
                            continue;
                        }
                        if (idx == 0) {
                            bucketId = new GroupBucketIdentifier(label, sp);
                            previousGroupkey = key = new PolicyGroupIdentifier(id, Collections.singletonList(param), Collections.singletonList(bucketId));
                            continue;
                        }
                        bucketId = new GroupBucketIdentifier(label, previousGroupkey);
                        previousGroupkey = key = new PolicyGroupIdentifier(id, Collections.singletonList(param), Collections.singletonList(bucketId));
                    }
                }
                continue;
            }
            int label = -1;
            if (labelStackSize == 1) {
                label = param.getLabelStack().get(0);
            }
            for (PortNumber sp : ports) {
                GroupBucketIdentifier bucketId = new GroupBucketIdentifier(label, sp);
                bucketIds.add(bucketId);
            }
        }
        PolicyGroupIdentifier innermostGroupkey = null;
        if (!bucketIds.isEmpty()) {
            innermostGroupkey = new PolicyGroupIdentifier(id, params, bucketIds);
        }
        return innermostGroupkey;
    }

    public void removeGroupChain(PolicyGroupIdentifier key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0);
        ArrayList<PolicyGroupIdentifier> groupsToBeDeleted = new ArrayList<PolicyGroupIdentifier>();
        groupsToBeDeleted.add(key);
        Iterator it = groupsToBeDeleted.iterator();
        while (it.hasNext()) {
            PolicyGroupIdentifier innerMostGroupKey = (PolicyGroupIdentifier)it.next();
            for (GroupBucketIdentifier bucketId : innerMostGroupKey.bucketIds()) {
                if (bucketId.type() == GroupBucketIdentifier.BucketOutputType.GROUP) continue;
                groupsToBeDeleted.add(bucketId.outGroup());
            }
            it.remove();
        }
    }
}

