/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.grouphandler;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.segmentrouting.grouphandler.RandomNeighborSet;

public class NeighborSet {
    private final Set<DeviceId> neighbors;
    private final int edgeLabel;
    public static final int NO_EDGE_LABEL = -1;
    private boolean mplsSet;

    public NeighborSet(Set<DeviceId> neighbors, boolean isMplsSet) {
        Preconditions.checkNotNull(neighbors);
        this.edgeLabel = -1;
        this.neighbors = new HashSet<DeviceId>();
        this.neighbors.addAll(neighbors);
        this.mplsSet = isMplsSet;
    }

    public NeighborSet(Set<DeviceId> neighbors, boolean isMplsSet, int edgeLabel) {
        Preconditions.checkNotNull(neighbors);
        this.edgeLabel = edgeLabel;
        this.neighbors = new HashSet<DeviceId>();
        this.neighbors.addAll(neighbors);
        this.mplsSet = isMplsSet;
    }

    public NeighborSet() {
        this.edgeLabel = -1;
        this.neighbors = new HashSet<DeviceId>();
        this.mplsSet = true;
    }

    public static NeighborSet neighborSet(boolean random, Set<DeviceId> neighbors, boolean isMplsSet) {
        return random ? new RandomNeighborSet(neighbors) : new NeighborSet(neighbors, isMplsSet);
    }

    public static NeighborSet neighborSet(boolean random, Set<DeviceId> neighbors, boolean isMplsSet, int edgeLabel) {
        return random ? new RandomNeighborSet(neighbors, edgeLabel) : new NeighborSet(neighbors, isMplsSet, edgeLabel);
    }

    public static NeighborSet neighborSet(boolean random) {
        return random ? new RandomNeighborSet() : new NeighborSet();
    }

    public Set<DeviceId> getDeviceIds() {
        return this.neighbors;
    }

    public int getEdgeLabel() {
        return this.edgeLabel;
    }

    public DeviceId getFirstNeighbor() {
        return this.neighbors.isEmpty() ? DeviceId.NONE : this.neighbors.iterator().next();
    }

    public boolean mplsSet() {
        return this.mplsSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NeighborSet)) {
            return false;
        }
        NeighborSet that = (NeighborSet)o;
        return this.neighbors.containsAll(that.neighbors) && that.neighbors.containsAll(this.neighbors) && this.edgeLabel == that.edgeLabel && this.mplsSet == that.mplsSet;
    }

    public int hashCode() {
        return Objects.hash(this.neighbors, this.edgeLabel, this.mplsSet);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Neighborset Sw", this.neighbors).add("Label", this.edgeLabel).add("MplsSet", this.mplsSet).toString();
    }
}

