/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.grouphandler;

import java.util.HashSet;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.link.LinkService;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.DeviceProperties;
import org.onosproject.segmentrouting.grouphandler.DefaultGroupHandler;
import org.onosproject.segmentrouting.grouphandler.NeighborSet;

public class DefaultTransitGroupHandler
extends DefaultGroupHandler {
    protected DefaultTransitGroupHandler(DeviceId deviceId, ApplicationId appId, DeviceProperties config, LinkService linkService, FlowObjectiveService flowObjService, SegmentRoutingManager srManager) {
        super(deviceId, appId, config, linkService, flowObjService, srManager);
    }

    @Override
    public void createGroups() {
        Set neighbors = this.devicePortMap.keySet();
        if (neighbors == null || neighbors.isEmpty()) {
            return;
        }
        Set<Set<DeviceId>> sets = this.getPowerSetOfNeighbors(neighbors);
        sets = this.filterEdgeRouterOnlyPairings(sets);
        log.debug("createGroupsAtTransitRouter: The size of neighbor powerset for sw {} is {}", (Object)this.deviceId, (Object)sets.size());
        HashSet<NeighborSet> nsSet = new HashSet<NeighborSet>();
        for (Set<DeviceId> combo : sets) {
            if (combo.isEmpty()) continue;
            NeighborSet ns = new NeighborSet(combo, false);
            log.debug("createGroupsAtTransitRouter: sw {} combo {} ns {}", new Object[]{this.deviceId, combo, ns});
            nsSet.add(ns);
        }
        log.debug("createGroupsAtTransitRouter: The neighborset with label for sw {} is {}", (Object)this.deviceId, nsSet);
    }

    @Override
    protected void newNeighbor(Link newNeighborLink) {
        log.debug("New Neighbor: Updating groups for transit device {}", (Object)this.deviceId);
        this.addNeighborAtPort(newNeighborLink.dst().deviceId(), newNeighborLink.src().port());
        Set<NeighborSet> nsSet = this.computeImpactedNeighborsetForPortEvent(newNeighborLink.dst().deviceId(), this.devicePortMap.keySet());
    }

    @Override
    protected void newPortToExistingNeighbor(Link newNeighborLink) {
    }

    @Override
    protected Set<NeighborSet> computeImpactedNeighborsetForPortEvent(DeviceId impactedNeighbor, Set<DeviceId> updatedNeighbors) {
        Set<Set<DeviceId>> powerSet = this.getPowerSetOfNeighbors(updatedNeighbors);
        HashSet<DeviceId> tmp = new HashSet<DeviceId>();
        tmp.addAll(updatedNeighbors);
        tmp.remove(impactedNeighbor);
        Set<Set<DeviceId>> tmpPowerSet = this.getPowerSetOfNeighbors(tmp);
        powerSet.removeAll(tmpPowerSet);
        powerSet = this.filterEdgeRouterOnlyPairings(powerSet);
        HashSet<NeighborSet> nsSet = new HashSet<NeighborSet>();
        for (Set<DeviceId> combo : powerSet) {
            if (combo.isEmpty()) continue;
            NeighborSet ns = new NeighborSet(combo, false);
            log.debug("createGroupsAtTransitRouter: sw {} combo {} ns {}", new Object[]{this.deviceId, combo, ns});
            nsSet.add(ns);
        }
        log.debug("computeImpactedNeighborsetForPortEvent: The neighborset with label for sw {} is {}", (Object)this.deviceId, nsSet);
        return nsSet;
    }

    private Set<Set<DeviceId>> filterEdgeRouterOnlyPairings(Set<Set<DeviceId>> sets) {
        HashSet<Set<DeviceId>> fiteredSets = new HashSet<Set<DeviceId>>();
        for (Set<DeviceId> deviceSubSet : sets) {
            if (deviceSubSet.size() > 1) {
                boolean avoidEdgeRouterPairing = true;
                for (DeviceId device : deviceSubSet) {
                    boolean isEdge;
                    try {
                        isEdge = this.deviceConfig.isEdgeDevice(device);
                    }
                    catch (DeviceConfigNotFoundException e) {
                        log.warn(e.getMessage() + " Skipping filterEdgeRouterOnlyPairings on this device.");
                        continue;
                    }
                    if (isEdge) continue;
                    avoidEdgeRouterPairing = false;
                    break;
                }
                if (avoidEdgeRouterPairing) continue;
                fiteredSets.add(deviceSubSet);
                continue;
            }
            fiteredSets.add(deviceSubSet);
        }
        return fiteredSets;
    }
}

