/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.grouphandler;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.DefaultObjectiveContext;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.link.LinkService;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.DeviceProperties;
import org.onosproject.segmentrouting.grouphandler.DefaultEdgeGroupHandler;
import org.onosproject.segmentrouting.grouphandler.DefaultTransitGroupHandler;
import org.onosproject.segmentrouting.grouphandler.GroupBucketIdentifier;
import org.onosproject.segmentrouting.grouphandler.NeighborSet;
import org.onosproject.segmentrouting.grouphandler.PolicyGroupIdentifier;
import org.onosproject.segmentrouting.grouphandler.PolicyGroupParams;
import org.onosproject.segmentrouting.storekey.NeighborSetNextObjectiveStoreKey;
import org.onosproject.segmentrouting.storekey.PortNextObjectiveStoreKey;
import org.onosproject.segmentrouting.storekey.VlanNextObjectiveStoreKey;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGroupHandler {
    protected static final Logger log = LoggerFactory.getLogger(DefaultGroupHandler.class);
    protected final DeviceId deviceId;
    protected final ApplicationId appId;
    protected final DeviceProperties deviceConfig;
    protected final List<Integer> allSegmentIds;
    protected int ipv4NodeSegmentId = -1;
    protected int ipv6NodeSegmentId = -1;
    protected boolean isEdgeRouter = false;
    protected MacAddress nodeMacAddr = null;
    protected LinkService linkService;
    protected FlowObjectiveService flowObjectiveService;
    protected ConcurrentHashMap<DeviceId, Set<PortNumber>> devicePortMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<PortNumber, DeviceId> portDeviceMap = new ConcurrentHashMap();
    protected EventuallyConsistentMap<NeighborSetNextObjectiveStoreKey, Integer> nsNextObjStore = null;
    protected EventuallyConsistentMap<VlanNextObjectiveStoreKey, Integer> vlanNextObjStore = null;
    protected EventuallyConsistentMap<PortNextObjectiveStoreKey, Integer> portNextObjStore = null;
    private SegmentRoutingManager srManager;
    private static final long RETRY_INTERVAL_SEC = 30L;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, Tools.groupedThreads((String)"retryhashbkts", (String)"retry-%d", (Logger)log));
    protected KryoNamespace.Builder kryo = new KryoNamespace.Builder().register(new Class[]{URI.class}).register(new Class[]{HashSet.class}).register(new Class[]{DeviceId.class}).register(new Class[]{PortNumber.class}).register(new Class[]{NeighborSet.class}).register(new Class[]{PolicyGroupIdentifier.class}).register(new Class[]{PolicyGroupParams.class}).register(new Class[]{GroupBucketIdentifier.class}).register(new Class[]{GroupBucketIdentifier.BucketOutputType.class});

    protected DefaultGroupHandler(DeviceId deviceId, ApplicationId appId, DeviceProperties config, LinkService linkService, FlowObjectiveService flowObjService, SegmentRoutingManager srManager) {
        this.deviceId = (DeviceId)Preconditions.checkNotNull((Object)deviceId);
        this.appId = (ApplicationId)Preconditions.checkNotNull((Object)appId);
        this.deviceConfig = (DeviceProperties)Preconditions.checkNotNull((Object)config);
        this.linkService = (LinkService)Preconditions.checkNotNull((Object)linkService);
        this.allSegmentIds = (List)Preconditions.checkNotNull(config.getAllDeviceSegmentIds());
        try {
            this.ipv4NodeSegmentId = config.getIPv4SegmentId(deviceId);
            this.ipv6NodeSegmentId = config.getIPv6SegmentId(deviceId);
            this.isEdgeRouter = config.isEdgeDevice(deviceId);
            this.nodeMacAddr = (MacAddress)Preconditions.checkNotNull((Object)config.getDeviceMac(deviceId));
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Skipping value assignment in DefaultGroupHandler");
        }
        this.flowObjectiveService = flowObjService;
        this.nsNextObjStore = srManager.nsNextObjStore();
        this.vlanNextObjStore = srManager.vlanNextObjStore();
        this.portNextObjStore = srManager.portNextObjStore();
        this.srManager = srManager;
        this.populateNeighborMaps();
    }

    public static DefaultGroupHandler createGroupHandler(DeviceId deviceId, ApplicationId appId, DeviceProperties config, LinkService linkService, FlowObjectiveService flowObjService, SegmentRoutingManager srManager) throws DeviceConfigNotFoundException {
        if (config.isEdgeDevice(deviceId)) {
            return new DefaultEdgeGroupHandler(deviceId, appId, config, linkService, flowObjService, srManager);
        }
        return new DefaultTransitGroupHandler(deviceId, appId, config, linkService, flowObjService, srManager);
    }

    public void createGroups() {
    }

    public void linkUp(Link newLink, boolean isMaster) {
        MacAddress dstMac;
        if (newLink.type() != Link.Type.DIRECT) {
            log.info("Ignore link {}->{}. Link type is {} instead of DIRECT.", new Object[]{newLink.src(), newLink.dst(), newLink.type()});
            return;
        }
        if (!newLink.src().deviceId().equals((Object)this.deviceId)) {
            log.warn("linkUp: deviceId{} doesn't match with link src {}", (Object)this.deviceId, (Object)newLink.src().deviceId());
            return;
        }
        log.info("* LinkUP: Device {} linkUp at local port {} to neighbor {}", new Object[]{this.deviceId, newLink.src().port(), newLink.dst().deviceId()});
        this.addNeighborAtPort(newLink.dst().deviceId(), newLink.src().port());
        try {
            dstMac = this.deviceConfig.getDeviceMac(newLink.dst().deviceId());
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting linkUp.");
            return;
        }
        Set nsSet = this.nsNextObjStore.keySet().stream().filter(nsStoreEntry -> nsStoreEntry.deviceId().equals((Object)this.deviceId)).map(nsStoreEntry -> nsStoreEntry.neighborSet()).filter(ns -> ns.getDeviceIds().contains(newLink.dst().deviceId())).collect(Collectors.toSet());
        log.debug("linkUp: nsNextObjStore contents for device {}: {}", (Object)this.deviceId, nsSet);
        for (NeighborSet ns2 : nsSet) {
            Integer nextId = (Integer)this.nsNextObjStore.get((Object)new NeighborSetNextObjectiveStoreKey(this.deviceId, ns2));
            if (nextId != null && isMaster) {
                this.addToHashedNextObjective(newLink.src().port(), dstMac, ns2, nextId, false);
                for (PortNumber p : this.devicePortMap.get(newLink.dst().deviceId())) {
                    if (p.equals((Object)newLink.src().port())) continue;
                    this.addToHashedNextObjective(p, dstMac, ns2, nextId, false);
                }
                continue;
            }
            if (!isMaster) continue;
            log.warn("linkUp in device {}, but global store has no record for neighbor-set {}", (Object)this.deviceId, (Object)ns2);
        }
        if (isMaster) {
            this.executorService.schedule(new RetryHashBkts(newLink, dstMac), 30L, TimeUnit.SECONDS);
        }
    }

    private void addToHashedNextObjective(PortNumber outport, MacAddress dstMac, NeighborSet ns, Integer nextId, boolean retry) {
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
        tBuilder.setOutput(outport).setEthDst(dstMac).setEthSrc(this.nodeMacAddr);
        if (ns.getEdgeLabel() != -1) {
            tBuilder.pushMpls().copyTtlOut().setMpls(MplsLabel.mplsLabel((int)ns.getEdgeLabel()));
        }
        TrafficSelector.Builder metabuilder = DefaultTrafficSelector.builder();
        metabuilder.matchVlanId(SegmentRoutingManager.INTERNAL_VLAN);
        DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(nextId.intValue()).withType(NextObjective.Type.HASHED).addTreatment(tBuilder.build()).withMeta(metabuilder.build()).fromApp(this.appId);
        log.info("{} in device {}: Adding Bucket with Port {} to next object id {}", new Object[]{retry ? "**retry" : "**linkup", this.deviceId, outport, nextId});
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("LinkUp addedTo NextObj {} on {}", (Object)nextId, (Object)this.deviceId), (objective, error) -> log.warn("LinkUp failed to addTo NextObj {} on {}: {}", new Object[]{nextId, this.deviceId, error}));
        NextObjective nextObjective = nextObjBuilder.addToExisting((ObjectiveContext)context);
        this.flowObjectiveService.next(this.deviceId, nextObjective);
    }

    public void portDown(PortNumber port, boolean isMaster) {
        MacAddress dstMac;
        if (this.portDeviceMap.get(port) == null) {
            log.warn("portDown: unknown port");
            return;
        }
        try {
            dstMac = this.deviceConfig.getDeviceMac(this.portDeviceMap.get(port));
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting portDown.");
            return;
        }
        log.debug("Device {} portDown {} to neighbor {}", new Object[]{this.deviceId, port, this.portDeviceMap.get(port)});
        Set nsSet = this.nsNextObjStore.keySet().stream().filter(nsStoreEntry -> nsStoreEntry.deviceId().equals((Object)this.deviceId)).map(nsStoreEntry -> nsStoreEntry.neighborSet()).filter(ns -> ns.getDeviceIds().contains(this.portDeviceMap.get(port))).collect(Collectors.toSet());
        log.debug("portDown: nsNextObjStore contents for device {}:{}", (Object)this.deviceId, nsSet);
        for (NeighborSet ns2 : nsSet) {
            NeighborSetNextObjectiveStoreKey nsStoreKey = new NeighborSetNextObjectiveStoreKey(this.deviceId, ns2);
            Integer nextId = (Integer)this.nsNextObjStore.get((Object)nsStoreKey);
            if (nextId == null || !isMaster) continue;
            log.info("**portDown in device {}: Removing Bucket with Port {} to next object id {}", new Object[]{this.deviceId, port, nextId});
            TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
            tBuilder.setOutput(port).setEthDst(dstMac).setEthSrc(this.nodeMacAddr);
            if (ns2.getEdgeLabel() != -1) {
                tBuilder.pushMpls().copyTtlOut().setMpls(MplsLabel.mplsLabel((int)ns2.getEdgeLabel()));
            }
            DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withType(NextObjective.Type.HASHED).withId(nextId.intValue()).fromApp(this.appId).addTreatment(tBuilder.build());
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("portDown removedFrom NextObj {} on {}", (Object)nextId, (Object)this.deviceId), (objective, error) -> log.warn("portDown failed to removeFrom NextObj {} on {}: {}", new Object[]{nextId, this.deviceId, error}));
            NextObjective nextObjective = nextObjBuilder.removeFromExisting((ObjectiveContext)context);
            this.flowObjectiveService.next(this.deviceId, nextObjective);
        }
        this.devicePortMap.get(this.portDeviceMap.get(port)).remove(port);
        this.portDeviceMap.remove(port);
    }

    public void processEdgePort(PortNumber port, VlanId vlanId, boolean popVlan, boolean portUp) {
        Integer nextId = this.getVlanNextObjectiveId(vlanId);
        if (nextId == -1) {
            if (portUp) {
                log.debug("**Creating flooding group for first port enabled in subnet {} on dev {} port {}", new Object[]{vlanId, this.deviceId, port});
                this.createBcastGroupFromVlan(vlanId, Collections.singleton(port));
            } else {
                log.warn("Could not find flooding group for subnet {} on dev:{} when removing port:{}", new Object[]{vlanId, this.deviceId, port});
            }
            return;
        }
        log.info("**port{} in device {}: {} Bucket with Port {} to next-id {}", new Object[]{portUp ? "UP" : "DOWN", this.deviceId, portUp ? "Adding" : "Removing", port, nextId});
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
        if (popVlan) {
            tBuilder.popVlan();
        }
        tBuilder.setOutput(port);
        TrafficSelector metadata = DefaultTrafficSelector.builder().matchVlanId(vlanId).build();
        DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(nextId.intValue()).withType(NextObjective.Type.BROADCAST).fromApp(this.appId).addTreatment(tBuilder.build()).withMeta(metadata);
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("port {} successfully {} NextObj {} on {}", new Object[]{port, portUp ? "addedTo" : "removedFrom", nextId, this.deviceId}), (objective, error) -> log.warn("port {} failed to {} NextObj {} on {}: {}", new Object[]{port, portUp ? "addTo" : "removeFrom", nextId, this.deviceId, error}));
        NextObjective nextObj = portUp ? nextObjBuilder.addToExisting((ObjectiveContext)context) : nextObjBuilder.removeFromExisting((ObjectiveContext)context);
        log.debug("edgePort processed: Submited next objective {} in device {}", (Object)nextId, (Object)this.deviceId);
        this.flowObjectiveService.next(this.deviceId, nextObj);
    }

    public int getNextObjectiveId(NeighborSet ns, TrafficSelector meta, boolean isBos) {
        Integer nextId = (Integer)this.nsNextObjStore.get((Object)new NeighborSetNextObjectiveStoreKey(this.deviceId, ns));
        if (nextId == null) {
            log.trace("getNextObjectiveId in device{}: Next objective id not found for {} and creating", (Object)this.deviceId, (Object)ns);
            log.trace("getNextObjectiveId: nsNextObjStore contents for device {}: {}", (Object)this.deviceId, this.nsNextObjStore.entrySet().stream().filter(nsStoreEntry -> ((NeighborSetNextObjectiveStoreKey)nsStoreEntry.getKey()).deviceId().equals((Object)this.deviceId)).collect(Collectors.toList()));
            this.createGroupsFromNeighborsets(Collections.singleton(ns), meta, isBos);
            nextId = (Integer)this.nsNextObjStore.get((Object)new NeighborSetNextObjectiveStoreKey(this.deviceId, ns));
            if (nextId == null) {
                log.warn("getNextObjectiveId: unable to create next objective");
                return -1;
            }
            log.debug("getNextObjectiveId in device{}: Next objective id {} created for {}", new Object[]{this.deviceId, nextId, ns});
        } else {
            log.trace("getNextObjectiveId in device{}: Next objective id {} found for {}", new Object[]{this.deviceId, nextId, ns});
        }
        return nextId;
    }

    public int getVlanNextObjectiveId(VlanId vlanId) {
        Integer nextId = (Integer)this.vlanNextObjStore.get((Object)new VlanNextObjectiveStoreKey(this.deviceId, vlanId));
        return nextId != null ? nextId : -1;
    }

    public int getPortNextObjectiveId(PortNumber portNum, TrafficTreatment treatment, TrafficSelector meta, boolean createIfMissing) {
        Integer nextId = (Integer)this.portNextObjStore.get((Object)new PortNextObjectiveStoreKey(this.deviceId, portNum, treatment, meta));
        if (nextId != null) {
            return nextId;
        }
        log.debug("getPortNextObjectiveId in device {}: Next objective id not found for port: {} .. {}", new Object[]{this.deviceId, portNum, createIfMissing ? "creating" : "aborting"});
        if (!createIfMissing) {
            return -1;
        }
        this.createGroupFromPort(portNum, treatment, meta);
        nextId = (Integer)this.portNextObjStore.get((Object)new PortNextObjectiveStoreKey(this.deviceId, portNum, treatment, meta));
        if (nextId == null) {
            log.warn("getPortNextObjectiveId: unable to create next objfor dev:{} port:{}", (Object)this.deviceId, (Object)portNum);
            return -1;
        }
        return nextId;
    }

    public boolean hasNextObjectiveId(NeighborSet ns) {
        Integer nextId = (Integer)this.nsNextObjStore.get((Object)new NeighborSetNextObjectiveStoreKey(this.deviceId, ns));
        return nextId != null;
    }

    protected void newNeighbor(Link newLink) {
    }

    protected void newPortToExistingNeighbor(Link newLink) {
    }

    protected Set<NeighborSet> computeImpactedNeighborsetForPortEvent(DeviceId impactedNeighbor, Set<DeviceId> updatedNeighbors) {
        return null;
    }

    private void populateNeighborMaps() {
        Set outgoingLinks = this.linkService.getDeviceEgressLinks(this.deviceId);
        for (Link link : outgoingLinks) {
            if (link.type() != Link.Type.DIRECT) continue;
            this.addNeighborAtPort(link.dst().deviceId(), link.src().port());
        }
    }

    protected void addNeighborAtPort(DeviceId neighborId, PortNumber portToNeighbor) {
        DeviceId prev;
        log.debug("Device {} addNeighborAtPort: neighbor {} at port {}", new Object[]{this.deviceId, neighborId, portToNeighbor});
        Set ports = Collections.newSetFromMap(new ConcurrentHashMap());
        ports.add(portToNeighbor);
        Set portnums = this.devicePortMap.putIfAbsent(neighborId, ports);
        if (portnums != null) {
            portnums.add(portToNeighbor);
        }
        if ((prev = this.portDeviceMap.putIfAbsent(portToNeighbor, neighborId)) != null) {
            log.warn("Device: {} port: {} has neighbor: {}. NOT updating to neighbor: {}", new Object[]{this.deviceId, portToNeighbor, prev, neighborId});
        }
    }

    protected Set<Set<DeviceId>> getPowerSetOfNeighbors(Set<DeviceId> neighbors) {
        ArrayList<DeviceId> list = new ArrayList<DeviceId>(neighbors);
        HashSet<Set<DeviceId>> sets = new HashSet<Set<DeviceId>>();
        int elements = list.size();
        int powerElements = 1 << elements;
        for (long i = 1L; i < (long)powerElements; ++i) {
            HashSet neighborSubSet = new HashSet();
            for (int j = 0; j < elements; ++j) {
                if ((i >> j) % 2L != 1L) continue;
                neighborSubSet.add(list.get(j));
            }
            sets.add(neighborSubSet);
        }
        return sets;
    }

    private boolean isSegmentIdSameAsNodeSegmentId(DeviceId deviceId, int sId) {
        int segmentId;
        try {
            segmentId = this.deviceConfig.getIPv4SegmentId(deviceId);
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting isSegmentIdSameAsNodeSegmentId.");
            return false;
        }
        return segmentId == sId;
    }

    protected List<Integer> getSegmentIdsTobePairedWithNeighborSet(Set<DeviceId> neighbors) {
        ArrayList<Integer> nsSegmentIds = new ArrayList<Integer>();
        nsSegmentIds.add(-1);
        for (Integer sId : this.allSegmentIds) {
            if (sId.equals(this.ipv4NodeSegmentId)) continue;
            boolean filterOut = false;
            for (DeviceId deviceId : neighbors) {
                if (!this.isSegmentIdSameAsNodeSegmentId(deviceId, sId)) continue;
                filterOut = true;
                break;
            }
            if (filterOut) continue;
            nsSegmentIds.add(sId);
        }
        return nsSegmentIds;
    }

    public void createGroupsFromNeighborsets(Set<NeighborSet> nsSet, TrafficSelector meta, boolean isBos) {
        for (NeighborSet ns : nsSet) {
            int nextId = this.flowObjectiveService.allocateNextId();
            NextObjective.Type type = NextObjective.Type.HASHED;
            Set<DeviceId> neighbors = ns.getDeviceIds();
            if (!isBos && !this.srManager.getMplsEcmp()) {
                type = NextObjective.Type.SIMPLE;
                neighbors = Collections.singleton(ns.getFirstNeighbor());
            }
            DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(nextId).withType(type).fromApp(this.appId);
            for (DeviceId neighborId : neighbors) {
                MacAddress neighborMac;
                if (this.devicePortMap.get(neighborId) == null) {
                    log.warn("Neighbor {} is not in the port map yet for dev:{}", (Object)neighborId, (Object)this.deviceId);
                    return;
                }
                if (this.devicePortMap.get(neighborId).isEmpty()) {
                    log.warn("There are no ports for the Device {} in the port map yet", (Object)neighborId);
                    return;
                }
                try {
                    neighborMac = this.deviceConfig.getDeviceMac(neighborId);
                }
                catch (DeviceConfigNotFoundException e) {
                    log.warn(e.getMessage() + " Aborting createGroupsFromNeighborsets.");
                    return;
                }
                Set<Object> neighborPorts = this.devicePortMap.get(neighborId);
                if (!isBos && !this.srManager.getMplsEcmp()) {
                    int size = this.devicePortMap.get(neighborId).size();
                    int index = RandomUtils.nextInt((int)0, (int)size);
                    neighborPorts = Collections.singleton(Iterables.get((Iterable)this.devicePortMap.get(neighborId), (int)index));
                }
                for (PortNumber sp : neighborPorts) {
                    TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
                    tBuilder.setEthDst(neighborMac).setEthSrc(this.nodeMacAddr);
                    if (ns.getEdgeLabel() != -1) {
                        tBuilder.pushMpls().copyTtlOut().setMpls(MplsLabel.mplsLabel((int)ns.getEdgeLabel()));
                    }
                    tBuilder.setOutput(sp);
                    nextObjBuilder.addTreatment(tBuilder.build());
                }
            }
            if (meta != null) {
                nextObjBuilder.withMeta(meta);
            }
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("createGroupsFromNeighborsets installed NextObj {} on {}", (Object)nextId, (Object)this.deviceId), (objective, error) -> log.warn("createGroupsFromNeighborsets failed to install NextObj {} on {}: {}", new Object[]{nextId, this.deviceId, error}));
            NextObjective nextObj = nextObjBuilder.add((ObjectiveContext)context);
            log.debug("**createGroupsFromNeighborsets: Submitted next objective {} in device {}", (Object)nextId, (Object)this.deviceId);
            this.flowObjectiveService.next(this.deviceId, nextObj);
            this.nsNextObjStore.put((Object)new NeighborSetNextObjectiveStoreKey(this.deviceId, ns), (Object)nextId);
        }
    }

    public void createGroupsFromVlanConfig() {
        this.srManager.getVlanPortMap(this.deviceId).asMap().forEach((vlanId, ports) -> this.createBcastGroupFromVlan((VlanId)vlanId, (Collection<PortNumber>)ports));
    }

    public void createBcastGroupFromVlan(VlanId vlanId, Collection<PortNumber> ports) {
        VlanNextObjectiveStoreKey key = new VlanNextObjectiveStoreKey(this.deviceId, vlanId);
        if (this.vlanNextObjStore.containsKey((Object)key)) {
            log.debug("Broadcast group for device {} and subnet {} exists", (Object)this.deviceId, (Object)vlanId);
            return;
        }
        TrafficSelector metadata = DefaultTrafficSelector.builder().matchVlanId(vlanId).build();
        int nextId = this.flowObjectiveService.allocateNextId();
        DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(nextId).withType(NextObjective.Type.BROADCAST).fromApp(this.appId).withMeta(metadata);
        ports.forEach(arg_0 -> this.lambda$createBcastGroupFromVlan$16(vlanId, (NextObjective.Builder)nextObjBuilder, arg_0));
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("createBroadcastGroupFromVlan installed NextObj {} on {}", (Object)nextId, (Object)this.deviceId), (objective, error) -> log.warn("createBroadcastGroupFromVlan failed to install NextObj {} on {}: {}", new Object[]{nextId, this.deviceId, error}));
        NextObjective nextObj = nextObjBuilder.add((ObjectiveContext)context);
        this.flowObjectiveService.next(this.deviceId, nextObj);
        log.debug("createBcastGroupFromVlan: Submited next objective {} in device {}", (Object)nextId, (Object)this.deviceId);
        this.vlanNextObjStore.put((Object)key, (Object)nextId);
    }

    private boolean toPopVlan(PortNumber portNumber, VlanId vlanId) {
        return this.srManager.interfaceService.getInterfacesByPort(new ConnectPoint((ElementId)this.deviceId, portNumber)).stream().noneMatch(intf -> intf.vlanTagged().contains(vlanId));
    }

    public void createGroupFromPort(PortNumber portNum, TrafficTreatment treatment, TrafficSelector meta) {
        int nextId = this.flowObjectiveService.allocateNextId();
        PortNextObjectiveStoreKey key = new PortNextObjectiveStoreKey(this.deviceId, portNum, treatment, meta);
        DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(nextId).withType(NextObjective.Type.SIMPLE).addTreatment(treatment).fromApp(this.appId).withMeta(meta);
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("createGroupFromPort installed NextObj {} on {}", (Object)nextId, (Object)this.deviceId), (objective, error) -> log.warn("createGroupFromPort failed to install NextObj {} on {}: {}", new Object[]{nextId, this.deviceId, error}));
        NextObjective nextObj = nextObjBuilder.add((ObjectiveContext)context);
        this.flowObjectiveService.next(this.deviceId, nextObj);
        log.debug("createGroupFromPort: Submited next objective {} in device {} for port {}", new Object[]{nextId, this.deviceId, portNum});
        this.portNextObjStore.put((Object)key, (Object)nextId);
    }

    public boolean removeGroup(int objectiveId) {
        if (this.nsNextObjStore.containsValue((Object)objectiveId)) {
            DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(objectiveId).withType(NextObjective.Type.HASHED).fromApp(this.appId);
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("RemoveGroup removes NextObj {} on {}", (Object)objectiveId, (Object)this.deviceId), (objective, error) -> log.warn("RemoveGroup failed to remove NextObj {} on {}: {}", new Object[]{objectiveId, this.deviceId, error}));
            NextObjective nextObjective = nextObjBuilder.remove((ObjectiveContext)context);
            log.info("**removeGroup: Submited next objective {} in device {}", (Object)objectiveId, (Object)this.deviceId);
            this.flowObjectiveService.next(this.deviceId, nextObjective);
            for (Map.Entry entry : this.nsNextObjStore.entrySet()) {
                if (!((Integer)entry.getValue()).equals(objectiveId)) continue;
                this.nsNextObjStore.remove(entry.getKey());
                break;
            }
            return true;
        }
        return false;
    }

    public void removeAllGroups() {
        for (Map.Entry entry : this.nsNextObjStore.entrySet()) {
            this.removeGroup((Integer)entry.getValue());
        }
        for (Map.Entry entry : this.portNextObjStore.entrySet()) {
            this.removeGroup((Integer)entry.getValue());
        }
        for (Map.Entry entry : this.vlanNextObjStore.entrySet()) {
            this.removeGroup((Integer)entry.getValue());
        }
    }

    private /* synthetic */ void lambda$createBcastGroupFromVlan$16(VlanId vlanId, NextObjective.Builder nextObjBuilder, PortNumber port) {
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
        if (this.toPopVlan(port, vlanId)) {
            tBuilder.popVlan();
        }
        tBuilder.setOutput(port);
        nextObjBuilder.addTreatment(tBuilder.build());
    }

    protected final class RetryHashBkts
    implements Runnable {
        Link link;
        MacAddress dstMac;

        private RetryHashBkts(Link link, MacAddress dstMac) {
            this.link = link;
            this.dstMac = dstMac;
        }

        @Override
        public void run() {
            log.debug("RETRY Hash buckets for linkup: {}", (Object)this.link);
            Set nsSet = DefaultGroupHandler.this.nsNextObjStore.keySet().stream().filter(nsStoreEntry -> nsStoreEntry.deviceId().equals((Object)DefaultGroupHandler.this.deviceId)).map(nsStoreEntry -> nsStoreEntry.neighborSet()).filter(ns -> ns.getDeviceIds().contains(this.link.dst().deviceId())).collect(Collectors.toSet());
            log.debug("retry-link: nsNextObjStore contents for device {}: {}", (Object)DefaultGroupHandler.this.deviceId, nsSet);
            for (NeighborSet ns2 : nsSet) {
                Integer nextId = (Integer)DefaultGroupHandler.this.nsNextObjStore.get((Object)new NeighborSetNextObjectiveStoreKey(DefaultGroupHandler.this.deviceId, ns2));
                if (nextId == null) continue;
                DefaultGroupHandler.this.addToHashedNextObjective(this.link.src().port(), this.dstMac, ns2, nextId, true);
            }
        }
    }
}

