/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.grouphandler;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.link.LinkService;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.DeviceProperties;
import org.onosproject.segmentrouting.grouphandler.DefaultGroupHandler;
import org.onosproject.segmentrouting.grouphandler.NeighborSet;

public class DefaultEdgeGroupHandler
extends DefaultGroupHandler {
    protected DefaultEdgeGroupHandler(DeviceId deviceId, ApplicationId appId, DeviceProperties config, LinkService linkService, FlowObjectiveService flowObjService, SegmentRoutingManager srManager) {
        super(deviceId, appId, config, linkService, flowObjService, srManager);
    }

    @Override
    public void createGroups() {
        log.debug("Creating default groups for edge device {}", (Object)this.deviceId);
        Set neighbors = this.devicePortMap.keySet();
        if (neighbors == null || neighbors.isEmpty()) {
            return;
        }
        Set<Set<DeviceId>> powerSet = this.getPowerSetOfNeighbors(neighbors);
        log.trace("createGroupsAtEdgeRouter: The size of neighbor powerset for sw {} is {}", (Object)this.deviceId, (Object)powerSet.size());
        HashSet<NeighborSet> nsSet = new HashSet<NeighborSet>();
        for (Set<DeviceId> combo : powerSet) {
            if (combo.isEmpty()) continue;
            List<Integer> groupSegmentIds = this.getSegmentIdsTobePairedWithNeighborSet(combo);
            for (Integer sId : groupSegmentIds) {
                NeighborSet ns = new NeighborSet(combo, false, sId);
                log.trace("createGroupsAtEdgeRouter: sw {} combo {} sId {} ns {}", new Object[]{this.deviceId, combo, sId, ns});
                nsSet.add(ns);
            }
        }
        log.trace("createGroupsAtEdgeRouter: The neighborset with label for sw {} is {}", (Object)this.deviceId, nsSet);
    }

    @Override
    protected void newNeighbor(Link newNeighborLink) {
        log.debug("New Neighbor: Updating groups for edge device {}", (Object)this.deviceId);
        this.addNeighborAtPort(newNeighborLink.dst().deviceId(), newNeighborLink.src().port());
        Set<NeighborSet> nsSet = this.computeImpactedNeighborsetForPortEvent(newNeighborLink.dst().deviceId(), this.devicePortMap.keySet());
    }

    @Override
    protected void newPortToExistingNeighbor(Link newNeighborLink) {
    }

    @Override
    protected Set<NeighborSet> computeImpactedNeighborsetForPortEvent(DeviceId impactedNeighbor, Set<DeviceId> updatedNeighbors) {
        Set<Set<DeviceId>> powerSet = this.getPowerSetOfNeighbors(updatedNeighbors);
        HashSet<DeviceId> tmp = new HashSet<DeviceId>();
        tmp.addAll(updatedNeighbors);
        tmp.remove(impactedNeighbor);
        Set<Set<DeviceId>> tmpPowerSet = this.getPowerSetOfNeighbors(tmp);
        powerSet.removeAll(tmpPowerSet);
        HashSet<NeighborSet> nsSet = new HashSet<NeighborSet>();
        for (Set<DeviceId> combo : powerSet) {
            if (combo.isEmpty()) continue;
            List<Integer> groupSegmentIds = this.getSegmentIdsTobePairedWithNeighborSet(combo);
            for (Integer sId : groupSegmentIds) {
                NeighborSet ns = new NeighborSet(combo, false, sId);
                log.trace("computeImpactedNeighborsetForPortEvent: sw {} combo {} sId {} ns {}", new Object[]{this.deviceId, combo, sId, ns});
                nsSet.add(ns);
            }
        }
        log.trace("computeImpactedNeighborsetForPortEvent: The neighborset with label for sw {} is {}", (Object)this.deviceId, nsSet);
        return nsSet;
    }
}

