/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.Config;
import org.onosproject.segmentrouting.storekey.XConnectStoreKey;

public class XConnectConfig
extends Config<ApplicationId> {
    private static final String VLAN = "vlan";
    private static final String PORTS = "ports";
    private static final String NAME = "name";
    private static final String UNEXPECTED_FIELD_NAME = "Unexpected field name";

    public boolean isValid() {
        try {
            this.getXconnects().forEach(this::getPorts);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public Set<XConnectStoreKey> getXconnects() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.object.fields().forEachRemaining(entry -> {
            DeviceId deviceId = DeviceId.deviceId((String)((String)entry.getKey()));
            builder.addAll(this.getXconnects(deviceId));
        });
        return builder.build();
    }

    public Set<XConnectStoreKey> getXconnects(DeviceId deviceId) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        JsonNode vlanPortPair = this.object.get(deviceId.toString());
        if (vlanPortPair != null) {
            vlanPortPair.forEach(jsonNode -> {
                if (!this.hasOnlyFields((ObjectNode)jsonNode, new String[]{VLAN, PORTS, NAME})) {
                    throw new IllegalArgumentException(UNEXPECTED_FIELD_NAME);
                }
                VlanId vlanId = VlanId.vlanId((short)((short)jsonNode.get(VLAN).asInt()));
                builder.add((Object)new XConnectStoreKey(deviceId, vlanId));
            });
        }
        return builder.build();
    }

    public Set<PortNumber> getPorts(XConnectStoreKey xconnect) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.object.get(xconnect.deviceId().toString()).forEach(vlanPortsPair -> {
            if (xconnect.vlanId().toShort() == vlanPortsPair.get(VLAN).asInt()) {
                int portCount = vlanPortsPair.get(PORTS).size();
                Preconditions.checkArgument((portCount == 2 ? 1 : 0) != 0, (Object)("Expect 2 ports but found " + portCount + " on " + xconnect));
                vlanPortsPair.get(PORTS).forEach(portNode -> builder.add((Object)PortNumber.portNumber((long)portNode.asInt())));
            }
        });
        return builder.build();
    }
}

