/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.MacAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.Config;

public class SegmentRoutingDeviceConfig
extends Config<DeviceId> {
    private static final String NAME = "name";
    private static final String IP4 = "ipv4Loopback";
    private static final String IP6 = "ipv6Loopback";
    private static final String MAC = "routerMac";
    private static final String IP4_SID = "ipv4NodeSid";
    private static final String IP6_SID = "ipv6NodeSid";
    private static final String EDGE = "isEdgeRouter";
    private static final String ADJSIDS = "adjacencySids";
    private static final String ADJSID = "adjSid";
    private static final String PORTS = "ports";

    public boolean isValid() {
        return this.hasOnlyFields(new String[]{NAME, IP4, IP6, MAC, IP4_SID, IP6_SID, EDGE, ADJSIDS, ADJSID, PORTS}) && this.name() != null && this.routerIpv4() != null && this.routerMac() != null && this.nodeSidIPv4() != -1 && this.isEdgeRouter() != null && this.adjacencySids() != null;
    }

    public Optional<String> name() {
        String name = this.get(NAME, null);
        return name != null ? Optional.of(name) : Optional.empty();
    }

    public SegmentRoutingDeviceConfig setName(String name) {
        return (SegmentRoutingDeviceConfig)this.setOrClear(NAME, name);
    }

    public Ip4Address routerIpv4() {
        String ip = this.get(IP4, null);
        return ip != null ? Ip4Address.valueOf((String)ip) : null;
    }

    public Ip6Address routerIpv6() {
        String ip = this.get(IP6, null);
        return ip != null ? Ip6Address.valueOf((String)ip) : null;
    }

    public SegmentRoutingDeviceConfig setRouterIpv4(String ip) {
        return (SegmentRoutingDeviceConfig)this.setOrClear(IP4, ip);
    }

    public SegmentRoutingDeviceConfig setRouterIpv6(String ip) {
        return (SegmentRoutingDeviceConfig)this.setOrClear(IP6, ip);
    }

    public MacAddress routerMac() {
        String mac = this.get(MAC, null);
        return mac != null ? MacAddress.valueOf((String)mac) : null;
    }

    public SegmentRoutingDeviceConfig setRouterMac(String mac) {
        return (SegmentRoutingDeviceConfig)this.setOrClear(MAC, mac);
    }

    public int nodeSidIPv4() {
        return this.get(IP4_SID, -1);
    }

    public int nodeSidIPv6() {
        return this.get(IP6_SID, -1);
    }

    public SegmentRoutingDeviceConfig setNodeSidIPv4(int sid) {
        return (SegmentRoutingDeviceConfig)this.setOrClear(IP4_SID, sid);
    }

    public SegmentRoutingDeviceConfig setNodeSidIPv6(int sid) {
        return (SegmentRoutingDeviceConfig)this.setOrClear(IP6_SID, sid);
    }

    public Boolean isEdgeRouter() {
        String isEdgeRouter = this.get(EDGE, null);
        return isEdgeRouter != null ? Boolean.valueOf(isEdgeRouter) : null;
    }

    public SegmentRoutingDeviceConfig setIsEdgeRouter(boolean isEdgeRouter) {
        return (SegmentRoutingDeviceConfig)this.setOrClear(EDGE, isEdgeRouter);
    }

    public Map<Integer, Set<Integer>> adjacencySids() {
        if (!this.object.has(ADJSIDS)) {
            return null;
        }
        HashMap adjacencySids = new HashMap();
        ArrayNode adjacencySidsNode = (ArrayNode)this.object.path(ADJSIDS);
        for (JsonNode adjacencySidNode : adjacencySidsNode) {
            int asid = adjacencySidNode.path(ADJSID).asInt(-1);
            if (asid == -1) {
                return null;
            }
            HashSet<Integer> ports = new HashSet<Integer>();
            ArrayNode portsNode = (ArrayNode)adjacencySidNode.path(PORTS);
            for (JsonNode portNode : portsNode) {
                int port = portNode.asInt(-1);
                if (port == -1) {
                    return null;
                }
                ports.add(port);
            }
            adjacencySids.put(asid, ports);
        }
        return ImmutableMap.copyOf(adjacencySids);
    }

    public SegmentRoutingDeviceConfig setAdjacencySids(Map<Integer, Set<Integer>> adjacencySids) {
        if (adjacencySids == null) {
            this.object.remove(ADJSIDS);
        } else {
            ArrayNode adjacencySidsNode = this.mapper.createArrayNode();
            adjacencySids.forEach((sid, ports) -> {
                ObjectNode adjacencySidNode = this.mapper.createObjectNode();
                adjacencySidNode.put(ADJSID, sid);
                ArrayNode portsNode = this.mapper.createArrayNode();
                ports.forEach(port -> portsNode.add(port.toString()));
                adjacencySidNode.set(PORTS, (JsonNode)portsNode);
                adjacencySidsNode.add((JsonNode)adjacencySidNode);
            });
            this.object.set(ADJSIDS, (JsonNode)adjacencySidsNode);
        }
        return this;
    }
}

